/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonschema.keyword.validator.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonschema.core.exceptions.ProcessingException;
import com.github.fge.jsonschema.core.processing.Processor;
import com.github.fge.jsonschema.core.report.ProcessingReport;
import com.github.fge.jsonschema.core.tree.SchemaTree;
import com.github.fge.jsonschema.keyword.validator.AbstractKeywordValidator;
import com.github.fge.jsonschema.processors.data.FullData;
import com.github.fge.msgsimple.bundle.MessageBundle;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public final class DependenciesValidator
extends AbstractKeywordValidator {
    private final Multimap<String, String> propertyDeps;
    private final Set<String> schemaDeps;

    public DependenciesValidator(JsonNode digest) {
        super("dependencies");
        ImmutableMultimap.Builder<String, String> mapBuilder = ImmutableMultimap.builder();
        Map<String, JsonNode> map = JacksonUtils.asMap(digest.get("propertyDeps"));
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            String key = entry.getKey();
            for (JsonNode element : entry.getValue()) {
                mapBuilder.put(key, element.textValue());
            }
        }
        this.propertyDeps = mapBuilder.build();
        ImmutableSet.Builder setBuilder = ImmutableSet.builder();
        for (JsonNode node : digest.get("schemaDeps")) {
            setBuilder.add(node.textValue());
        }
        this.schemaDeps = setBuilder.build();
    }

    @Override
    public void validate(Processor<FullData, FullData> processor, ProcessingReport report, MessageBundle bundle2, FullData data) throws ProcessingException {
        JsonNode instance = data.getInstance().getNode();
        HashSet<String> fields = Sets.newHashSet(instance.fieldNames());
        for (String field : this.propertyDeps.keySet()) {
            if (!fields.contains(field)) continue;
            Collection<String> collection = this.propertyDeps.get(field);
            LinkedHashSet<String> set = Sets.newLinkedHashSet(collection);
            set.removeAll(fields);
            if (set.isEmpty()) continue;
            report.error(this.newMsg(data, bundle2, "err.common.dependencies.missingPropertyDeps").putArgument("property", field).putArgument("required", DependenciesValidator.toArrayNode(collection)).putArgument("missing", DependenciesValidator.toArrayNode(set)));
        }
        if (this.schemaDeps.isEmpty()) {
            return;
        }
        SchemaTree tree = data.getSchema();
        for (String field : this.schemaDeps) {
            if (!fields.contains(field)) continue;
            JsonPointer pointer = JsonPointer.of(this.keyword, field);
            FullData newData = data.withSchema(tree.append(pointer));
            processor.process(report, newData);
        }
    }

    @Override
    public String toString() {
        return this.keyword + ": " + this.propertyDeps.size() + " property dependencies, " + this.schemaDeps.size() + " schema dependencies";
    }
}

