/*
 * Decompiled with CFR 0.152.
 */
package com.github.fge.jsonpatch.diff;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jackson.JsonNumEquals;
import com.github.fge.jsonpatch.diff.IndexedJsonArray;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

final class LCS {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquals.getInstance();

    private LCS() {
    }

    @VisibleForTesting
    static List<JsonNode> getLCS(JsonNode first, JsonNode second) {
        Preconditions.checkArgument(first.isArray(), "LCS can only work on JSON arrays");
        Preconditions.checkArgument(second.isArray(), "LCS can only work on JSON arrays");
        int minSize = Math.min(first.size(), second.size());
        List<JsonNode> l1 = Lists.newArrayList(first);
        List<JsonNode> l2 = Lists.newArrayList(second);
        List<JsonNode> ret = LCS.head(l1, l2);
        int headSize = ret.size();
        l1 = l1.subList(headSize, l1.size());
        l2 = l2.subList(headSize, l2.size());
        List<JsonNode> tail = LCS.tail(l1, l2);
        int trim = tail.size();
        l1 = l1.subList(0, l1.size() - trim);
        l2 = l2.subList(0, l2.size() - trim);
        if (headSize < minSize) {
            ret.addAll(LCS.doLCS(l1, l2));
        }
        ret.addAll(tail);
        return ret;
    }

    static IndexedJsonArray doLCS(JsonNode first, JsonNode second) {
        return new IndexedJsonArray(LCS.getLCS(first, second));
    }

    private static List<JsonNode> doLCS(List<JsonNode> l1, List<JsonNode> l2) {
        ArrayList<JsonNode> lcs = Lists.newArrayList();
        int size1 = l1.size();
        int size2 = l2.size();
        int[][] lengths = new int[size1 + 1][size2 + 1];
        for (int i = 0; i < size1; ++i) {
            for (int j = 0; j < size2; ++j) {
                JsonNode node2;
                int len;
                JsonNode node1 = l1.get(i);
                lengths[i + 1][j + 1] = len = EQUIVALENCE.equivalent(node1, node2 = l2.get(j)) ? lengths[i][j] + 1 : Math.max(lengths[i + 1][j], lengths[i][j + 1]);
            }
        }
        int x = size1;
        int y = size2;
        while (x > 0 && y > 0) {
            if (lengths[x][y] == lengths[x - 1][y]) {
                --x;
                continue;
            }
            if (lengths[x][y] == lengths[x][y - 1]) {
                --y;
                continue;
            }
            lcs.add(l1.get(x - 1));
            --x;
            --y;
        }
        return Lists.reverse(lcs);
    }

    private static List<JsonNode> head(List<JsonNode> l1, List<JsonNode> l2) {
        JsonNode node;
        ArrayList<JsonNode> ret = Lists.newArrayList();
        int len = Math.min(l1.size(), l2.size());
        for (int index = 0; index < len && EQUIVALENCE.equivalent(node = l1.get(index), l2.get(index)); ++index) {
            ret.add(node);
        }
        return ret;
    }

    private static List<JsonNode> tail(List<JsonNode> l1, List<JsonNode> l2) {
        List<JsonNode> l = LCS.head(Lists.reverse(l1), Lists.reverse(l2));
        return Lists.reverse(l);
    }
}

