/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.jvm;

import com.codahale.metrics.RatioGauge;
import com.sun.management.UnixOperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;

public class FileDescriptorRatioGauge
extends RatioGauge {
    private static boolean unixOperatingSystemMXBeanExists = false;
    private final OperatingSystemMXBean os;

    public FileDescriptorRatioGauge() {
        this(ManagementFactory.getOperatingSystemMXBean());
    }

    public FileDescriptorRatioGauge(OperatingSystemMXBean os) {
        this.os = os;
    }

    @Override
    protected RatioGauge.Ratio getRatio() {
        if (unixOperatingSystemMXBeanExists && this.os instanceof UnixOperatingSystemMXBean) {
            UnixOperatingSystemMXBean unixOs = (UnixOperatingSystemMXBean)this.os;
            return RatioGauge.Ratio.of(unixOs.getOpenFileDescriptorCount(), unixOs.getMaxFileDescriptorCount());
        }
        return RatioGauge.Ratio.of(Double.NaN, Double.NaN);
    }

    static {
        try {
            Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            unixOperatingSystemMXBeanExists = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

