/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.health;

import com.codahale.metrics.health.AsyncHealthCheckDecorator;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckFilter;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.codahale.metrics.health.annotation.Async;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HealthCheckRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(HealthCheckRegistry.class);
    private static final int ASYNC_EXECUTOR_POOL_SIZE = 2;
    private final ConcurrentMap<String, HealthCheck> healthChecks;
    private final List<HealthCheckRegistryListener> listeners;
    private final ScheduledExecutorService asyncExecutorService;
    private final Object lock = new Object();

    public HealthCheckRegistry() {
        this(2);
    }

    public HealthCheckRegistry(int asyncExecutorPoolSize) {
        this(HealthCheckRegistry.createExecutorService(asyncExecutorPoolSize));
    }

    public HealthCheckRegistry(ScheduledExecutorService asyncExecutorService) {
        this.healthChecks = new ConcurrentHashMap<String, HealthCheck>();
        this.listeners = new CopyOnWriteArrayList<HealthCheckRegistryListener>();
        this.asyncExecutorService = asyncExecutorService;
    }

    public void addListener(HealthCheckRegistryListener listener) {
        this.listeners.add(listener);
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            listener.onHealthCheckAdded((String)entry.getKey(), (HealthCheck)entry.getValue());
        }
    }

    public void removeListener(HealthCheckRegistryListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, HealthCheck healthCheck) {
        HealthCheck registered;
        Object object = this.lock;
        synchronized (object) {
            if (this.healthChecks.containsKey(name)) {
                throw new IllegalArgumentException("A health check named " + name + " already exists");
            }
            registered = healthCheck;
            if (healthCheck.getClass().isAnnotationPresent(Async.class)) {
                registered = new AsyncHealthCheckDecorator(healthCheck, this.asyncExecutorService);
            }
            this.healthChecks.put(name, registered);
        }
        this.onHealthCheckAdded(name, registered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(String name) {
        HealthCheck healthCheck;
        Object object = this.lock;
        synchronized (object) {
            healthCheck = (HealthCheck)this.healthChecks.remove(name);
            if (healthCheck instanceof AsyncHealthCheckDecorator) {
                ((AsyncHealthCheckDecorator)healthCheck).tearDown();
            }
        }
        if (healthCheck != null) {
            this.onHealthCheckRemoved(name, healthCheck);
        }
    }

    public SortedSet<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.healthChecks.keySet()));
    }

    public HealthCheck getHealthCheck(String name) {
        return (HealthCheck)this.healthChecks.get(name);
    }

    public HealthCheck.Result runHealthCheck(String name) throws NoSuchElementException {
        HealthCheck healthCheck = (HealthCheck)this.healthChecks.get(name);
        if (healthCheck == null) {
            throw new NoSuchElementException("No health check named " + name + " exists");
        }
        return healthCheck.execute();
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks() {
        return this.runHealthChecks(HealthCheckFilter.ALL);
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks(HealthCheckFilter filter) {
        TreeMap<String, HealthCheck.Result> results = new TreeMap<String, HealthCheck.Result>();
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            HealthCheck healthCheck;
            String name = (String)entry.getKey();
            if (!filter.matches(name, healthCheck = (HealthCheck)entry.getValue())) continue;
            HealthCheck.Result result = ((HealthCheck)entry.getValue()).execute();
            results.put((String)entry.getKey(), result);
        }
        return Collections.unmodifiableSortedMap(results);
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks(ExecutorService executor) {
        return this.runHealthChecks(executor, HealthCheckFilter.ALL);
    }

    public SortedMap<String, HealthCheck.Result> runHealthChecks(ExecutorService executor, HealthCheckFilter filter) {
        HashMap<String, Future<HealthCheck.Result>> futures = new HashMap<String, Future<HealthCheck.Result>>();
        for (Map.Entry entry : this.healthChecks.entrySet()) {
            HealthCheck healthCheck;
            String name = (String)entry.getKey();
            if (!filter.matches(name, healthCheck = (HealthCheck)entry.getValue())) continue;
            futures.put(name, executor.submit(() -> healthCheck.execute()));
        }
        TreeMap<String, HealthCheck.Result> results = new TreeMap<String, HealthCheck.Result>();
        for (Map.Entry entry : futures.entrySet()) {
            try {
                results.put((String)entry.getKey(), (HealthCheck.Result)((Future)entry.getValue()).get());
            }
            catch (Exception e) {
                LOGGER.warn("Error executing health check {}", entry.getKey(), (Object)e);
                results.put((String)entry.getKey(), HealthCheck.Result.unhealthy(e));
            }
        }
        return Collections.unmodifiableSortedMap(results);
    }

    private void onHealthCheckAdded(String name, HealthCheck healthCheck) {
        for (HealthCheckRegistryListener listener : this.listeners) {
            listener.onHealthCheckAdded(name, healthCheck);
        }
    }

    private void onHealthCheckRemoved(String name, HealthCheck healthCheck) {
        for (HealthCheckRegistryListener listener : this.listeners) {
            listener.onHealthCheckRemoved(name, healthCheck);
        }
    }

    public void shutdown() {
        this.asyncExecutorService.shutdown();
        try {
            if (!this.asyncExecutorService.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.asyncExecutorService.shutdownNow();
            }
        }
        catch (InterruptedException ie) {
            this.asyncExecutorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static ScheduledExecutorService createExecutorService(int corePoolSize) {
        ScheduledThreadPoolExecutor asyncExecutorService = new ScheduledThreadPoolExecutor(corePoolSize, new NamedThreadFactory("healthcheck-async-executor-"));
        asyncExecutorService.setRemoveOnCancelPolicy(true);
        return asyncExecutorService;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String namePrefix) {
            SecurityManager s2 = System.getSecurityManager();
            this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

