/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.AbstractColumn;
import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.impl.MetaDataBuilder;
import io.vavr.collection.Array;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public final class TimestampColumn
extends AbstractColumn<Instant, ColumnIds.TimestampColumnId> {
    private TimestampColumn(ColumnIds.TimestampColumnId id, Array<Instant> values, Map<String, String> metaData) {
        super(id, values, metaData);
    }

    public static TimestampColumn of(ColumnIds.TimestampColumnId id, Instant value) {
        return TimestampColumn.builder(id).add(value).build();
    }

    public static TimestampColumn ofAll(ColumnIds.TimestampColumnId id, Instant ... values) {
        return TimestampColumn.builder(id).addAll(values).build();
    }

    public static TimestampColumn ofAll(ColumnIds.TimestampColumnId id, Iterable<Instant> values) {
        return TimestampColumn.builder(id).addAll(values).build();
    }

    public static Builder builder(ColumnIds.TimestampColumnId id) {
        return new Builder(id);
    }

    public static final class Builder
    implements Column.Builder<Instant, TimestampColumn> {
        private final ColumnIds.TimestampColumnId id;
        private final List<Instant> values;
        private final MetaDataBuilder metaDataBuilder;

        private Builder(ColumnIds.TimestampColumnId id) {
            this.id = id;
            this.values = new ArrayList<Instant>();
            this.metaDataBuilder = new MetaDataBuilder();
        }

        public Builder add(Instant value) {
            this.values.add(value);
            return this;
        }

        public Builder addAll(Instant ... values) {
            return this.addAll(Stream.of(values));
        }

        public Builder addAll(Iterable<Instant> values) {
            this.values.addAll(Stream.ofAll(values).toJavaList());
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.putMetaData(key, value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAllMetaData(metaData);
            return this;
        }

        @Override
        public TimestampColumn build() {
            return new TimestampColumn(this.id, Array.ofAll(this.values), this.metaDataBuilder.build());
        }
    }
}

