/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.impl.MetaDataBuilder;
import io.vavr.collection.Map;
import java.util.Arrays;
import java.util.stream.IntStream;

public final class IntColumn
implements Column<ColumnIds.IntColumnId> {
    private final ColumnIds.IntColumnId id;
    private final int[] values;
    private final Map<String, String> metaData;

    private IntColumn(ColumnIds.IntColumnId id, IntStream values, Map<String, String> metaData) {
        this.id = id;
        this.values = values.toArray();
        this.metaData = metaData;
    }

    public static IntColumn of(ColumnIds.IntColumnId id, int value) {
        return IntColumn.builder(id).add(value).build();
    }

    public static IntColumn ofAll(ColumnIds.IntColumnId id, int ... values) {
        return IntColumn.builder(id).addAll(values).build();
    }

    public static IntColumn ofAll(ColumnIds.IntColumnId id, IntStream values) {
        return IntColumn.builder(id).addAll(values).build();
    }

    public static Builder builder(ColumnIds.IntColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.IntColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.values.length;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public int getValueAt(int index) {
        return this.values[index];
    }

    public IntStream valueStream() {
        return Arrays.stream(this.values);
    }

    public static final class Builder
    implements Column.Builder<Integer, IntColumn> {
        private final ColumnIds.IntColumnId id;
        private final IntStream.Builder valueBuilder;
        private final MetaDataBuilder metaDataBuilder;

        private Builder(ColumnIds.IntColumnId id) {
            this.id = id;
            this.valueBuilder = IntStream.builder();
            this.metaDataBuilder = new MetaDataBuilder();
        }

        public Builder add(Integer value) {
            this.valueBuilder.add(value);
            return this;
        }

        public Builder addAll(int ... values) {
            return this.addAll(Arrays.stream(values));
        }

        public Builder addAll(IntStream values) {
            values.forEachOrdered(this::add);
            return this;
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.putMetaData(key, value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAllMetaData(metaData);
            return this;
        }

        @Override
        public IntColumn build() {
            return new IntColumn(this.id, this.valueBuilder.build(), this.metaDataBuilder.build());
        }
    }
}

