/*
 * Decompiled with CFR 0.152.
 */
package ch.netzwerg.paleo;

import ch.netzwerg.paleo.Column;
import ch.netzwerg.paleo.ColumnIds;
import ch.netzwerg.paleo.impl.MetaDataBuilder;
import io.vavr.collection.Map;
import io.vavr.collection.Stream;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicInteger;

public final class BooleanColumn
implements Column<ColumnIds.BooleanColumnId> {
    private final ColumnIds.BooleanColumnId id;
    private final int rowCount;
    private final BitSet values;
    private final Map<String, String> metaData;

    private BooleanColumn(ColumnIds.BooleanColumnId id, int rowCount, BitSet values, Map<String, String> metaData) {
        this.id = id;
        this.rowCount = rowCount;
        this.values = (BitSet)values.clone();
        this.metaData = metaData;
    }

    public static BooleanColumn of(ColumnIds.BooleanColumnId id, boolean value) {
        return BooleanColumn.builder(id).add(value).build();
    }

    public static BooleanColumn ofAll(ColumnIds.BooleanColumnId id, boolean ... values) {
        return BooleanColumn.builder(id).addAll(values).build();
    }

    public static BooleanColumn ofAll(ColumnIds.BooleanColumnId id, Iterable<Boolean> values) {
        return BooleanColumn.builder(id).addAll(values).build();
    }

    public static Builder builder(ColumnIds.BooleanColumnId id) {
        return new Builder(id);
    }

    @Override
    public ColumnIds.BooleanColumnId getId() {
        return this.id;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public Map<String, String> getMetaData() {
        return this.metaData;
    }

    public boolean getValueAt(int rowIndex) {
        return this.values.get(rowIndex);
    }

    public Stream<Boolean> valueStream() {
        return Stream.range(0, this.rowCount).map(this.values::get);
    }

    public static final class Builder
    implements Column.Builder<Boolean, BooleanColumn> {
        private final ColumnIds.BooleanColumnId id;
        private final AtomicInteger rowIndex;
        private final BitSet values;
        private final MetaDataBuilder metaDataBuilder;

        private Builder(ColumnIds.BooleanColumnId id) {
            this.id = id;
            this.rowIndex = new AtomicInteger();
            this.values = new BitSet();
            this.metaDataBuilder = new MetaDataBuilder();
        }

        public Builder add(Boolean value) {
            this.values.set(this.rowIndex.getAndIncrement(), value);
            return this;
        }

        public Builder addAll(boolean ... values) {
            return this.addAll(Stream.ofAll(values));
        }

        public Builder addAll(Iterable<Boolean> values) {
            return Stream.ofAll(values).foldLeft(this, Builder::add);
        }

        public Builder putMetaData(String key, String value) {
            this.metaDataBuilder.putMetaData(key, value);
            return this;
        }

        public Builder putAllMetaData(Map<String, String> metaData) {
            this.metaDataBuilder.putAllMetaData(metaData);
            return this;
        }

        @Override
        public BooleanColumn build() {
            return new BooleanColumn(this.id, this.rowIndex.get(), this.values, this.metaDataBuilder.build());
        }
    }
}

