/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types.shim;

import nextflow.script.dsl.Description;
import nextflow.script.types.shim.List;
import nextflow.script.types.shim.ShimType;

@Description(value="    A string is an immutable sequence of characters.\n\n    [Read more](https://nextflow.io/docs/latest/reference/stdlib.html#string)\n")
@ShimType(value=java.lang.String.class)
public interface String {
    @Description(value="    Returns `true` if the string ends with the given suffix.\n")
    public boolean endsWith(String var1);

    @Description(value="    Execute the string as a command. Returns a [Process](https://docs.groovy-lang.org/latest/html/groovy-jdk/java/lang/Process.html) which provides the exit status and standard input/output/error of the executed command.\n")
    public Process execute();

    @Description(value="    Returns the index within the string of the first occurrence of the given substring. Returns -1 if the string does not contain the substring.\n")
    public int indexOf(String var1);

    @Description(value="    Returns the index within the string of the first occurrence of the given substring, starting the search at the given index. Returns -1 if the string does not contain the substring.\n")
    public int indexOf(String var1, int var2);

    @Description(value="    Returns `true` if the string is empty or contains only whitespace characters.\n")
    public boolean isBlank();

    @Description(value="    Returns `true` if the string is empty (i.e. `length()` is 0).\n")
    public boolean isEmpty();

    @Description(value="    Returns `true` if the string can be parsed as a floating-point number.\n")
    public boolean isFloat();

    @Description(value="    Returns `true` if the string can be parsed as an integer.\n")
    public boolean isInteger();

    @Description(value="    Returns the index within the string of the last occurrence of the given substring. Returns -1 if the string does not contain the substring.\n")
    public int lastIndexOf(String var1);

    @Description(value="    Returns the index within the string of the last occurrence of the given substring, searching backwards starting at the given index. Returns -1 if the string does not contain the substring.\n")
    public int lastIndexOf(String var1, int var2);

    @Description(value="    Returns the length of the string.\n")
    public int length();

    @Description(value="    Returns the MD5 checksum of the string.\n")
    public String md5();

    @Description(value="    Returns a new string in which each occurrence of the target string is replaced with the given replacement string.\n")
    public String replace(String var1, String var2);

    @Description(value="    Returns a new string in which each occurrence of the given regular expression is replaced with the given replacement string.\n")
    public String replaceAll(String var1, String var2);

    @Description(value="    Returns a new string in which the first occurrence of the given regular expression is replaced with the given replacement string.\n")
    public String replaceFirst(String var1, String var2);

    @Description(value="    Returns the SHA-256 checksum of the string.\n")
    public String sha256();

    @Description(value="    Returns `true` if the string ends with the given prefix.\n")
    public boolean startsWith(String var1);

    @Description(value="    Returns a copy of the string with all leading and trailing whitespace removed.\n")
    public String strip();

    @Description(value="    Returns a copy of the string with leading spaces on each line removed. The number of spaces to remove is determined by the line with the least number of leading spaces, excluding lines with only whitespace.\n")
    public String stripIndent();

    @Description(value="    Returns a copy of the string with all leading whitespace removed.\n")
    public String stripLeading();

    @Description(value="    Returns a copy of the string with all trailing whitespace removed.\n")
    public String stripTrailing();

    @Description(value="    Returns a substring of this string.\n")
    public String substring(int var1);

    @Description(value="    Returns a substring of this string.\n")
    public String substring(int var1, int var2);

    @Description(value="    Returns `true` if the trimmed string is \"true\", \"y\", or \"1\" (ignoring case).\n")
    public Boolean toBoolean();

    @Description(value="    Parses the string into a floating-point number.\n")
    public Float toFloat();

    @Description(value="    Parses the string into an integer.\n")
    public Integer toInteger();

    @Description(value="    Returns a copy of this string with all characters converted to lower case.\n")
    public String toLowerCase();

    @Description(value="    Returns a copy of this string with all characters converted to upper case.\n")
    public String toUpperCase();

    @Description(value="    Splits the string into a list of substrings using the given delimiters. Each character in the delimiter string is treated as a separate delimiter.\n")
    public List<String> tokenize(String var1);
}

