/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types.shim;

import java.util.function.Consumer;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.types.shim.List;
import nextflow.script.types.shim.Map;
import nextflow.script.types.shim.ShimType;
import nextflow.script.types.shim.String;

@Description(value="    A Path is a handle for hierarchichal paths such as local files and directories, HTTP/FTP URLs, and object storage paths (e.g. Amazon S3).\n\n    [Read more](https://nextflow.io/docs/latest/reference/stdlib.html#path)\n")
@ShimType(value=java.nio.file.Path.class)
public interface Path {
    @Description(value="    Returns `true` if the file exists.\n")
    public boolean exists();

    @Description(value="    Gets the file name without its extension, e.g. `/some/path/file.tar.gz` -> `file.tar`.\n")
    public String getBaseName();

    @Constant(value="extension")
    @Description(value="    Gets the file extension, e.g. `/some/path/file.txt` -> `txt`.\n")
    public String getExtension();

    @Constant(value="name")
    @Description(value="    Gets the file name, e.g. `/some/path/file.txt` -> `file.txt`.\n")
    public String getName();

    @Description(value="    Gets the file name without any extension, e.g. `/some/path/file.tar.gz` -> `file`.\n")
    public String getSimpleName();

    @Constant(value="parent")
    @Description(value="    Gets the file parent path, e.g. `/some/path/file.txt` -> `/some/path`.\n")
    public Path getParent();

    @Constant(value="scheme")
    @Description(value="    Gets the file URI scheme, e.g. `s3://some-bucket/foo.txt` -> `s3`.\n")
    public String getScheme();

    @Description(value="    Returns `true` if the file is a directory.\n")
    public boolean isDirectory();

    @Description(value="    Returns `true` if the file is empty or does not exist.\n")
    public boolean isEmpty();

    @Description(value="    Returns `true` if it is a regular file (i.e. not a directory).\n")
    public boolean isFile();

    @Description(value="    Returns `true` if the file is hidden.\n")
    public boolean isHidden();

    @Description(value="    Returns `true` if the file is a symbolic link.\n")
    public boolean isLink();

    @Description(value="    Returns the file last modified timestamp in Unix time (i.e. milliseconds since January 1, 1970).\n")
    public long lastModified();

    @Description(value="    Gets the file size in bytes.\n")
    public long size();

    @Description(value="    Gets the file path along with the protocol scheme.\n")
    public String toUriString();

    @Description(value="    Iterates over the file, applying the specified closure to each byte.\n")
    public void eachByte(Consumer<Byte> var1);

    @Description(value="    Iterates over the file, applying the specified closure to each line.\n")
    public void eachLine(Consumer<String> var1);

    @Constant(value="bytes")
    @Description(value="    Returns the file content as a byte array.\n")
    public byte[] getBytes();

    @Constant(value="text")
    @Description(value="    Returns the file content as a string.\n")
    public String getText();

    @Description(value="    Reads the file line by line and returns the content as a list of strings.\n")
    public List<String> readLines();

    @Description(value="    Appends text to a file without replacing existing content.\n")
    public void append(String var1);

    @Description(value="    Writes a byte array to a file. Equivalent to setting the `bytes` property.\n")
    public void setBytes(byte[] var1);

    @Description(value="    Writes text to a file. Equivalent to setting the `text` property.\n")
    public void setText(String var1);

    @Description(value="    Writes a string to a file, replacing any existing content.\n")
    public void write(String var1);

    @Description(value="    Copies a source file or directory to a target file or directory.\n")
    public void copyTo(Path var1);

    @Description(value="    Deletes the file or directory at the given path, returning `true` if the operation succeeds, and `false` otherwise.\n")
    public boolean delete();

    @Description(value="    Deletes a directory and all of its contents.\n")
    public boolean deleteDir();

    @Description(value="    Returns a file's permissions using the [symbolic notation](http://en.wikipedia.org/wiki/File_system_permissions#Symbolic_notation), e.g. `'rw-rw-r--'`.\n")
    public String getPermissions();

    @Description(value="    Returns the first-level elements (files and directories) of a directory as a list of strings.\n")
    public List<String> list();

    @Description(value="    Returns the first-level elements (files and directories) of a directory as a list of Paths.\n")
    public List<Path> listFiles();

    @Description(value="    Creates a directory at the given path, returning `true` if the directory is created successfully, and `false` otherwise.\n")
    public boolean mkdir();

    @Description(value="    Creates a directory at the given path, including any nonexistent parent directories.\n")
    public boolean mkdirs();

    @Description(value="    Creates a *filesystem link* to a given path.\n")
    public Path mklink(Map var1, String var2);

    @Description(value="    Moves a source file or directory to a target file or directory. Follows the same semantics as `copyTo()`.\n")
    public void moveTo(Path var1);

    @Description(value="    Rename a file or directory.\n")
    public boolean renameTo(String var1);

    @Description(value="    Sets a file's permissions using the [symbolic notation](http://en.wikipedia.org/wiki/File_system_permissions#Symbolic_notation).\n")
    public boolean setPermissions(String var1);

    @Description(value="    Sets a file's permissions using the [numeric notation](http://en.wikipedia.org/wiki/File_system_permissions#Numeric_notation), i.e. as three digits representing the **owner**, **group**, and **other** permissions.\n")
    public boolean setPermissions(int var1, int var2, int var3);

    @Description(value="    Iterates through first-level directories only.\n")
    public void eachDir(Consumer<Path> var1);

    @Description(value="    Iterates through directories whose names match the given filter.\n")
    public void eachDirMatch(String var1, Consumer<Path> var2);

    @Description(value="    Iterates through directories depth-first (regular files are ignored).\n")
    public void eachDirRecurse(Consumer<Path> var1);

    @Description(value="    Iterates through first-level files and directories.\n")
    public void eachFile(Consumer<Path> var1);

    @Description(value="    Iterates through files and directories whose names match the given filter.\n")
    public void eachFileMatch(String var1, Consumer<Path> var2);

    @Description(value="    Iterates through files and directories depth-first.\n")
    public void eachFileRecurse(Consumer<Path> var1);

    @Description(value="    Counts the number of records in a [FASTA](https://en.wikipedia.org/wiki/FASTA_format) file. See the {ref}`operator-splitfasta` operator for available options.\n")
    public long countFasta();

    @Description(value="    Counts the number of records in a [FASTQ](https://en.wikipedia.org/wiki/FASTQ_format) file. See the {ref}`operator-splitfastq` operator for available options.\n")
    public long countFastq();

    @Description(value="    Counts the number of records in a JSON file. See the {ref}`operator-splitjson` operator for available options.\n")
    public long countJson();

    @Description(value="    Counts the number of lines in a text file. See the {ref}`operator-splittext` operator for available options.\n")
    public long countLines();

    @Description(value="    Splits a CSV file into a list of records. See the {ref}`operator-splitcsv` operator for available options.\n")
    public List<?> splitCsv();

    @Description(value="    Splits a [FASTA](https://en.wikipedia.org/wiki/FASTA_format) file into a list of records. See the {ref}`operator-splitfasta` operator for available options.\n")
    public List<?> splitFasta();

    @Description(value="    Splits a [FASTQ](https://en.wikipedia.org/wiki/FASTQ_format) file into a list of records. See the {ref}`operator-splitfastq` operator for available options.\n")
    public List<?> splitFastq();

    @Description(value="    Splits a JSON file into a list of records. See the {ref}`operator-splitjson` operator for available options.\n")
    public List<?> splitJson();

    @Description(value="    Splits a text file into a list of lines. See the {ref}`operator-splittext` operator for available options.\n")
    public List<String> splitText();
}

