/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types.shim;

import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import nextflow.script.dsl.Description;
import nextflow.script.types.shim.Bag;
import nextflow.script.types.shim.Iterable;
import nextflow.script.types.shim.Set;
import nextflow.script.types.shim.ShimType;

@Description(value="    A map associates or \"maps\" keys to values. Each key can map to at most one value -- a map cannot contain duplicate keys.\n\n    [Read more](https://nextflow.io/docs/latest/reference/stdlib.html#map-k-v)\n")
@ShimType(value=java.util.Map.class)
public interface Map<K, V> {
    @Description(value="    Returns `true` if any key-value pair in the map satisfies the given condition. The closure should accept two parameters corresponding to the key and value of an entry.\n")
    public boolean any(BiPredicate<K, V> var1);

    @Description(value="    Returns `true` if the map contains a mapping for the given key.\n")
    public boolean containsKey(K var1);

    @Description(value="    Returns `true` if the map maps one or more keys to the given value.\n")
    public boolean containsValue(V var1);

    @Description(value="    Invoke the given closure for each key-value pair in the map. The closure should accept two parameters corresponding to the key and value of an entry.\n")
    public void each(BiConsumer<K, V> var1);

    @Description(value="    Returns a set of the key-value pairs in the map.\n")
    public Set<Entry<K, V>> entrySet();

    @Description(value="    Returns `true` if every key-value pair in the map satisfies the given condition. The closure should accept two parameters corresponding to the key and value of an entry.\n")
    public boolean every(BiPredicate<K, V> var1);

    @Description(value="    Returns `true` if the map is empty.\n")
    public boolean isEmpty();

    @Description(value="    Returns a set of the keys in the map.\n")
    public Set<K> keySet();

    @Description(value="    Returns the number of key-value pairs in the map.\n")
    public int size();

    @Description(value="    Returns a sub-map containing the given keys.\n")
    public Map<K, V> subMap(Iterable<K> var1);

    @Description(value="    Returns a collection of the values in the map.\n")
    public Bag<V> values();

    @Description(value="    A map entry is a key-value pair.\n")
    @ShimType(value=Map.Entry.class)
    public static interface Entry<K, V> {
        public K getKey();

        public V getValue();
    }
}

