/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types.shim;

import groovy.lang.Tuple2;
import java.util.function.Predicate;
import nextflow.script.dsl.Description;
import nextflow.script.types.shim.Iterable;
import nextflow.script.types.shim.ShimType;

@Description(value="    A list is an unordered collection of elements.\n\n    [Read more](https://nextflow.io/docs/latest/reference/stdlib.html#list-e)\n")
@ShimType(value=java.util.List.class)
public interface List<E>
extends Iterable<E> {
    @Description(value="    Collates the list into a list of sub-lists of length `size`. If `keepRemainder` is `true`, any remaining elements are included as a partial sub-list, otherwise they are excluded.\n")
    public List<List<E>> collate(int var1, boolean var2);

    @Description(value="    Collates the list into a list of sub-lists of length `size`, stepping through the list `step` elements for each sub-list. If `keepRemainder` is `true`, any remaining elements are included as a partial sub-list, otherwise they are excluded.\n")
    public List<List<E>> collate(int var1, int var2, boolean var3);

    @Description(value="    Returns the first value in the list that satisfies the given condition.\n")
    public E find(Predicate<E> var1);

    @Description(value="    Returns the first element in the list. Raises an error if the list is empty.\n")
    public E first();

    @Description(value="    Returns the list of integers from 0 to *n - 1*, where *n* is the number of elements in the list.\n")
    public List<Integer> getIndices();

    @Description(value="    Equivalent to `first()`.\n")
    public E head();

    @Description(value="    Returns the index of the first occurrence of the given value in the list, or -1 if the list does not contain the value.\n")
    public int indexOf(E var1);

    @Description(value="    Returns a shallow copy of the list with the last element excluded.\n")
    public List<E> init();

    @Description(value="    Returns the last element in the list. Raises an error if the list is empty.\n")
    public E last();

    @Description(value="    Returns a shallow copy of the list with the elements reversed.\n")
    public List<E> reverse();

    @Description(value="    Returns the portion of the list between the given `fromIndex` (inclusive) and `toIndex` (exclusive).\n")
    public List<E> subList(int var1, int var2);

    @Description(value="    Returns a shallow copy of the list with the first element excluded.\n")
    public List<E> tail();

    @Description(value="    Returns the first *n* elements of the list.\n")
    public List<E> take(int var1);

    @Description(value="    Returns the longest prefix of the list where each element satisfies the given condition.\n")
    public List<E> takeWhile(Predicate<E> var1);

    @Description(value="    Returns a list of 2-tuples corresponding to the value and index of each element in the list.\n")
    public List<Tuple2<E, Integer>> withIndex();
}

