/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types.shim;

import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import nextflow.script.dsl.Description;
import nextflow.script.types.shim.List;
import nextflow.script.types.shim.Map;
import nextflow.script.types.shim.Set;
import nextflow.script.types.shim.String;

@Description(value="    An iterable is a trait shared by collections that support iteration.\n\n    [Read more](https://nextflow.io/docs/latest/reference/stdlib.html#iterable-e)\n")
public interface Iterable<E> {
    @Description(value="    Returns `true` if any element in the iterable satisfies the given condition.\n")
    public boolean any(Predicate<E> var1);

    @Description(value="    Returns a new iterable with each element transformed by the given closure.\n")
    public <R> Iterable<R> collect(Function<E, R> var1);

    @Description(value="    Transforms each element in the iterable into a collection with the given closure and concatenates the resulting collections into a list.\n")
    public <R> Iterable<R> collectMany(Function<E, Iterable<R>> var1);

    @Description(value="    Returns `true` if the iterable contains the given value.\n")
    public boolean contains(E var1);

    @Description(value="    Invoke the given closure for each element in the iterable.\n")
    public void each(Consumer<E> var1);

    @Description(value="    Returns `true` if every element in the iterable satisfies the given condition.\n")
    public boolean every(Predicate<E> var1);

    @Description(value="    Returns the elements in the iterable that satisfy the given condition.\n")
    public Iterable<E> findAll(Predicate<E> var1);

    @Description(value="    Collect the elements of an iterable into groups based on a matching key. The closure should return the key for a given element.\n")
    public <K> Map<K, Iterable<E>> groupBy(Function<E, K> var1);

    @Description(value="    Apply the given accumulator to each element in the iterable and return the final accumulated value. The closure should accept two parameters, corresponding to the current accumulated value and the current iterable element, and return the next accumulated value. The first element from the iterable is used as the initial accumulated value.\n")
    public E inject(BiFunction<E, E, E> var1);

    @Description(value="    Apply the given accumulator to each element in the iterable and return the final accumulated value. The closure should accept two parameters, corresponding to the current accumulated value and the current iterable element, and return the next accumulated value.\n")
    public <R> R inject(R var1, BiFunction<R, E, R> var2);

    @Description(value="    Returns `true` if the iterable is empty.\n")
    public boolean isEmpty();

    @Description(value="    Concatenates the string representation of each element in the iterable.\n")
    public String join();

    @Description(value="    Concatenates the string representation of each element in the iterable, with the given string as the separator between each element.\n")
    public String join(String var1);

    @Description(value="    Returns the maximum element in the iterable.\n")
    public E max();

    @Description(value="    Returns the maximum element in the iterable according to the given closure. The closure should follow the same semantics as the closure parameter of `toSorted()`.\n")
    public <R> E max(Function<E, R> var1);

    @Description(value="    Returns the maximum element in the iterable.\n")
    public E min();

    @Description(value="    Returns the maximum element in the iterable according to the given closure. The closure should follow the same semantics as the closure parameter of `toSorted()`.\n")
    public <R> E min(Function<E, R> var1);

    @Description(value="    Returns the number of elements in the iterable.\n")
    public int size();

    @Description(value="    Returns the sum of the elements in the iterable. The elements should support addition (`+`).\n")
    public E sum();

    @Description(value="    Transforms each element in the iterable with the given closure and returns the sum. The values returned by the closure should support addition (`+`).\n")
    public <R> R sum(Function<E, R> var1);

    @Description(value="    Converts the iterable to a set. Duplicate elements are excluded.\n")
    public Set<E> toSet();

    @Description(value="    Returns a sorted list of the iterable's elements.\n")
    public List<E> toSorted();

    @Description(value="    Returns the iterable as a list sorted according to the given closure. The closure should accept one parameter and transform each element into the value that will be used for comparisons.\n")
    public <R> List<E> toSorted(Function<E, R> var1);

    @Description(value="    Returns a shallow copy of the iterable with duplicate elements excluded.\n")
    public Iterable<E> toUnique();

    @Description(value="    Returns a shallow copy of the iterable with duplicate elements excluded. The closure should follow the same semantics as the closure parameter of `toSorted()`.\n")
    public <R> Iterable<E> toUnique(Function<E, R> var1);
}

