/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types;

import groovy.lang.Closure;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;
import nextflow.script.types.Manifest;

public interface WorkflowMetadata {
    @Constant(value="commandLine")
    @Description(value="    Command line as entered by the user to launch the workflow execution.\n")
    public String getCommandLine();

    @Constant(value="commitId")
    @Description(value="    Git commit ID of the executed workflow repository.\n")
    public String getCommitId();

    @Constant(value="complete")
    @Description(value="    Timestamp of workflow when execution is completed.\n")
    public OffsetDateTime getComplete();

    @Constant(value="configFiles")
    @Description(value="    Configuration files used for the workflow execution.\n")
    public List<Path> getConfigFiles();

    @Constant(value="container")
    @Description(value="    Docker image used to run workflow tasks, or a map of process names to process containers when multiple images are used.\n")
    public Map<String, String> getContainer();

    @Constant(value="containerEngine")
    @Description(value="    Returns the name of the container engine (e.g. docker or singularity) or null if no container engine is enabled.\n")
    public String getContainerEngine();

    @Constant(value="duration")
    @Description(value="    Time elapsed to complete workflow execution.\n")
    public Duration getDuration();

    @Constant(value="errorMessage")
    @Description(value="    Error message of the task that caused the workflow execution to fail.\n")
    public String getErrorMessage();

    @Constant(value="errorReport")
    @Description(value="    Detailed error of the task that caused the workflow execution to fail.\n")
    public String getErrorReport();

    @Constant(value="exitStatus")
    @Description(value="    Exit status of the task that caused the workflow execution to fail.\n")
    public int getExitStatus();

    @Constant(value="failOnIgnore")
    @Description(value="    Whether the `workflow.failOnIgnore` config option was enabled.\n")
    public boolean isFailOnIgnore();

    @Constant(value="fusion")
    @Description(value="    Map of Fusion runtime information.\n")
    public FusionMetadata getFusion();

    @Constant(value="homeDir")
    @Description(value="    User system home directory.\n")
    public Path getHomeDir();

    @Constant(value="launchDir")
    @Description(value="    Directory where the workflow was launched.\n")
    public Path getLaunchDir();

    @Constant(value="manifest")
    @Description(value="    Map of properties corresponding to the {ref}`config-manifest` config scope.\n")
    public Manifest getManifest();

    @Constant(value="outputDir")
    @Description(value="    Workflow output directory.\n")
    public Path getOutputDir();

    @Constant(value="preview")
    @Description(value="    Whether the current workflow run is a preview run.\n")
    public boolean isPreview();

    @Constant(value="profile")
    @Description(value="    Comma-separated list of active configuration profiles.\n")
    public String getProfile();

    @Constant(value="projectDir")
    @Description(value="    Directory where the workflow project is located.\n")
    public Path getProjectDir();

    @Constant(value="repository")
    @Description(value="    Project repository Git remote URL.\n")
    public String getRepository();

    @Constant(value="resume")
    @Description(value="    Whether the current instance is resumed from a previous execution.\n")
    public boolean isResume();

    @Constant(value="revision")
    @Description(value="    Git branch/tag of the executed workflow repository.\n")
    public String getRevision();

    @Constant(value="runName")
    @Description(value="    Mnemonic name assigned to this execution instance.\n")
    public String getRunName();

    @Constant(value="scriptFile")
    @Description(value="    Project main script file path.\n")
    public Path getScriptFile();

    @Constant(value="scriptId")
    @Description(value="    Project main script unique hash ID.\n")
    public String getScriptId();

    @Constant(value="scriptName")
    @Description(value="    Project main script file name.\n")
    public String getScriptName();

    @Constant(value="sessionId")
    @Description(value="    Unique identifier (UUID) associated to current execution.\n")
    public UUID getSessionId();

    @Constant(value="start")
    @Description(value="    Timestamp of workflow at execution start.\n")
    public OffsetDateTime getStart();

    @Constant(value="stubRun")
    @Description(value="    Whether the current instance is a stub-run execution.\n")
    public boolean isStubRun();

    @Constant(value="success")
    @Description(value="    Whether the execution completed successfully.\n")
    public boolean isSuccess();

    @Constant(value="userName")
    @Description(value="    User system account name.\n")
    public String getUserName();

    @Constant(value="wave")
    @Description(value="    Map of Wave runtime information.\n")
    public WaveMetadata getWave();

    @Constant(value="workDir")
    @Description(value="    The directory where task temporary files are stored.\n")
    public Path getWorkDir();

    @Description(value="    Define an action to take when the workflow completes (whether successful or not).\n")
    public void onComplete(Closure var1);

    @Description(value="    Define an action to take if the workflow is terminated due to a runtime error or task failure.\n")
    public void onError(Closure var1);

    public static interface WaveMetadata {
        @Constant(value="enabled")
        @Description(value="    Whether Wave is enabled.\n")
        public boolean isEnabled();
    }

    public static interface FusionMetadata {
        @Constant(value="enabled")
        @Description(value="    Whether Fusion is enabled.\n")
        public boolean isEnabled();

        @Constant(value="version")
        @Description(value="    The Fusion version being used.\n")
        public String getVersion();
    }
}

