/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types;

import groovy.lang.GString;
import groovy.lang.Tuple2;
import java.util.LinkedList;
import java.util.stream.Collectors;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.types.Channel;
import nextflow.script.types.Duration;
import nextflow.script.types.MemoryUnit;
import nextflow.script.types.shim.Bag;
import nextflow.script.types.shim.List;
import nextflow.script.types.shim.Map;
import nextflow.script.types.shim.Path;
import nextflow.script.types.shim.Set;
import nextflow.script.types.shim.ShimType;
import nextflow.script.types.shim.String;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.tools.GenericsUtils;

public class Types {
    public static final java.util.List<ClassNode> DEFAULT_SCRIPT_IMPORTS = java.util.List.of(new ClassNode(Channel.class), new ClassNode(Duration.class), new ClassNode(MemoryUnit.class), new ClassNode(java.nio.file.Path.class));
    public static final java.util.List<ClassNode> DEFAULT_CONFIG_IMPORTS = java.util.List.of(new ClassNode(Duration.class), new ClassNode(MemoryUnit.class));
    private static final java.util.List<Class> STANDARD_TYPES = java.util.List.of(Boolean.class, Duration.class, Integer.class, java.util.List.class, java.util.Map.class, MemoryUnit.class, Number.class, java.nio.file.Path.class, java.util.Set.class, java.lang.String.class, Tuple2.class);
    private static final java.util.Map<Class, Class> PRIMITIVE_TYPES = java.util.Map.ofEntries(java.util.Map.entry(Boolean.TYPE, Boolean.class), java.util.Map.entry(Double.TYPE, Number.class), java.util.Map.entry(Float.TYPE, Number.class), java.util.Map.entry(Integer.TYPE, Integer.class), java.util.Map.entry(Long.TYPE, Integer.class), java.util.Map.entry(GString.class, java.lang.String.class));
    public static final java.util.Map<ClassNode, ClassNode> SHIM_TYPES = Types.shimTypes();

    public static boolean hasReturnType(MethodNode node) {
        ClassNode returnType = node.getReturnType();
        if (returnType.isGenericsPlaceHolder()) {
            return true;
        }
        return !ClassHelper.isObjectType((ClassNode)returnType) && !ClassHelper.isPrimitiveVoid((ClassNode)returnType);
    }

    public static boolean isAssignableFrom(ClassNode target, ClassNode source) {
        if (ClassHelper.isObjectType((ClassNode)target)) {
            return true;
        }
        if (target.equals((Object)source)) {
            return true;
        }
        return Types.isAssignableFrom(target.getTypeClass(), source.getTypeClass());
    }

    public static boolean isAssignableFrom(Class target, Class source) {
        target = Types.normalize(target);
        source = Types.normalize(source);
        if (target == Integer.class && source == Number.class) {
            return false;
        }
        if (target == Number.class && source == Integer.class) {
            return true;
        }
        return target.equals(source);
    }

    public static java.lang.String getName(ClassNode type) {
        if (type == null) {
            return "?";
        }
        if (type.isArray()) {
            return Types.getName(type.getComponentType());
        }
        if (ClassHelper.isFunctionalInterface((ClassNode)type)) {
            return Types.closureName(type);
        }
        if (type.isDerivedFrom(ClassHelper.TUPLE_TYPE)) {
            return Types.tupleName(type);
        }
        return Types.typeName(type);
    }

    private static java.lang.String closureName(ClassNode type) {
        MethodNode mn = ClassHelper.findSAM((ClassNode)type);
        java.util.Map spec = GenericsUtils.extractPlaceholders((ClassNode)type);
        StringBuilder builder = new StringBuilder();
        Parameter[] params = mn.getParameters();
        builder.append('(');
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            ClassNode paramType = Types.specificType(params[i].getType(), spec);
            builder.append(Types.getName(paramType));
        }
        builder.append(')');
        ClassNode returnType = Types.specificType(mn.getReturnType(), spec);
        builder.append(" -> ");
        builder.append(ClassHelper.VOID_TYPE.equals((Object)returnType) ? "()" : Types.getName(returnType));
        return builder.toString();
    }

    private static ClassNode specificType(ClassNode type, java.util.Map<GenericsType.GenericsTypeName, GenericsType> spec) {
        if (!type.isGenericsPlaceHolder()) {
            return type;
        }
        java.lang.String name = type.getUnresolvedName();
        return spec.get(new GenericsType.GenericsTypeName(name)).getType();
    }

    private static java.lang.String tupleName(ClassNode type) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        Types.genericsTypeNames(type.getGenericsTypes(), builder);
        builder.append(')');
        return builder.toString();
    }

    private static java.lang.String typeName(ClassNode type) {
        StringBuilder builder = new StringBuilder();
        boolean placeholder = type.isGenericsPlaceHolder();
        if (placeholder) {
            builder.append(type.getUnresolvedName());
        } else if (type.getNodeMetaData((Object)ASTNodeMarker.FULLY_QUALIFIED) != null) {
            builder.append(type.getName());
        } else if (Types.hasTypeClass(type)) {
            builder.append(Types.getName(type.getTypeClass()));
        } else {
            builder.append(Types.getName(type.getNameWithoutPackage()));
        }
        if (!placeholder && type.isUsingGenerics()) {
            builder.append('<');
            Types.genericsTypeNames(type.getGenericsTypes(), builder);
            builder.append('>');
        }
        return builder.toString();
    }

    private static void genericsTypeNames(GenericsType[] genericsTypes, StringBuilder builder) {
        for (int i = 0; i < genericsTypes.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(Types.getName(genericsTypes[i].getType()));
        }
    }

    private static boolean hasTypeClass(ClassNode type) {
        try {
            type.getTypeClass();
            return true;
        }
        catch (GroovyBugError e) {
            return false;
        }
    }

    public static java.lang.String getName(Class type) {
        return Types.getName(Types.normalize(type).getSimpleName());
    }

    public static java.lang.String getName(java.lang.String name) {
        if ("Object".equals(name)) {
            return "?";
        }
        return name;
    }

    private static Class normalize(Class type) {
        if (type.isPrimitive() && PRIMITIVE_TYPES.containsKey(type)) {
            return PRIMITIVE_TYPES.get(type);
        }
        LinkedList queue = new LinkedList();
        queue.add(type);
        while (!queue.isEmpty()) {
            Class c = (Class)queue.remove();
            if (c == null) continue;
            if (STANDARD_TYPES.contains(c)) {
                return c;
            }
            queue.add(c.getSuperclass());
            for (Class<?> ic : c.getInterfaces()) {
                queue.add(ic);
            }
        }
        return type;
    }

    private static java.util.Map<ClassNode, ClassNode> shimTypes() {
        java.util.List<Class<String>> types = java.util.List.of(Bag.class, List.class, Map.class, Path.class, Set.class, String.class);
        return types.stream().collect(Collectors.toMap(clazz -> {
            Class shim = clazz.getAnnotation(ShimType.class).value();
            return ClassHelper.makeCached((Class)shim);
        }, clazz -> ClassHelper.makeCached((Class)clazz)));
    }
}

