/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.ast.ASTUtils;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.types.Types;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;

public class TypeChecker {
    public static ClassNode getType(ASTNode node) {
        Object object = node.getNodeMetaData((Object)ASTNodeMarker.INFERRED_TYPE);
        if (object instanceof ClassNode) {
            ClassNode cn = (ClassNode)object;
            return cn;
        }
        ClassNode inferredType = TypeChecker.inferredType(node);
        ClassNode result = Types.SHIM_TYPES.containsKey(inferredType) ? Types.SHIM_TYPES.get(inferredType) : inferredType;
        node.putNodeMetaData((Object)ASTNodeMarker.INFERRED_TYPE, (Object)result);
        return result;
    }

    private static ClassNode inferredType(ASTNode node) {
        ClassNode classNode;
        Variable variable;
        VariableExpression ve;
        MethodNode mn;
        if (node instanceof ClassExpression) {
            ClassExpression ce = (ClassExpression)node;
            return ce.getType();
        }
        if (node instanceof ConstructorCallExpression) {
            ConstructorCallExpression cce = (ConstructorCallExpression)node;
            return cce.getType();
        }
        if (node instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)node;
            MethodNode mn2 = TypeChecker.inferMethodTarget((MethodCall)mce);
            return mn2 != null ? mn2.getReturnType() : null;
        }
        if (node instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)node;
            MethodNode mn3 = ASTUtils.asMethodOutput(pe);
            if (mn3 instanceof ProcessNode) {
                ProcessNode pn = (ProcessNode)mn3;
                return pn.getReturnType();
            }
            if (mn3 instanceof WorkflowNode) {
                WorkflowNode wn = (WorkflowNode)mn3;
                return wn.getReturnType();
            }
            FieldNode fn = TypeChecker.inferPropertyTarget(pe);
            return fn != null ? TypeChecker.getType((ASTNode)fn) : null;
        }
        if (node instanceof VariableExpression && ((mn = ASTUtils.asMethodVariable((ve = (VariableExpression)node).getAccessedVariable())) instanceof ProcessNode || mn instanceof WorkflowNode)) {
            return null;
        }
        if (node instanceof Variable && (variable = (Variable)node).getOriginType() != null) {
            return variable.getOriginType();
        }
        if (node instanceof Expression) {
            Expression exp = (Expression)node;
            classNode = exp.getType();
        } else {
            classNode = null;
        }
        return classNode;
    }

    public static FieldNode inferPropertyTarget(PropertyExpression node) {
        ClassNode receiverType = TypeChecker.getType((ASTNode)node.getObjectExpression());
        if (receiverType == null) {
            return null;
        }
        String name = node.getPropertyAsString();
        FieldNode result = receiverType.getField(name);
        if (result != null) {
            return result;
        }
        return receiverType.getMethods().stream().filter(mn -> {
            if (!mn.isPublic()) {
                return false;
            }
            Optional<AnnotationNode> an = ASTUtils.findAnnotation((AnnotatedNode)mn, Constant.class);
            if (!an.isPresent()) {
                return false;
            }
            return name.equals(an.get().getMember("value").getText());
        }).map(mn -> {
            FieldNode fn = new FieldNode(name, 15, mn.getReturnType(), mn.getDeclaringClass(), null);
            ASTUtils.findAnnotation((AnnotatedNode)mn, Description.class).ifPresent(an -> fn.addAnnotation(an));
            return fn;
        }).findFirst().orElse(null);
    }

    public static MethodNode inferMethodTarget(MethodCall node) {
        List<MethodNode> methods = TypeChecker.methodOverloads(node);
        List<Expression> arguments = ASTUtils.asMethodCallArguments(node);
        return methods.stream().filter(mn -> {
            Parameter[] parameters = mn.getParameters();
            if (arguments.size() != parameters.length) {
                return false;
            }
            for (int i = 0; i < parameters.length; ++i) {
                ClassNode argType;
                ClassNode paramType = parameters[i].getType();
                if (Types.isAssignableFrom(paramType, argType = ((Expression)arguments.get(i)).getType())) continue;
                return false;
            }
            return true;
        }).findFirst().orElse(null);
    }

    private static List<MethodNode> methodOverloads(MethodCall node) {
        ConstructorCallExpression cce;
        ClassNode constructorType;
        if (node instanceof MethodCallExpression) {
            ClassNode receiverType;
            MethodCallExpression mce = (MethodCallExpression)node;
            Object object = mce.getNodeMetaData((Object)ASTNodeMarker.METHOD_TARGET);
            if (object instanceof MethodNode) {
                MethodNode mn = (MethodNode)object;
                return List.of(mn);
            }
            if (!mce.isImplicitThis() && (receiverType = TypeChecker.getType((ASTNode)mce.getObjectExpression())) != null) {
                return TypeChecker.methodsForType(receiverType, mce.getMethodAsString());
            }
        }
        if (node instanceof ConstructorCallExpression && (constructorType = (cce = (ConstructorCallExpression)node).getType()) != null) {
            return constructorType.getDeclaredConstructors().stream().map(ctor -> ctor).toList();
        }
        return Collections.emptyList();
    }

    private static List<MethodNode> methodsForType(ClassNode cn, String name) {
        try {
            return cn.getAllDeclaredMethods().stream().filter(mn -> mn.getName().equals(name)).filter(mn -> !ClassHelper.isObjectType((ClassNode)mn.getDeclaringClass())).toList();
        }
        catch (NullPointerException e) {
            return Collections.emptyList();
        }
    }
}

