/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;
import nextflow.script.types.MemoryUnit;

public interface TaskConfig {
    @Constant(value="attempt")
    @Description(value="    The current task attempt.\n")
    public int getAttempt();

    @Constant(value="exitStatus")
    @Description(value="    The exit code of the task script. Only available after the task has been executed.\n")
    public int getExitStatus();

    @Constant(value="hash")
    @Description(value="    The unique task hash.\n")
    public String getHash();

    @Constant(value="id")
    @Description(value="    The pipeline-level task index.\n")
    public int getId();

    @Constant(value="index")
    @Description(value="    The process-level task index.\n")
    public int getIndex();

    @Constant(value="name")
    @Description(value="    The current task name.\n")
    public String getName();

    @Constant(value="previousException")
    @Description(value="    The exception reported by the previous task attempt.\n")
    public Exception getPreviousException();

    @Constant(value="previousTrace")
    @Description(value="    The trace record associated with the previous task attempt.\n")
    public Map<String, ?> getPreviousTrace();

    @Constant(value="process")
    @Description(value="    The current process name.\n")
    public String getProcess();

    @Constant(value="workDir")
    @Description(value="    The task unique directory.\n")
    public Path getWorkDir();

    @Constant(value="accelerator")
    @Description(value="    The `accelerator` directive allows you to request hardware accelerators (e.g. GPUs) for the task execution.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#accelerator)\n")
    public Map<String, ?> getAccelerator();

    @Constant(value="afterScript")
    @Description(value="    The `afterScript` directive allows you to execute a custom (Bash) snippet *after* the task script.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#afterscript)\n")
    public String getAfterScript();

    @Constant(value="arch")
    @Description(value="    The `arch` directive allows you to define the CPU architecture to build the software used by the task.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#arch)\n")
    public String getArch();

    @Constant(value="array")
    @Description(value="    The `array` directive allows you to submit tasks as *job arrays* for executors that support it.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#array)\n")
    public Integer getArray();

    @Constant(value="beforeScript")
    @Description(value="    The `beforeScript` directive allows you to execute a custom (Bash) snippet *before* the task script.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#beforescript)\n")
    public String getBeforeScript();

    @Constant(value="cache")
    @Description(value="    The `cache` directive allows you to store the process results to a local cache. When the cache is enabled *and* the pipeline is launched with the `-resume` option, any task executions that are already cached will be re-used.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#cache)\n")
    public String getCache();

    @Constant(value="clusterOptions")
    @Description(value="    The `clusterOptions` directive allows the usage of any native configuration option accepted by your cluster submit command. You can use it to request non-standard resources or use settings that are specific to your cluster and not supported out of the box by Nextflow.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#clusteroptions)\n")
    public String getClusterOptions();

    @Constant(value="conda")
    @Description(value="    The `conda` directive allows for the definition of the process dependencies using the [Conda](https://conda.io) package manager.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#conda)\n")
    public String getConda();

    @Constant(value="container")
    @Description(value="    The `container` directive allows you to execute the process script in a container.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#container)\n")
    public String getContainer();

    @Constant(value="containerOptions")
    @Description(value="    The `containerOptions` directive allows you to specify any container execution option supported by the underlying container engine (ie. Docker, Singularity, etc). This can be useful to provide container settings only for a specific process.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#containeroptions)\n")
    public String getContainerOptions();

    @Constant(value="cpus")
    @Description(value="    The `cpus` directive allows you to define the number of (logical) CPUs required by each task.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#cpus)\n")
    public int getCpus();

    @Constant(value="debug")
    @Description(value="    The `debug` directive allows you to print the process standard output to Nextflow's standard output, i.e. the console. By default this directive is disabled.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#debug)\n")
    public boolean getDebug();

    @Constant(value="disk")
    @Description(value="    The `disk` directive allows you to define how much local disk storage the process is allowed to use.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#disk)\n")
    public MemoryUnit getDisk();

    @Constant(value="errorStrategy")
    @Description(value="    The `errorStrategy` directive allows you to define what to do when a task fails.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#errorstrategy)\n")
    public String getErrorStrategy();

    @Constant(value="executor")
    @Description(value="    The `executor` defines the underlying system where tasks are executed.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#executor)\n")
    public String getExecutor();

    @Constant(value="ext")
    @Description(value="    The `ext` is a special directive used for custom settings by some executors.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#ext)\n")
    public Map<String, ?> getExt();

    @Constant(value="fair")
    @Description(value="    The `fair` directive, when enabled, guarantees that process outputs will be emitted in the order in which they were received.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#fair)\n")
    public boolean getFair();

    @Constant(value="label")
    @Description(value="    The `label` directive allows you to annotate a process with a mnemonic identifier of your choice.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#label)\n")
    public String getLabel();

    @Constant(value="machineType")
    @Description(value="    The `machineType` directive can be used to specify a predefined Google Compute Platform [machine type](https://cloud.google.com/compute/docs/machine-types) when using the [Google Batch](https://nextflow.io/docs/latest/google.html#cloud-batch) executor.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#machinetype)\n")
    public String getMachineType();

    @Constant(value="maxErrors")
    @Description(value="    The `maxErrors` directive allows you to specify the maximum number of times a process can fail when using the `retry` or `ignore` error strategy. By default this directive is disabled.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxerrors)\n")
    public int getMaxErrors();

    @Constant(value="maxForks")
    @Description(value="    The `maxForks` directive allows you to define the maximum number of tasks (per process) that can be executed in parallel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxforks)\n")
    public Integer getMaxForks();

    @Constant(value="maxRetries")
    @Description(value="    The `maxRetries` directive allows you to define the maximum number of times a task can be retried when using the `retry` error strategy. By default only one retry is allowed.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxretries)\n")
    public int getMaxRetries();

    @Constant(value="maxSubmitAwait")
    @Description(value="    The `maxSubmitAwait` directives allows you to specify how long a task can remain in the submission queue. If a task remains in the queue beyond this time limit, it will fail.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxsubmitawait)\n")
    public Duration getMaxSubmitAwait();

    @Constant(value="memory")
    @Description(value="    The `memory` directive allows you to define how much memory is required by each task. Can be a string (e.g. `'8 GB'`) or a memory unit (e.g. `8.GB`).\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#memory)\n")
    public MemoryUnit getMemory();

    @Constant(value="module")
    @Description(value="    The `module` directive allows you to provide software dependencies to a process using [Environment Modules](http://modules.sourceforge.net/).\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#module)\n")
    public List<String> getModule();

    @Constant(value="penv")
    @Description(value="    The `penv` directive allows you to define the parallel environment to be used when submitting a parallel task to the [SGE](https://nextflow.io/docs/latest/executor.html#sge) resource manager.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#penv)\n")
    public String getPenv();

    @Constant(value="pod")
    @Description(value="    The `pod` directive allows you to define pod specific settings, such as environment variables, secrets, and config maps, when using the [Kubernetes](https://nextflow.io/docs/latest/kubernetes.html) executor.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#pod)\n")
    public List<?> getPod();

    @Constant(value="publishDir")
    @Description(value="    The `publishDir` directive allows you to publish the process output files to a directory.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#publishdir)\n")
    public List<?> getPublishDir();

    @Constant(value="queue")
    @Description(value="    The `queue` directive allows you to specify the queue to which jobs are submitted when using a grid executor.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#queue)\n")
    public String getQueue();

    @Constant(value="resourceLabels")
    @Description(value="    The `resourceLabels` directive allows you to specify custom name-value pairs which are applied to the compute resources used for the process execution.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#resourcelabels)\n")
    public Map<String, String> getResourceLabels();

    @Constant(value="resourceLimits")
    @Description(value="    The `resourceLimits` directive allows you to specify environment-specific limits for task resource requests.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#resourcelimits)\n")
    public Map<String, ?> getResourceLimits();

    @Constant(value="scratch")
    @Description(value="    The `scratch` directive allows you to execute each task in a temporary directory that is local to the compute node.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#scratch)\n")
    public String getScratch();

    @Constant(value="secret")
    @Description(value="    The `secret` directive allows you to securely provide secrets to a process.\n\n    [Read more](https://nextflow.io/docs/latest/secrets.html#process-directive)\n")
    public List<String> getSecret();

    @Constant(value="shell")
    @Description(value="    The `shell` directive allows you to define a custom shell command for process scripts. By default, script blocks are executed with `/bin/bash -ue`.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#shell)\n")
    public List<String> getShell();

    @Constant(value="spack")
    @Description(value="    The `spack` directive allows you to provide software dependencies using the [Spack](https://spack.io) package manager.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#spack)\n")
    public String getSpack();

    @Constant(value="stageInMode")
    @Description(value="    The `stageInMode` directive defines how input files are staged into the task work directory.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#stageinmode)\n")
    public String getStageInMode();

    @Constant(value="stageOutMode")
    @Description(value="    The `stageOutMode` directive defines how output files are staged out from the scratch directory to the task work directory when using the `scratch` directive.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#stageoutmode)\n")
    public String getStageOutMode();

    @Constant(value="storeDir")
    @Description(value="    The `storeDir` directive allows you to use an external directory as a *permanent* cache for process outputs.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#storedir)\n")
    public Path getStoreDir();

    @Constant(value="tag")
    @Description(value="    The `tag` directive allows you to associate each process execution with a custom label, so that it will be easier to identify in the log file or in a report.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#tag)\n")
    public String getTag();

    @Constant(value="time")
    @Description(value="    The `time` directive allows you to define how long a task is allowed to run.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#time)\n")
    public Duration getTime();
}

