/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types;

import java.util.List;
import java.util.Map;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;

public interface Manifest {
    @Constant(value="author")
    @Description(value="    Project author name (use a comma to separate multiple names).\n")
    public String getAuthor();

    @Constant(value="contributors")
    @Description(value="    List of project contributors. Should be a list of maps.\n")
    public List<Map> getContributors();

    @Constant(value="defaultBranch")
    @Description(value="    Git repository default branch (default: `master`).\n")
    public String getDefaultBranch();

    @Constant(value="description")
    @Description(value="    Free text describing the workflow project.\n")
    public String getDescription();

    @Constant(value="docsUrl")
    @Description(value="    Project documentation URL.\n")
    public String getDocsUrl();

    @Constant(value="doi")
    @Description(value="    Project related publication DOI identifier.\n")
    public String getDoi();

    @Constant(value="homePage")
    @Description(value="    Project home page URL.\n")
    public String getHomePage();

    @Constant(value="icon")
    @Description(value="    Project related icon location (Relative path or URL).\n")
    public String getIcon();

    @Constant(value="license")
    @Description(value="    Project license.\n")
    public String getLicense();

    @Constant(value="mainScript")
    @Description(value="    Project main script (default: `main.nf`).\n")
    public String getMainScript();

    @Constant(value="name")
    @Description(value="    Project short name.\n")
    public String getName();

    @Constant(value="nextflowVersion")
    @Description(value="    Minimum required Nextflow version.\n")
    public String getNextflowVersion();

    @Constant(value="organization")
    @Description(value="    Project organization.\n")
    public String getOrganization();

    @Constant(value="recurseSubmodules")
    @Description(value="    Pull submodules recursively from the Git repository.\n")
    public boolean getRecurseSubmodules();

    @Constant(value="version")
    @Description(value="    Project version number.\n")
    public String getVersion();
}

