/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.types;

import groovy.lang.Closure;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import nextflow.script.dsl.Description;
import nextflow.script.dsl.Operator;
import nextflow.script.types.ChannelFactory;

@Description(value="    A `Channel` is an asynchronous collection that is produced by a process, operator, or channel factory.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html)\n")
public abstract class Channel<E> {
    protected static ChannelFactory instance;

    @Description(value="    Create a channel that emits nothing.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#empty)\n")
    public static Channel empty() {
        return instance.empty();
    }

    @Deprecated
    @Description(value="    Create a channel that emits each argument.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#from)\n")
    public static <E> Channel<E> from(E ... values) {
        return instance.from(values);
    }

    @Deprecated
    @Description(value="    Create a channel that emits each element in a collection.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#from)\n")
    public static <E> Channel<E> from(Collection<E> values) {
        return instance.from(values);
    }

    @Description(value="    Create a channel that emits all file pairs matching a glob pattern.\n\n    An optional closure can be used to customize the grouping strategy.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#fromfilepairs)\n")
    public static Channel fromFilePairs(Map<String, ?> opts, String pattern, Closure grouping) {
        return instance.fromFilePairs(opts, pattern, grouping);
    }

    @Description(value="    Create a channel that emits each element in a collection.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#fromlist)\n")
    public static <E> Channel<E> fromList(Collection<E> values) {
        return instance.fromList(values);
    }

    @Description(value="    Create a channel that emits all paths matching a name or glob pattern.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#frompath)\n")
    public static Channel<Path> fromPath(Map<String, ?> opts, String pattern) {
        return instance.fromPath(opts, pattern);
    }

    @Description(value="    Create a channel that queries the [NCBI SRA](https://www.ncbi.nlm.nih.gov/sra) database and emits all FASTQ files matching the given project or accession ids.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#fromsra)\n")
    public static Channel fromSRA(Map<String, ?> opts, String query) {
        return instance.fromSRA(opts, query);
    }

    @Description(value="    Create a channel that emits each argument.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#of)\n")
    public static <E> Channel<E> of(E ... values) {
        return instance.of(values);
    }

    @Description(value="    Create a channel that emits all values in the given topic.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#topic)\n")
    public static Channel topic(String name) {
        return instance.topic(name);
    }

    @Description(value="    Create a value channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#value)\n")
    public static <E> Channel<E> value(E value) {
        return instance.value(value);
    }

    @Description(value="    Create a channel that watches for filesystem events for all files matching the given pattern.\n\n    [Read more](https://nextflow.io/docs/latest/reference/channel.html#watchpath)\n")
    public static Channel<Path> watchPath(String filePattern, String events) {
        return instance.watchPath(filePattern, events);
    }

    @Operator
    @Description(value="    The `branch` operator forwards each value from a source channel to one of multiple output channels, based on a selection criteria.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#branch)\n")
    public abstract Object branch(Closure var1);

    @Operator
    @Description(value="    The `buffer` operator collects values from a source channel into subsets and emits each subset separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#buffer)\n")
    public abstract Channel buffer(Closure var1, Closure var2);

    @Operator
    @Description(value="    The `collate` operator collects values from a source channel into groups of *N* values.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#collate)\n")
    public abstract Channel collate(int var1, int var2, boolean var3);

    @Operator
    @Description(value="    The `collect` operator collects all values from a source channel into a list and emits it as a single value.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#collect)\n")
    public abstract Channel collect(Closure var1);

    @Operator
    @Description(value="    The `collectFile` operator collects the values from a source channel and saves them to one or more files, emitting the collected file(s).\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#collectfile)\n")
    public abstract Channel collectFile(Map<String, ?> var1, Closure var2);

    @Operator
    @Description(value="    The `combine` operator produces the combinations (i.e. cross product, \u201cCartesian\u201d product) of two source channels, or a channel and a list (as the right operand), emitting each combination separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#combine)\n")
    public abstract Channel combine(Map<String, ?> var1, Object var2);

    @Operator
    @Description(value="    The `concat` operator emits the values from two or more source channels into a single output channel. Each source channel is emitted in the order in which it was specified.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#concat)\n")
    public abstract Channel concat(Channel ... var1);

    @Operator
    @Description(value="    The `count` operator computes the total number of values from a source channel and emits it.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#count)\n")
    public abstract Channel count();

    @Operator
    @Description(value="    The `cross` operator emits every pairwise combination of two channels for which the pair has a matching key.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#cross)\n")
    public abstract Channel cross(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `distinct` operator forwards a source channel with consecutively repeated values removed, such that each emitted value is different from the preceding one.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#distinct)\n")
    public abstract Channel distinct();

    @Operator
    @Description(value="    When the pipeline is executed with the `-dump-channels` command-line option, the `dump` operator prints each value in a source channel, otherwise it does nothing.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#dump)\n")
    public abstract Channel dump(Map<String, ?> var1);

    @Operator
    @Description(value="    The `filter` operator emits the values from a source channel that satisfy a condition, discarding all other values. The filter condition can be a literal value, a regular expression, a type qualifier, or a boolean predicate.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#filter)\n")
    public abstract Channel filter(Closure<Boolean> var1);

    @Operator
    @Description(value="    The `first` operator emits the first value from a source channel, or the first value that satisfies a condition. The condition can be a regular expression, a type qualifier (i.e. Java class), or a boolean predicate.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#first)\n")
    public abstract Channel first(Object var1);

    @Operator
    @Description(value="    The `flatMap` operator applies a mapping function to each value from a source channel.\n\n    When the mapping function returns a list, each element in the list is emitted separately. When the mapping function returns a map, each key-value pair in the map is emitted separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#flatmap)\n")
    public abstract Channel flatMap(Closure var1);

    @Operator
    @Description(value="    The `flatten` operator flattens each value from a source channel that is a list or other collection, such that each element in each collection is emitted separately. Deeply nested collections are also flattened.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#flatten)\n")
    public abstract Channel flatten();

    @Operator
    @Description(value="    The `groupTuple` operator collects tuples from a source channel into groups based on a grouping key. A new tuple is emitted for each distinct key.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#grouptuple)\n")
    public abstract Channel groupTuple(Map<String, ?> var1);

    @Operator
    @Description(value="    The `ifEmpty` operator emits a source channel, or a default value if the source channel is empty.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#ifempty)\n")
    public abstract Channel ifEmpty(Object var1);

    @Operator
    @Description(value="    The `join` operator emits the inner product of two source channels using a matching key.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#join)\n")
    public abstract Channel join(Channel var1);

    @Operator
    @Description(value="    The `last` operator emits the last value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#last)\n")
    public abstract Channel last();

    @Operator
    @Description(value="    The `map` operator applies a mapping function to each value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#map)\n")
    public abstract Channel map(Closure var1);

    @Operator
    @Description(value="    The `max` operator emits the item with the greatest value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#max)\n")
    public abstract Channel max(Closure var1);

    @Operator
    @Description(value="    The `merge` operator joins the values from two or more channels into a new channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#merge)\n")
    public abstract Channel merge(Channel ... var1);

    @Operator
    @Description(value="    The `min` operator emits the item with the lowest value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#min)\n")
    public abstract Channel min(Closure var1);

    @Operator
    @Description(value="    The `mix` operator emits the values from two or more source channels into a single output channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#mix)\n")
    public abstract Channel mix(Channel ... var1);

    @Operator
    @Description(value="    The `multiMap` operator applies a set of mapping functions to a source channel, producing a separate output channel for each mapping function.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#multimap)\n")
    public abstract Object multiMap(Closure var1);

    @Operator
    @Description(value="    The `randomSample` operator emits a randomly-selected subset of values from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#randomsample)\n")
    public abstract Channel randomSample(int var1, Long var2);

    @Operator
    @Description(value="    The `reduce` operator applies an accumulator function sequentially to each value from a source channel, and emits the accumulated value. The accumulator function takes two parameters -- the accumulated value and the *i*-th emitted value -- and it should return the accumulated result, which is passed to the next invocation with the *i+1*-th value. This process is repeated for each value in the source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#reduce)\n")
    public abstract Channel reduce(Object var1, Closure var2);

    @Operator
    @Description(value="    The `set` operator assigns a source channel to a variable, whose name is specified in a closure.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#set)\n")
    public abstract void set(Closure var1);

    @Operator
    @Description(value="    The `splitCsv` operator parses and splits [CSV-formatted](http://en.wikipedia.org/wiki/Comma-separated_values) text from a source channel into records, or groups of records with a given size.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splitcsv)\n")
    public abstract Channel splitCsv(Map<String, ?> var1);

    @Operator
    @Description(value="    The `splitFasta` operator splits [FASTA formatted](http://en.wikipedia.org/wiki/FASTA_format) text from a source channel into individual sequences.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splitfasta)\n")
    public abstract Channel splitFasta(Map<String, ?> var1);

    @Operator
    @Description(value="    The `splitFastq` operator splits [FASTQ formatted](http://en.wikipedia.org/wiki/FASTQ_format) text from a source channel into individual sequences.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splitfastq)\n")
    public abstract Channel splitFastq(Map<String, ?> var1);

    @Operator
    @Description(value="    The `splitText` operator splits multi-line text content from a source channel into chunks of *N* lines.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splittext)\n")
    public abstract Channel splitText(Map<String, ?> var1, Closure var2);

    @Operator
    @Description(value="    The `subscribe` operator invokes a custom function for each value in a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#subscribe)\n")
    public abstract void subscribe(Closure var1);

    @Operator
    @Description(value="    The `sum` operator emits the sum of all values in a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#sum)\n")
    public abstract Channel sum(Closure var1);

    @Operator
    @Description(value="    The `take` operator takes the first *N* values from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#take)\n")
    public abstract Channel take(int var1);

    @Operator
    @Description(value="    The `tap` operator assigns a source channel to a variable, whose name is specified in a closure.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#tap)\n")
    public abstract Channel tap(Closure var1);

    @Operator
    @Description(value="     The `toList` operator collects all the values from a source channel into a list and emits the list as a single value.\n\npublic abstract      [Read more](https://nextflow.io/docs/latest/reference/operator.html#to;ist)\n")
    public abstract Channel toList();

    @Operator
    @Description(value="    The `toSortedList` operator collects all the values from a source channel into a sorted list and emits the list as a single value.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#tosortedlist)\n")
    public abstract Channel toSortedList();

    @Operator
    @Description(value="    The `transpose` operator transposes each tuple from a source channel by flattening any nested list in each tuple, emitting each nested value separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#transpose)\n")
    public abstract Channel transpose(Map<String, ?> var1);

    @Operator
    @Description(value="    The `unique` operator emits the unique values from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#unique)\n")
    public abstract Channel unique(Closure var1);

    @Operator
    @Description(value="    The `until` operator emits each value from a source channel until a stopping condition is satisfied.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#until)\n")
    public abstract Channel until(Closure<Boolean> var1);

    @Operator
    @Description(value="    The `view` operator prints each value from a source channel to standard output.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#view)\n")
    public abstract Channel view(Closure var1);
}

