/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.parser;

import java.util.regex.Pattern;
import nextflow.config.parser.ConfigParser;
import nextflow.script.parser.ScriptParser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.codehaus.groovy.GroovyBugError;

public class SemanticPredicates {
    private static final Pattern NONSPACES_PATTERN = Pattern.compile("\\S+?");
    private static final Pattern LETTER_AND_LEFTCURLY_PATTERN = Pattern.compile("[a-zA-Z_{]");
    private static final Pattern NONSURROGATE_PATTERN = Pattern.compile("[^\u0000-\u007f\ud800-\udbff]");
    private static final Pattern SURROGATE_PAIR1_PATTERN = Pattern.compile("[\ud800-\udbff]");
    private static final Pattern SURROGATE_PAIR2_PATTERN = Pattern.compile("[\udc00-\udfff]");

    public static boolean isFollowedByWhiteSpaces(CharStream cs) {
        int index = 1;
        int c = cs.LA(index);
        while (13 != c && 10 != c && -1 != c) {
            if (StringUtils.matches((String)String.valueOf((char)c), (Pattern)NONSPACES_PATTERN)) {
                return false;
            }
            c = cs.LA(++index);
        }
        return true;
    }

    public static boolean isFollowedBy(CharStream cs, char ... chars) {
        int c1 = cs.LA(1);
        for (char c : chars) {
            if (c1 != c) continue;
            return true;
        }
        return false;
    }

    public static boolean isFollowedByJavaLetterInGString(CharStream cs) {
        int c1 = cs.LA(1);
        if (36 == c1) {
            return false;
        }
        String str1 = String.valueOf((char)c1);
        if (StringUtils.matches((String)str1, (Pattern)LETTER_AND_LEFTCURLY_PATTERN)) {
            return true;
        }
        if (StringUtils.matches((String)str1, (Pattern)NONSURROGATE_PATTERN) && Character.isJavaIdentifierPart(c1)) {
            return true;
        }
        int c2 = cs.LA(2);
        String str2 = String.valueOf((char)c2);
        return StringUtils.matches((String)str1, (Pattern)SURROGATE_PAIR1_PATTERN) && StringUtils.matches((String)str2, (Pattern)SURROGATE_PAIR2_PATTERN) && Character.isJavaIdentifierPart(Character.toCodePoint((char)c1, (char)c2));
    }

    public static boolean isValidDirective(ConfigParser.ExpressionContext context) {
        if (!(context instanceof ConfigParser.PathExprAltContext)) {
            return false;
        }
        try {
            ConfigParser.PathExprAltContext peac = (ConfigParser.PathExprAltContext)context;
            ParseTree last = peac.getChild(peac.getChildCount() - 1);
            return last instanceof ConfigParser.IdentifierPrmrAltContext || last instanceof ConfigParser.PropertyPathExprAltContext;
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            throw new GroovyBugError("Unexpected structure of expression context: " + String.valueOf((Object)context), (Exception)e);
        }
    }

    public static boolean isValidDirective(ScriptParser.ExpressionContext context) {
        if (!(context instanceof ScriptParser.PathExprAltContext)) {
            return false;
        }
        try {
            ScriptParser.PathExprAltContext peac = (ScriptParser.PathExprAltContext)context;
            ParseTree last = peac.getChild(peac.getChildCount() - 1);
            return last instanceof ScriptParser.IdentifierPrmrAltContext || last instanceof ScriptParser.PropertyPathExprAltContext;
        }
        catch (ClassCastException | IndexOutOfBoundsException e) {
            throw new GroovyBugError("Unexpected structure of expression context: " + String.valueOf((Object)context), (Exception)e);
        }
    }
}

