/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.parser;

import groovy.lang.Tuple2;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.ast.AssignmentExpression;
import nextflow.script.ast.FeatureFlagNode;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.IncludeModuleNode;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.IncompleteNode;
import nextflow.script.ast.InvalidDeclaration;
import nextflow.script.ast.OutputBlockNode;
import nextflow.script.ast.OutputNode;
import nextflow.script.ast.ParamNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.parser.DescriptiveErrorStrategy;
import nextflow.script.parser.GroovydocManager;
import nextflow.script.parser.PositionConfigureUtils;
import nextflow.script.parser.ScriptLexer;
import nextflow.script.parser.ScriptParser;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRErrorStrategy;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.misc.ParseCancellationException;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.groovy.parser.antlr4.GroovySyntaxError;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.codehaus.groovy.antlr.EnumHelper;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.NodeMetaDataHandler;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.ProcessingUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.Numbers;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.Types;

public class ScriptAstBuilder {
    private SourceUnit sourceUnit;
    private ScriptNode moduleNode;
    private ScriptLexer lexer;
    private ScriptParser parser;
    private final GroovydocManager groovydocManager;
    private Tuple2<ParserRuleContext, Exception> numberFormatError;
    private static final List<String> SCRIPT_DEF_NAMES = List.of("process", "workflow", "output");
    private static final String KEYWORD_FOR = Types.getText((int)572);
    private static final String KEYWORD_SWITCH = Types.getText((int)576);
    private static final String KEYWORD_WHILE = Types.getText((int)571);
    private static final String CALL_STR = "call";
    private static final String SLASH_STR = "/";
    private static final String TDQ_STR = "\"\"\"";
    private static final String TSQ_STR = "'''";
    private static final String SQ_STR = "'";
    private static final String DQ_STR = "\"";
    private static final List<String> GROOVY_KEYWORDS = List.of(Types.getText((int)510), Types.getText((int)585), Types.getText((int)574), Types.getText((int)577), Types.getText((int)531), Types.getText((int)700), Types.getText((int)575), Types.getText((int)578), Types.getText((int)570), Types.getText((int)541), Types.getText((int)511), Types.getText((int)582), Types.getText((int)572), Types.getText((int)701), Types.getText((int)540), Types.getText((int)532), Types.getText((int)512), Types.getText((int)550), Types.getText((int)500), Types.getText((int)501), Types.getText((int)502), Types.getText((int)521), Types.getText((int)543), Types.getText((int)576), Types.getText((int)520), Types.getText((int)542), Types.getText((int)584), Types.getText((int)513), Types.getText((int)600), Types.getText((int)514), Types.getText((int)571));

    public ScriptAstBuilder(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
        this.moduleNode = new ScriptNode(sourceUnit);
        CharStream charStream = this.createCharStream(sourceUnit);
        this.lexer = new ScriptLexer(charStream);
        this.parser = new ScriptParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
        this.parser.setErrorHandler((ANTLRErrorStrategy)new DescriptiveErrorStrategy(charStream));
        boolean groovydocEnabled = sourceUnit.getConfiguration().isGroovydocEnabled();
        this.groovydocManager = new GroovydocManager(groovydocEnabled);
    }

    private CharStream createCharStream(SourceUnit sourceUnit) {
        try {
            return CharStreams.fromReader((Reader)new BufferedReader(sourceUnit.getSource().getReader()), (String)sourceUnit.getName());
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred when reading source code.", e);
        }
    }

    private ScriptParser.CompilationUnitContext buildCST() {
        try {
            TokenStream tokenStream = this.parser.getInputStream();
            try {
                return this.buildCST(PredictionMode.SLL);
            }
            catch (Throwable t) {
                GroovySyntaxError gse;
                if (t instanceof GroovySyntaxError && (gse = (GroovySyntaxError)t).getSource() == 0) {
                    throw t;
                }
                tokenStream.seek(0);
                return this.buildCST(PredictionMode.LL);
            }
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
    }

    private ScriptParser.CompilationUnitContext buildCST(PredictionMode predictionMode) {
        ((ParserATNSimulator)this.parser.getInterpreter()).setPredictionMode(predictionMode);
        this.removeErrorListeners();
        if (predictionMode == PredictionMode.LL) {
            this.addErrorListeners();
        }
        return this.parser.compilationUnit();
    }

    private CompilationFailedException convertException(Throwable t) {
        if (t instanceof CompilationFailedException) {
            CompilationFailedException cfe = (CompilationFailedException)t;
            return cfe;
        }
        if (t instanceof ParseCancellationException) {
            return this.createParsingFailedException(t.getCause());
        }
        return this.createParsingFailedException(t);
    }

    public ModuleNode buildAST() {
        try {
            return this.compilationUnit(this.buildCST());
        }
        catch (Throwable t) {
            throw this.convertException(t);
        }
    }

    private ModuleNode compilationUnit(ScriptParser.CompilationUnitContext ctx) {
        ArrayList<Statement> statements = new ArrayList<Statement>();
        boolean hasDeclarations = false;
        for (ScriptParser.ScriptDeclarationOrStatementContext scriptDeclarationOrStatementContext : ctx.scriptDeclarationOrStatement()) {
            if (scriptDeclarationOrStatementContext.scriptDeclaration() != null) {
                hasDeclarations |= this.scriptDeclaration(scriptDeclarationOrStatementContext.scriptDeclaration());
            }
            if (scriptDeclarationOrStatementContext.statement() == null) continue;
            statements.add(this.statement(scriptDeclarationOrStatementContext.statement()));
        }
        for (int i = 0; i < statements.size(); ++i) {
            String defName;
            ExpressionStatement es;
            Expression expression;
            Statement statement = (Statement)statements.get(i);
            if (statement instanceof ExpressionStatement && (expression = (es = (ExpressionStatement)statement).getExpression()) instanceof MethodCallExpression) {
                MethodCallExpression mce = (MethodCallExpression)expression;
                v0 = mce.getMethodAsString();
            } else {
                v0 = defName = null;
            }
            if (defName == null || !SCRIPT_DEF_NAMES.contains(defName)) continue;
            this.collectSyntaxError(new SyntaxException("Invalid " + defName + " definition -- check for missing or out-of-order section labels", (ASTNode)statement));
            statements.set(i, (Statement)PositionConfigureUtils.ast(new InvalidDeclaration(), (ASTNode)statement));
            hasDeclarations = true;
        }
        if (hasDeclarations) {
            for (Statement statement : statements) {
                if (statement instanceof InvalidDeclaration) continue;
                this.collectSyntaxError(new SyntaxException("Statements cannot be mixed with script declarations -- move statements into a process or workflow", (ASTNode)statement));
            }
        }
        if (!statements.isEmpty()) {
            BlockStatement main = GeneralUtils.block((VariableScope)new VariableScope(), statements);
            PositionConfigureUtils.ast(main, (ASTNode)statements.get(0), (ASTNode)statements.get(statements.size() - 1));
            WorkflowNode workflowNode = this.workflowDef(main);
            this.moduleNode.addWorkflow(workflowNode);
            if (!hasDeclarations) {
                this.moduleNode.setEntry(workflowNode);
            }
        }
        this.moduleNode.addStatement((Statement)EmptyStatement.INSTANCE);
        if (this.numberFormatError != null) {
            throw this.createParsingFailedException(((Exception)this.numberFormatError.getV2()).getMessage(), (ParserRuleContext)this.numberFormatError.getV1());
        }
        return this.moduleNode;
    }

    private boolean scriptDeclaration(ScriptParser.ScriptDeclarationContext ctx) {
        if (ctx instanceof ScriptParser.FeatureFlagDeclAltContext) {
            ScriptParser.FeatureFlagDeclAltContext ffac = (ScriptParser.FeatureFlagDeclAltContext)ctx;
            FeatureFlagNode node = this.featureFlagDeclaration(ffac.featureFlagDeclaration());
            this.saveLeadingComments(node, ctx);
            this.moduleNode.addFeatureFlag(node);
        } else if (ctx instanceof ScriptParser.EnumDefAltContext) {
            ScriptParser.EnumDefAltContext edac = (ScriptParser.EnumDefAltContext)ctx;
            ClassNode node = this.enumDef(edac.enumDef());
            this.saveLeadingComments((ASTNode)node, ctx);
            this.moduleNode.addClass(node);
        } else if (ctx instanceof ScriptParser.FunctionDefAltContext) {
            ScriptParser.FunctionDefAltContext fdac = (ScriptParser.FunctionDefAltContext)ctx;
            FunctionNode node = this.functionDef(fdac.functionDef());
            this.saveLeadingComments((ASTNode)node, ctx);
            this.moduleNode.addFunction(node);
        } else {
            if (ctx instanceof ScriptParser.ImportDeclAltContext) {
                ScriptParser.ImportDeclAltContext iac = (ScriptParser.ImportDeclAltContext)ctx;
                EmptyStatement node = PositionConfigureUtils.ast(new EmptyStatement(), iac);
                this.collectSyntaxError(new SyntaxException("Groovy `import` declarations are not supported -- use fully-qualified name inline instead", (ASTNode)node));
                return false;
            }
            if (ctx instanceof ScriptParser.IncludeDeclAltContext) {
                ScriptParser.IncludeDeclAltContext iac = (ScriptParser.IncludeDeclAltContext)ctx;
                IncludeNode node = this.includeDeclaration(iac.includeDeclaration());
                this.saveLeadingComments(node, ctx);
                this.moduleNode.addInclude(node);
            } else if (ctx instanceof ScriptParser.OutputDefAltContext) {
                ScriptParser.OutputDefAltContext odac = (ScriptParser.OutputDefAltContext)ctx;
                OutputBlockNode node = this.outputDef(odac.outputDef());
                this.saveLeadingComments(node, ctx);
                if (this.moduleNode.getOutputs() != null) {
                    this.collectSyntaxError(new SyntaxException("Output block defined more than once", (ASTNode)node));
                }
                this.moduleNode.setOutputs(node);
            } else if (ctx instanceof ScriptParser.ParamDeclAltContext) {
                ScriptParser.ParamDeclAltContext pac = (ScriptParser.ParamDeclAltContext)ctx;
                ParamNode node = this.paramDeclaration(pac.paramDeclaration());
                this.saveLeadingComments(node, ctx);
                this.moduleNode.addParam(node);
            } else if (ctx instanceof ScriptParser.ProcessDefAltContext) {
                ScriptParser.ProcessDefAltContext pdac = (ScriptParser.ProcessDefAltContext)ctx;
                ProcessNode node = this.processDef(pdac.processDef());
                this.saveLeadingComments((ASTNode)node, ctx);
                this.moduleNode.addProcess(node);
            } else if (ctx instanceof ScriptParser.WorkflowDefAltContext) {
                ScriptParser.WorkflowDefAltContext wdac = (ScriptParser.WorkflowDefAltContext)ctx;
                WorkflowNode node = this.workflowDef(wdac.workflowDef());
                this.saveLeadingComments((ASTNode)node, ctx);
                if (node.isEntry()) {
                    if (this.moduleNode.getEntry() != null) {
                        this.collectSyntaxError(new SyntaxException("Entry workflow defined more than once", (ASTNode)node));
                    }
                    this.moduleNode.setEntry(node);
                }
                this.moduleNode.addWorkflow(node);
            } else {
                if (ctx instanceof ScriptParser.IncompleteScriptDeclAltContext) {
                    ScriptParser.IncompleteScriptDeclAltContext iac = (ScriptParser.IncompleteScriptDeclAltContext)ctx;
                    this.incompleteScriptDeclaration(iac.incompleteScriptDeclaration());
                    return false;
                }
                throw this.createParsingFailedException("Invalid script declaration: " + ctx.getText(), ctx);
            }
        }
        return true;
    }

    private FeatureFlagNode featureFlagDeclaration(ScriptParser.FeatureFlagDeclarationContext ctx) {
        String name = ctx.featureFlagName().getText();
        Expression value = this.expression(ctx.expression());
        FeatureFlagNode result = PositionConfigureUtils.ast(new FeatureFlagNode(name, value), ctx);
        if (!(value instanceof ConstantExpression)) {
            this.collectSyntaxError(new SyntaxException("Feature flag value must be a literal value (number, string, true/false)", (ASTNode)result));
        }
        return result;
    }

    private ParamNode paramDeclaration(ScriptParser.ParamDeclarationContext ctx) {
        Expression target = (Expression)PositionConfigureUtils.ast(GeneralUtils.varX((String)"params"), ctx.PARAMS());
        for (ScriptParser.IdentifierContext identifierContext : ctx.identifier()) {
            ConstantExpression name = PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.identifier(identifierContext)), identifierContext);
            target = (Expression)PositionConfigureUtils.ast(GeneralUtils.propX((Expression)target, (Expression)name), (ASTNode)target, (ASTNode)name);
        }
        Expression value = this.expression(ctx.expression());
        return PositionConfigureUtils.ast(new ParamNode(target, value), ctx);
    }

    private IncludeNode includeDeclaration(ScriptParser.IncludeDeclarationContext ctx) {
        ConstantExpression source = PositionConfigureUtils.ast(this.string(ctx.stringLiteral()), ctx.stringLiteral());
        List<IncludeModuleNode> modules = ctx.includeNames().includeName().stream().map((? super T it) -> {
            String name = it.name.getText();
            String alias = it.alias != null ? it.alias.getText() : null;
            IncludeModuleNode result = new IncludeModuleNode(name, alias);
            result.putNodeMetaData("_START_NAME", PositionConfigureUtils.tokenPosition(it.name));
            if (it.alias != null) {
                result.putNodeMetaData("_START_ALIAS", PositionConfigureUtils.tokenPosition(it.alias));
            }
            return PositionConfigureUtils.ast(result, it);
        }).toList();
        return PositionConfigureUtils.ast(new IncludeNode(source, modules), ctx);
    }

    private ClassNode enumDef(ScriptParser.EnumDefContext ctx) {
        String name = this.identifier(ctx.identifier());
        ClassNode result = PositionConfigureUtils.ast(EnumHelper.makeEnumNode((String)name, (int)1, null, null), ctx);
        if (ctx.enumBody() != null) {
            for (ScriptParser.IdentifierContext identifierContext : ctx.enumBody().identifier()) {
                FieldNode fn = PositionConfigureUtils.ast(EnumHelper.addEnumConstant((ClassNode)result, (String)this.identifier(identifierContext), null), identifierContext);
                this.groovydocManager.handle((ASTNode)fn, identifierContext);
            }
        }
        this.groovydocManager.handle((ASTNode)result, ctx);
        return result;
    }

    private ProcessNode processDef(ScriptParser.ProcessDefContext ctx) {
        String name = ctx.name.getText();
        if (ctx.body == null) {
            EmptyStatement empty = EmptyStatement.INSTANCE;
            ProcessNode result = PositionConfigureUtils.ast(new ProcessNode(name, (Statement)empty, (Statement)empty, (Statement)empty, (Expression)EmptyExpression.INSTANCE, null, (Statement)empty, (Statement)empty), ctx);
            this.collectSyntaxError(new SyntaxException("Missing process script body", (ASTNode)result));
            return result;
        }
        Statement directives = this.processDirectives(ctx.body.processDirectives());
        Statement inputs = this.processInputs(ctx.body.processInputs());
        Statement outputs = this.processOutputs(ctx.body.processOutputs());
        Expression when = this.processWhen(ctx.body.processWhen());
        String type = this.processType(ctx.body.processExec());
        BlockStatement exec = ctx.body.blockStatements() != null ? this.blockStatements(ctx.body.blockStatements()) : this.blockStatements(ctx.body.processExec().blockStatements());
        Statement stub = this.processStub(ctx.body.processStub());
        if (!(ctx.body.blockStatements() == null || directives instanceof EmptyStatement && inputs instanceof EmptyStatement && outputs instanceof EmptyStatement)) {
            this.collectSyntaxError(new SyntaxException("The `script:` or `exec:` label is required when other sections are present", (ASTNode)exec));
        }
        ProcessNode result = PositionConfigureUtils.ast(new ProcessNode(name, directives, inputs, outputs, when, type, (Statement)exec, stub), ctx);
        this.groovydocManager.handle((ASTNode)result, ctx);
        return result;
    }

    private Statement processDirectives(ScriptParser.ProcessDirectivesContext ctx) {
        if (ctx == null) {
            return EmptyStatement.INSTANCE;
        }
        List<Statement> statements = ctx.statement().stream().map(this::statement).map((? super T stmt) -> this.checkDirective((Statement)stmt, "Invalid process directive")).toList();
        return (Statement)PositionConfigureUtils.ast(GeneralUtils.block(null, statements), ctx);
    }

    private Statement processInputs(ScriptParser.ProcessInputsContext ctx) {
        if (ctx == null) {
            return EmptyStatement.INSTANCE;
        }
        List<Statement> statements = ctx.statement().stream().map(this::statement).map((? super T stmt) -> this.checkDirective((Statement)stmt, "Invalid process input")).toList();
        return (Statement)PositionConfigureUtils.ast(GeneralUtils.block(null, statements), ctx);
    }

    private Statement processOutputs(ScriptParser.ProcessOutputsContext ctx) {
        if (ctx == null) {
            return EmptyStatement.INSTANCE;
        }
        List<Statement> statements = ctx.statement().stream().map(this::statement).map((? super T stmt) -> this.checkDirective((Statement)stmt, "Invalid process output")).toList();
        return (Statement)PositionConfigureUtils.ast(GeneralUtils.block(null, statements), ctx);
    }

    private Statement checkDirective(Statement stmt, String errorMessage) {
        if (!(stmt instanceof ExpressionStatement)) {
            this.collectSyntaxError(new SyntaxException(errorMessage, (ASTNode)stmt));
            return (Statement)PositionConfigureUtils.ast(new EmptyStatement(), (ASTNode)stmt);
        }
        ExpressionStatement stmtX = (ExpressionStatement)stmt;
        Expression expression = stmtX.getExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            ConstantExpression method = PositionConfigureUtils.ast(GeneralUtils.constX((Object)ve.getName()), (ASTNode)ve);
            MethodCallExpression call = PositionConfigureUtils.ast(GeneralUtils.callX((Expression)VariableExpression.THIS_EXPRESSION, (Expression)method, (Expression)new ArgumentListExpression()), (ASTNode)stmtX);
            stmtX.setExpression((Expression)call);
            return stmtX;
        }
        if (this.isDirectiveWithNegativeValue(expression)) {
            BinaryExpression binary = (BinaryExpression)expression;
            VariableExpression left = (VariableExpression)binary.getLeftExpression();
            ConstantExpression method = PositionConfigureUtils.ast(GeneralUtils.constX((Object)left.getName()), (ASTNode)left);
            Expression value = (Expression)PositionConfigureUtils.ast(new UnaryMinusExpression(binary.getRightExpression()), (ASTNode)binary.getRightExpression());
            ArgumentListExpression arguments = PositionConfigureUtils.ast(GeneralUtils.args((Expression[])new Expression[]{value}), (ASTNode)value);
            MethodCallExpression call = PositionConfigureUtils.ast(GeneralUtils.callX((Expression)VariableExpression.THIS_EXPRESSION, (Expression)method, (Expression)arguments), (ASTNode)stmtX);
            stmtX.setExpression((Expression)call);
            return stmtX;
        }
        if (!(expression instanceof MethodCallExpression)) {
            this.collectSyntaxError(new SyntaxException(errorMessage, (ASTNode)stmtX));
            return (Statement)PositionConfigureUtils.ast(new EmptyStatement(), (ASTNode)stmtX);
        }
        MethodCallExpression call = (MethodCallExpression)expression;
        if (!call.isImplicitThis() || !(call.getMethod() instanceof ConstantExpression)) {
            this.collectSyntaxError(new SyntaxException(errorMessage, (ASTNode)stmtX));
            return (Statement)PositionConfigureUtils.ast(new EmptyStatement(), (ASTNode)stmtX);
        }
        return stmtX;
    }

    private boolean isDirectiveWithNegativeValue(Expression expression) {
        if (!(expression instanceof BinaryExpression)) {
            return false;
        }
        BinaryExpression binary = (BinaryExpression)expression;
        if (!(binary.getLeftExpression() instanceof VariableExpression)) {
            return false;
        }
        return binary.getOperation().getType() == 201;
    }

    private Expression processWhen(ScriptParser.ProcessWhenContext ctx) {
        if (ctx == null) {
            return EmptyExpression.INSTANCE;
        }
        return PositionConfigureUtils.ast(this.expression(ctx.expression()), ctx);
    }

    private String processType(ScriptParser.ProcessExecContext ctx) {
        if (ctx == null) {
            return "script";
        }
        if (ctx.EXEC() != null) {
            return "exec";
        }
        if (ctx.SHELL() != null) {
            this.collectWarning("The `shell` block is deprecated, use `script` instead", ctx.SHELL().getText(), (ASTNode)PositionConfigureUtils.ast(new EmptyExpression(), ctx.SHELL()));
            return "shell";
        }
        return "script";
    }

    private Statement processStub(ScriptParser.ProcessStubContext ctx) {
        if (ctx == null) {
            return EmptyStatement.INSTANCE;
        }
        return (Statement)PositionConfigureUtils.ast(this.blockStatements(ctx.blockStatements()), ctx);
    }

    private WorkflowNode workflowDef(ScriptParser.WorkflowDefContext ctx) {
        String name;
        String string = name = ctx.name != null ? ctx.name.getText() : null;
        if (ctx.body == null) {
            WorkflowNode result = PositionConfigureUtils.ast(new WorkflowNode(name, null, null, null, null), ctx);
            this.groovydocManager.handle((ASTNode)result, ctx);
            return result;
        }
        Statement takes = this.workflowTakes(ctx.body.workflowTakes());
        Statement emits = this.workflowEmits(ctx.body.workflowEmits());
        Statement publishers = this.workflowPublishers(ctx.body.workflowPublishers());
        BlockStatement main = this.blockStatements(ctx.body.workflowMain() != null ? ctx.body.workflowMain().blockStatements() : null);
        if (name == null) {
            if (takes instanceof BlockStatement) {
                this.collectSyntaxError(new SyntaxException("Entry workflow cannot have a take section", (ASTNode)takes));
            }
            if (emits instanceof BlockStatement) {
                this.collectSyntaxError(new SyntaxException("Entry workflow cannot have an emit section", (ASTNode)emits));
            }
        }
        if (name != null && publishers instanceof BlockStatement) {
            this.collectSyntaxError(new SyntaxException("Named workflow cannot have a publish section", (ASTNode)publishers));
        }
        WorkflowNode result = PositionConfigureUtils.ast(new WorkflowNode(name, takes, (Statement)main, emits, publishers), ctx);
        this.groovydocManager.handle((ASTNode)result, ctx);
        return result;
    }

    private WorkflowNode workflowDef(BlockStatement main) {
        EmptyStatement takes = EmptyStatement.INSTANCE;
        EmptyStatement emits = EmptyStatement.INSTANCE;
        EmptyStatement publishers = EmptyStatement.INSTANCE;
        return new WorkflowNode(null, (Statement)takes, (Statement)main, (Statement)emits, (Statement)publishers);
    }

    private Statement workflowTakes(ScriptParser.WorkflowTakesContext ctx) {
        if (ctx == null) {
            return EmptyStatement.INSTANCE;
        }
        List<Statement> statements = ctx.identifier().stream().map(this::workflowTake).toList();
        return (Statement)PositionConfigureUtils.ast(GeneralUtils.block(null, statements), ctx);
    }

    private Statement workflowTake(ScriptParser.IdentifierContext ctx) {
        Statement result = PositionConfigureUtils.ast(GeneralUtils.stmt((Expression)this.variableName(ctx)), ctx);
        this.saveTrailingComment((ASTNode)result, ctx);
        return result;
    }

    private Statement workflowEmits(ScriptParser.WorkflowEmitsContext ctx) {
        if (ctx == null) {
            return EmptyStatement.INSTANCE;
        }
        List<Statement> statements = ctx.statement().stream().map(this::workflowEmit).filter(stmt -> stmt != null).toList();
        BlockStatement result = PositionConfigureUtils.ast(GeneralUtils.block(null, statements), ctx);
        boolean hasEmitExpression = statements.stream().anyMatch(this::isEmitExpression);
        if (hasEmitExpression && statements.size() > 1) {
            this.collectSyntaxError(new SyntaxException("Every emit must be assigned to a name when there are multiple emits", (ASTNode)result));
        }
        return result;
    }

    private Statement workflowEmit(ScriptParser.StatementContext ctx) {
        Statement result = this.statement(ctx);
        if (!(result instanceof ExpressionStatement)) {
            this.collectSyntaxError(new SyntaxException("Invalid workflow emit -- must be a name, assignment, or expression", (ASTNode)result));
            return null;
        }
        this.saveTrailingComment((ASTNode)result, ctx);
        return result;
    }

    private boolean isEmitExpression(Statement stmt) {
        if (stmt instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)stmt;
            Expression exp = es.getExpression();
            return !(exp instanceof VariableExpression) && !(exp instanceof AssignmentExpression);
        }
        return false;
    }

    private Statement workflowPublishers(ScriptParser.WorkflowPublishersContext ctx) {
        if (ctx == null) {
            return EmptyStatement.INSTANCE;
        }
        List<Statement> statements = ctx.statement().stream().map(this::statement).map(this::checkWorkflowPublisher).filter(stmt -> stmt != null).toList();
        return (Statement)PositionConfigureUtils.ast(GeneralUtils.block(null, statements), ctx);
    }

    private Statement checkWorkflowPublisher(Statement stmt) {
        BinaryExpression be;
        ExpressionStatement es;
        Expression expression;
        boolean valid;
        boolean bl = valid = stmt instanceof ExpressionStatement && (expression = (es = (ExpressionStatement)stmt).getExpression()) instanceof BinaryExpression && (be = (BinaryExpression)expression).getLeftExpression() instanceof VariableExpression && be.getOperation().getType() == 100;
        if (!valid) {
            this.collectSyntaxError(new SyntaxException("Invalid workflow publish statement", (ASTNode)stmt));
            return null;
        }
        return stmt;
    }

    private OutputBlockNode outputDef(ScriptParser.OutputDefContext ctx) {
        List<OutputNode> declarations = this.outputBody(ctx.outputBody());
        return PositionConfigureUtils.ast(new OutputBlockNode(declarations), ctx);
    }

    private List<OutputNode> outputBody(ScriptParser.OutputBodyContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        return ctx.outputDeclaration().stream().map(this::outputDeclaration).filter(output -> output != null).toList();
    }

    private OutputNode outputDeclaration(ScriptParser.OutputDeclarationContext ctx) {
        if (ctx.statement() != null) {
            this.collectSyntaxError(new SyntaxException("Invalid output declaration", (ASTNode)this.statement(ctx.statement())));
            return null;
        }
        String name = this.identifier(ctx.identifier());
        BlockStatement body = this.blockStatements(ctx.blockStatements());
        OutputNode result = new OutputNode(name, (Statement)body);
        this.checkInvalidVarName(name, result);
        return result;
    }

    private FunctionNode functionDef(ScriptParser.FunctionDefContext ctx) {
        String name = this.identifier(ctx.identifier());
        ClassNode returnType = this.legacyType(ctx.legacyType());
        Parameter[] params = Optional.ofNullable(this.formalParameterList(ctx.formalParameterList())).orElse(Parameter.EMPTY_ARRAY);
        BlockStatement code = this.blockStatements(ctx.blockStatements());
        FunctionNode result = PositionConfigureUtils.ast(new FunctionNode(name, returnType, params, (Statement)code), ctx);
        this.checkInvalidVarName(name, (ASTNode)result);
        this.groovydocManager.handle((ASTNode)result, ctx);
        return result;
    }

    private Statement incompleteScriptDeclaration(ScriptParser.IncompleteScriptDeclarationContext ctx) {
        IncompleteNode result = PositionConfigureUtils.ast(new IncompleteNode(ctx.getText()), ctx);
        this.collectSyntaxError(new SyntaxException("Incomplete declaration", (ASTNode)result));
        return result;
    }

    private Statement statement(ScriptParser.StatementContext ctx) {
        Statement result;
        if (ctx instanceof ScriptParser.IfElseStmtAltContext) {
            ScriptParser.IfElseStmtAltContext ieac = (ScriptParser.IfElseStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.ifElseStatement(ieac.ifElseStatement()), ieac);
        } else if (ctx instanceof ScriptParser.TryCatchStmtAltContext) {
            ScriptParser.TryCatchStmtAltContext tcac = (ScriptParser.TryCatchStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.tryCatchStatement(tcac.tryCatchStatement()), tcac);
        } else if (ctx instanceof ScriptParser.ReturnStmtAltContext) {
            ScriptParser.ReturnStmtAltContext rac = (ScriptParser.ReturnStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.returnStatement(rac.expression()), rac);
        } else if (ctx instanceof ScriptParser.ThrowStmtAltContext) {
            ScriptParser.ThrowStmtAltContext tac = (ScriptParser.ThrowStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.throwStatement(tac.expression()), tac);
        } else if (ctx instanceof ScriptParser.AssertStmtAltContext) {
            ScriptParser.AssertStmtAltContext aac = (ScriptParser.AssertStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.assertStatement(aac.assertStatement()), aac);
        } else if (ctx instanceof ScriptParser.VariableDeclarationStmtAltContext) {
            ScriptParser.VariableDeclarationStmtAltContext vdac = (ScriptParser.VariableDeclarationStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.variableDeclaration(vdac.variableDeclaration()), vdac);
        } else if (ctx instanceof ScriptParser.MultipleAssignmentStmtAltContext) {
            ScriptParser.MultipleAssignmentStmtAltContext maac = (ScriptParser.MultipleAssignmentStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.assignment(maac.multipleAssignmentStatement()), maac);
        } else if (ctx instanceof ScriptParser.AssignmentStmtAltContext) {
            ScriptParser.AssignmentStmtAltContext aac = (ScriptParser.AssignmentStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.assignment(aac.assignmentStatement()), aac);
        } else if (ctx instanceof ScriptParser.ExpressionStmtAltContext) {
            ScriptParser.ExpressionStmtAltContext eac = (ScriptParser.ExpressionStmtAltContext)ctx;
            result = PositionConfigureUtils.ast(this.expressionStatement(eac.expressionStatement()), eac);
        } else {
            if (ctx instanceof ScriptParser.EmptyStmtAltContext) {
                return EmptyStatement.INSTANCE;
            }
            throw this.createParsingFailedException("Invalid statement: " + ctx.getText(), ctx);
        }
        this.saveLeadingComments((ASTNode)result, ctx);
        return result;
    }

    private Statement ifElseStatement(ScriptParser.IfElseStatementContext ctx) {
        Expression expression = PositionConfigureUtils.ast(this.parExpression(ctx.parExpression()), ctx.parExpression());
        BooleanExpression condition = PositionConfigureUtils.ast(GeneralUtils.boolX((Expression)expression), (ASTNode)expression);
        Statement thenStmt = this.statementOrBlock(ctx.tb);
        EmptyStatement elseStmt = ctx.ELSE() != null ? this.statementOrBlock(ctx.fb) : EmptyStatement.INSTANCE;
        return GeneralUtils.ifElseS((Expression)condition, (Statement)thenStmt, (Statement)elseStmt);
    }

    private Statement statementOrBlock(ScriptParser.StatementOrBlockContext ctx) {
        return ctx.statement() != null ? this.statement(ctx.statement()) : this.blockStatements(ctx.blockStatements());
    }

    private BlockStatement blockStatements(ScriptParser.BlockStatementsContext ctx) {
        if (ctx == null) {
            return GeneralUtils.block((VariableScope)new VariableScope(), Collections.emptyList());
        }
        List<Statement> statements = ctx.statement().stream().map(this::statement).toList();
        return PositionConfigureUtils.ast(GeneralUtils.block((VariableScope)new VariableScope(), statements), ctx);
    }

    private Statement tryCatchStatement(ScriptParser.TryCatchStatementContext ctx) {
        Statement tryStatement = this.statementOrBlock(ctx.statementOrBlock());
        List<List> catchClauses = ctx.catchClause().stream().map(this::catchClause).toList();
        TryCatchStatement result = GeneralUtils.tryCatchS((Statement)tryStatement);
        for (List clause : catchClauses) {
            for (CatchStatement stmt : clause) {
                result.addCatch(stmt);
            }
        }
        return result;
    }

    private List<CatchStatement> catchClause(ScriptParser.CatchClauseContext ctx) {
        List<ClassNode> types = this.catchTypes(ctx.catchTypes());
        return types.stream().map((? super T type) -> {
            String name = this.identifier(ctx.identifier());
            Parameter variable = PositionConfigureUtils.ast(GeneralUtils.param((ClassNode)type, (String)name), ctx.identifier());
            this.checkInvalidVarName(name, (ASTNode)variable);
            Statement code = this.statementOrBlock(ctx.statementOrBlock());
            return PositionConfigureUtils.ast(new CatchStatement(variable, code), ctx);
        }).toList();
    }

    private List<ClassNode> catchTypes(ScriptParser.CatchTypesContext ctx) {
        if (ctx == null) {
            return Collections.singletonList(ClassHelper.dynamicType());
        }
        return ctx.qualifiedClassName().stream().map(this::qualifiedClassName).toList();
    }

    private Statement returnStatement(ScriptParser.ExpressionContext ctx) {
        ConstantExpression result = ctx != null ? this.expression(ctx) : ConstantExpression.EMPTY_EXPRESSION;
        return GeneralUtils.returnS((Expression)result);
    }

    private Statement throwStatement(ScriptParser.ExpressionContext ctx) {
        ConstantExpression result = ctx != null ? this.expression(ctx) : ConstantExpression.EMPTY_EXPRESSION;
        return GeneralUtils.throwS((Expression)result);
    }

    private Statement assertStatement(ScriptParser.AssertStatementContext ctx) {
        BooleanExpression condition = PositionConfigureUtils.ast(GeneralUtils.boolX((Expression)this.expression(ctx.condition)), ctx.condition);
        return ctx.message != null ? new AssertStatement(condition, this.expression(ctx.message)) : new AssertStatement(condition);
    }

    private Statement variableDeclaration(ScriptParser.VariableDeclarationContext ctx) {
        if (ctx.variableNames() != null) {
            List<Expression> variables = ctx.variableNames().identifier().stream().map((? super T ident) -> this.variableName((ScriptParser.IdentifierContext)((Object)ident))).toList();
            ArgumentListExpression target = new ArgumentListExpression(variables);
            Expression initializer = this.expression(ctx.initializer);
            return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(GeneralUtils.declX((Expression)target, (Expression)initializer), ctx)));
        }
        Expression target = this.variableName(ctx.identifier());
        target.setType(this.legacyType(ctx.legacyType()));
        EmptyExpression initializer = ctx.initializer != null ? this.expression(ctx.initializer) : EmptyExpression.INSTANCE;
        return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(GeneralUtils.declX((Expression)target, (Expression)initializer), ctx)));
    }

    private Expression variableNames(ScriptParser.VariableNamesContext ctx) {
        List<Expression> vars = ctx.identifier().stream().map(this::variableName).toList();
        return (Expression)PositionConfigureUtils.ast(new TupleExpression(vars), ctx);
    }

    private Expression variableName(ScriptParser.IdentifierContext ctx) {
        String name = this.identifier(ctx);
        VariableExpression result = PositionConfigureUtils.ast(GeneralUtils.varX((String)name), ctx);
        this.checkInvalidVarName(name, (ASTNode)result);
        return result;
    }

    private void checkInvalidVarName(String name, ASTNode node) {
        if ("_".equals(name)) {
            this.collectSyntaxError(new SyntaxException("`_` is not allowed as an identifier because it is reserved for future use", node));
        }
        if (!GROOVY_KEYWORDS.contains(name)) {
            return;
        }
        if (KEYWORD_FOR.equals(name) || KEYWORD_WHILE.equals(name)) {
            this.collectSyntaxError(new SyntaxException("`" + name + "` loops are no longer supported", node));
        } else if (KEYWORD_SWITCH.equals(name)) {
            this.collectSyntaxError(new SyntaxException("`switch` statements are no longer supported", node));
        } else {
            this.collectSyntaxError(new SyntaxException("`" + name + "` is not allowed as an identifier because it is a Groovy keyword", node));
        }
    }

    private Statement assignment(ScriptParser.MultipleAssignmentStatementContext ctx) {
        Expression target = this.variableNames(ctx.variableNames());
        Expression source = this.expression(ctx.expression());
        return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(new AssignmentExpression(target, source), ctx)));
    }

    private Statement assignment(ScriptParser.AssignmentStatementContext ctx) {
        Expression target = this.expression(ctx.target);
        if (target instanceof VariableExpression && this.isInsideParentheses((NodeMetaDataHandler)target)) {
            if (((Number)target.getNodeMetaData((Object)ASTNodeMarker.INSIDE_PARENTHESES_LEVEL)).intValue() > 1) {
                throw this.createParsingFailedException("Nested parenthesis is not allowed in multiple assignment, e.g. ((a)) = b", ctx);
            }
            TupleExpression tuple = PositionConfigureUtils.ast(new TupleExpression(target), ctx.target);
            return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(new AssignmentExpression((Expression)tuple, this.token(ctx.op), this.expression(ctx.source)), ctx)));
        }
        if (this.isValidAssignmentTarget(target)) {
            return GeneralUtils.stmt((Expression)((Expression)PositionConfigureUtils.ast(new AssignmentExpression(target, this.token(ctx.op), this.expression(ctx.source)), ctx)));
        }
        throw this.createParsingFailedException("Invalid assignment target -- must be a variable, index, or property expression", ctx);
    }

    private boolean isValidAssignmentTarget(Expression target) {
        BinaryExpression be;
        if (target instanceof VariableExpression && !this.isInsideParentheses((NodeMetaDataHandler)target)) {
            return true;
        }
        if (target instanceof PropertyExpression) {
            return true;
        }
        return target instanceof BinaryExpression && (be = (BinaryExpression)target).getOperation().getType() == 30;
    }

    private Statement expressionStatement(ScriptParser.ExpressionStatementContext ctx) {
        Expression base = this.expression(ctx.expression());
        Expression expression = ctx.argumentList() != null ? this.methodCall(base, this.argumentList(ctx.argumentList())) : base;
        return PositionConfigureUtils.ast(GeneralUtils.stmt((Expression)expression), ctx);
    }

    private Expression expression(ScriptParser.ExpressionContext ctx) {
        if (ctx instanceof ScriptParser.AddSubExprAltContext) {
            ScriptParser.AddSubExprAltContext asac = (ScriptParser.AddSubExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(asac.left, asac.op, asac.right), asac);
        }
        if (ctx instanceof ScriptParser.BitwiseAndExprAltContext) {
            ScriptParser.BitwiseAndExprAltContext baac = (ScriptParser.BitwiseAndExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(baac.left, baac.op, baac.right), baac);
        }
        if (ctx instanceof ScriptParser.BitwiseOrExprAltContext) {
            ScriptParser.BitwiseOrExprAltContext boac = (ScriptParser.BitwiseOrExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(boac.left, boac.op, boac.right), boac);
        }
        if (ctx instanceof ScriptParser.ConditionalExprAltContext) {
            ScriptParser.ConditionalExprAltContext cac = (ScriptParser.ConditionalExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.ternary(cac), cac);
        }
        if (ctx instanceof ScriptParser.EqualityExprAltContext) {
            ScriptParser.EqualityExprAltContext eac = (ScriptParser.EqualityExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(eac.left, eac.op, eac.right), eac);
        }
        if (ctx instanceof ScriptParser.ExclusiveOrExprAltContext) {
            ScriptParser.ExclusiveOrExprAltContext eoac = (ScriptParser.ExclusiveOrExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(eoac.left, eoac.op, eoac.right), eoac);
        }
        if (ctx instanceof ScriptParser.LogicalAndExprAltContext) {
            ScriptParser.LogicalAndExprAltContext laac = (ScriptParser.LogicalAndExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(laac.left, laac.op, laac.right), laac);
        }
        if (ctx instanceof ScriptParser.LogicalOrExprAltContext) {
            ScriptParser.LogicalOrExprAltContext loac = (ScriptParser.LogicalOrExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(loac.left, loac.op, loac.right), loac);
        }
        if (ctx instanceof ScriptParser.MultDivExprAltContext) {
            ScriptParser.MultDivExprAltContext mdac = (ScriptParser.MultDivExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(mdac.left, mdac.op, mdac.right), mdac);
        }
        if (ctx instanceof ScriptParser.PathExprAltContext) {
            ScriptParser.PathExprAltContext pac = (ScriptParser.PathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathExpression(pac), pac);
        }
        if (ctx instanceof ScriptParser.PowerExprAltContext) {
            ScriptParser.PowerExprAltContext pac = (ScriptParser.PowerExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(pac.left, pac.op, pac.right), pac);
        }
        if (ctx instanceof ScriptParser.RegexExprAltContext) {
            ScriptParser.RegexExprAltContext rac = (ScriptParser.RegexExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(rac.left, rac.op, rac.right), rac);
        }
        if (ctx instanceof ScriptParser.RelationalExprAltContext) {
            ScriptParser.RelationalExprAltContext rac = (ScriptParser.RelationalExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.binary(rac.left, rac.op, rac.right), rac);
        }
        if (ctx instanceof ScriptParser.RelationalCastExprAltContext) {
            ScriptParser.RelationalCastExprAltContext rcac = (ScriptParser.RelationalCastExprAltContext)ctx;
            Expression operand = this.expression(rcac.expression());
            ClassNode type = this.type(rcac.type());
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.asX((ClassNode)type, (Expression)operand), rcac);
        }
        if (ctx instanceof ScriptParser.RelationalTypeExprAltContext) {
            ScriptParser.RelationalTypeExprAltContext rtac = (ScriptParser.RelationalTypeExprAltContext)ctx;
            ClassExpression right = PositionConfigureUtils.ast(new ClassExpression(this.type(rtac.type(), false)), rtac.type());
            return PositionConfigureUtils.ast(this.binary(rtac.left, rtac.op, (Expression)right), rtac);
        }
        if (ctx instanceof ScriptParser.ShiftExprAltContext) {
            ScriptParser.ShiftExprAltContext sac = (ScriptParser.ShiftExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.shift(sac), sac);
        }
        if (ctx instanceof ScriptParser.UnaryAddExprAltContext) {
            ScriptParser.UnaryAddExprAltContext uaac = (ScriptParser.UnaryAddExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.unaryAdd(this.expression(uaac.expression()), uaac.op), uaac);
        }
        if (ctx instanceof ScriptParser.UnaryNotExprAltContext) {
            ScriptParser.UnaryNotExprAltContext unac = (ScriptParser.UnaryNotExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.unaryNot(this.expression(unac.expression()), unac.op), unac);
        }
        if (ctx instanceof ScriptParser.IncompleteExprAltContext) {
            ScriptParser.IncompleteExprAltContext iac = (ScriptParser.IncompleteExprAltContext)ctx;
            Expression object = this.expression(iac.expression());
            PropertyExpression result = PositionConfigureUtils.ast(GeneralUtils.propX((Expression)object, (String)""), iac);
            this.collectSyntaxError(new SyntaxException("Incomplete expression", (ASTNode)result));
            return result;
        }
        throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
    }

    private Expression binary(ScriptParser.ExpressionContext left, org.antlr.v4.runtime.Token op, ScriptParser.ExpressionContext right) {
        return GeneralUtils.binX((Expression)this.expression(left), (Token)this.token(op), (Expression)this.expression(right));
    }

    private Expression binary(ScriptParser.ExpressionContext left, org.antlr.v4.runtime.Token op, Expression right) {
        return GeneralUtils.binX((Expression)this.expression(left), (Token)this.token(op), (Expression)right);
    }

    private Expression shift(ScriptParser.ShiftExprAltContext ctx) {
        Expression left = this.expression(ctx.left);
        Expression right = this.expression(ctx.right);
        if (ctx.riOp != null) {
            return new RangeExpression(left, right, true);
        }
        if (ctx.reOp != null) {
            return new RangeExpression(left, right, false, true);
        }
        Token op = null;
        if (ctx.dlOp != null) {
            op = this.token(ctx.dlOp, 2);
        }
        if (ctx.dgOp != null) {
            op = this.token(ctx.dgOp, 2);
        }
        if (ctx.tgOp != null) {
            op = this.token(ctx.tgOp, 3);
        }
        return GeneralUtils.binX((Expression)left, (Token)op, (Expression)right);
    }

    private Expression ternary(ScriptParser.ConditionalExprAltContext ctx) {
        if (ctx.ELVIS() != null) {
            return GeneralUtils.elvisX((Expression)this.expression(ctx.condition), (Expression)this.expression(ctx.fb));
        }
        BooleanExpression condition = PositionConfigureUtils.ast(GeneralUtils.boolX((Expression)this.expression(ctx.condition)), ctx.condition);
        return GeneralUtils.ternaryX((Expression)condition, (Expression)this.expression(ctx.tb), (Expression)this.expression(ctx.fb));
    }

    private Expression unaryAdd(Expression expression, org.antlr.v4.runtime.Token op) {
        if (op.getType() == 82) {
            return new UnaryPlusExpression(expression);
        }
        if (op.getType() == 83) {
            return new UnaryMinusExpression(expression);
        }
        throw new IllegalStateException();
    }

    private Expression unaryNot(Expression expression, org.antlr.v4.runtime.Token op) {
        if (op.getType() == 72) {
            return new NotExpression(expression);
        }
        if (op.getType() == 73) {
            return new BitwiseNegationExpression(expression);
        }
        throw new IllegalStateException();
    }

    private Expression pathExpression(ScriptParser.PathExprAltContext ctx) {
        try {
            Expression primary = this.primary(ctx.primary());
            return (Expression)ctx.pathElement().stream().map((? super T el) -> el).reduce(primary, (acc, el) -> this.pathElement((Expression)acc, (ScriptParser.PathElementContext)((Object)((Object)el))));
        }
        catch (IllegalStateException e) {
            throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
        }
    }

    private Expression pathElement(Expression expression, ScriptParser.PathElementContext ctx) {
        if (ctx instanceof ScriptParser.PropertyPathExprAltContext) {
            ScriptParser.PropertyPathExprAltContext pac = (ScriptParser.PropertyPathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathPropertyElement(expression, pac), (ASTNode)expression, pac);
        }
        if (ctx instanceof ScriptParser.ClosurePathExprAltContext) {
            ScriptParser.ClosurePathExprAltContext cac = (ScriptParser.ClosurePathExprAltContext)ctx;
            Expression closure = this.closure(cac.closure());
            return PositionConfigureUtils.ast(this.pathClosureElement(expression, closure), (ASTNode)expression, cac);
        }
        if (ctx instanceof ScriptParser.ClosureWithLabelsPathExprAltContext) {
            ScriptParser.ClosureWithLabelsPathExprAltContext clac = (ScriptParser.ClosureWithLabelsPathExprAltContext)ctx;
            Expression closure = this.closureWithLabels(clac.closureWithLabels());
            return PositionConfigureUtils.ast(this.pathClosureElement(expression, closure), (ASTNode)expression, clac);
        }
        if (ctx instanceof ScriptParser.ArgumentsPathExprAltContext) {
            ScriptParser.ArgumentsPathExprAltContext aac = (ScriptParser.ArgumentsPathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathArgumentsElement(expression, aac.arguments()), (ASTNode)expression, aac);
        }
        if (ctx instanceof ScriptParser.IndexPathExprAltContext) {
            ScriptParser.IndexPathExprAltContext iac = (ScriptParser.IndexPathExprAltContext)ctx;
            return PositionConfigureUtils.ast(this.pathIndexElement(expression, iac.indexPropertyArgs()), (ASTNode)expression, iac);
        }
        throw new IllegalStateException();
    }

    private Expression pathPropertyElement(Expression expression, ScriptParser.PropertyPathExprAltContext ctx) {
        Expression property = this.namedProperty(ctx.namedProperty());
        boolean safe = ctx.SAFE_DOT() != null || ctx.SPREAD_DOT() != null;
        PropertyExpression result = new PropertyExpression(expression, property, safe);
        if (ctx.SPREAD_DOT() != null) {
            result.setSpreadSafe(true);
        }
        return result;
    }

    private Expression namedProperty(ScriptParser.NamedPropertyContext ctx) {
        if (ctx.keywords() != null) {
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.keywords(ctx.keywords())), ctx);
        }
        if (ctx.identifier() != null) {
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.identifier(ctx.identifier())), ctx);
        }
        if (ctx.stringLiteral() != null) {
            return (Expression)PositionConfigureUtils.ast(this.string(ctx.stringLiteral()), ctx);
        }
        throw new IllegalStateException();
    }

    private Expression pathClosureElement(Expression expression, Expression closure) {
        if (expression instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)expression;
            if (!(mce.getArguments() instanceof ArgumentListExpression)) {
                throw new IllegalStateException();
            }
            ArgumentListExpression arguments = (ArgumentListExpression)mce.getArguments();
            arguments.addExpression(closure);
            return mce;
        }
        ArgumentListExpression arguments = PositionConfigureUtils.ast(GeneralUtils.args((Expression[])new Expression[]{closure}), (ASTNode)closure);
        if (expression instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)expression;
            return this.propMethodCall(pe, (Expression)arguments);
        }
        if (this.isConstMethodName(expression)) {
            return this.thisMethodCall(expression, (Expression)arguments);
        }
        return this.callMethodCall(expression, (Expression)arguments);
    }

    private Expression pathArgumentsElement(Expression caller, ScriptParser.ArgumentsContext ctx) {
        Expression arguments = this.argumentList(ctx.argumentList());
        if (ctx.COMMA() != null) {
            arguments.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return PositionConfigureUtils.ast(this.methodCall(caller, arguments), (ASTNode)caller, ctx);
    }

    private Expression pathIndexElement(Expression expression, ScriptParser.IndexPropertyArgsContext ctx) {
        Expression index;
        List<Expression> elements = this.expressionList(ctx.expressionList());
        if (elements.size() > 1) {
            ListExpression list = GeneralUtils.listX(elements);
            list.setWrapped(true);
            index = list;
        } else {
            index = elements.get(0);
        }
        return GeneralUtils.indexX((Expression)expression, (Expression)PositionConfigureUtils.ast(index, ctx));
    }

    private Expression primary(ScriptParser.PrimaryContext ctx) {
        if (ctx instanceof ScriptParser.IdentifierPrmrAltContext) {
            ScriptParser.IdentifierPrmrAltContext iac = (ScriptParser.IdentifierPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.variableName(iac.identifier()), iac);
        }
        if (ctx instanceof ScriptParser.LiteralPrmrAltContext) {
            ScriptParser.LiteralPrmrAltContext lac = (ScriptParser.LiteralPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.literal(lac.literal()), lac);
        }
        if (ctx instanceof ScriptParser.GstringPrmrAltContext) {
            ScriptParser.GstringPrmrAltContext gac = (ScriptParser.GstringPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.gstring(gac.gstring()), gac);
        }
        if (ctx instanceof ScriptParser.NewPrmrAltContext) {
            ScriptParser.NewPrmrAltContext nac = (ScriptParser.NewPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.creator(nac.creator()), nac);
        }
        if (ctx instanceof ScriptParser.ParenPrmrAltContext) {
            ScriptParser.ParenPrmrAltContext pac = (ScriptParser.ParenPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.parExpression(pac.parExpression()), pac);
        }
        if (ctx instanceof ScriptParser.ClosurePrmrAltContext) {
            ScriptParser.ClosurePrmrAltContext cac = (ScriptParser.ClosurePrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.closure(cac.closure()), cac);
        }
        if (ctx instanceof ScriptParser.ListPrmrAltContext) {
            ScriptParser.ListPrmrAltContext lac = (ScriptParser.ListPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.list(lac.list()), lac);
        }
        if (ctx instanceof ScriptParser.MapPrmrAltContext) {
            ScriptParser.MapPrmrAltContext mac = (ScriptParser.MapPrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.map(mac.map()), mac);
        }
        if (ctx instanceof ScriptParser.BuiltInTypePrmrAltContext) {
            ScriptParser.BuiltInTypePrmrAltContext bac = (ScriptParser.BuiltInTypePrmrAltContext)ctx;
            return PositionConfigureUtils.ast(this.builtInType(bac.builtInType()), bac);
        }
        throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
    }

    private Expression builtInType(ScriptParser.BuiltInTypeContext ctx) {
        return GeneralUtils.varX((String)ctx.getText());
    }

    private String identifier(ScriptParser.IdentifierContext ctx) {
        return ctx.getText();
    }

    private String keywords(ScriptParser.KeywordsContext ctx) {
        return ctx.getText();
    }

    private Expression literal(ScriptParser.LiteralContext ctx) {
        if (ctx instanceof ScriptParser.IntegerLiteralAltContext) {
            ScriptParser.IntegerLiteralAltContext iac = (ScriptParser.IntegerLiteralAltContext)ctx;
            return PositionConfigureUtils.ast(this.integerLiteral(iac), iac);
        }
        if (ctx instanceof ScriptParser.FloatingPointLiteralAltContext) {
            ScriptParser.FloatingPointLiteralAltContext fac = (ScriptParser.FloatingPointLiteralAltContext)ctx;
            return PositionConfigureUtils.ast(this.floatingPointLiteral(fac), fac);
        }
        if (ctx instanceof ScriptParser.StringLiteralAltContext) {
            ScriptParser.StringLiteralAltContext sac = (ScriptParser.StringLiteralAltContext)ctx;
            return (Expression)PositionConfigureUtils.ast(this.string(sac.stringLiteral()), sac);
        }
        if (ctx instanceof ScriptParser.BooleanLiteralAltContext) {
            ScriptParser.BooleanLiteralAltContext bac = (ScriptParser.BooleanLiteralAltContext)ctx;
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)"true".equals(bac.getText())), bac);
        }
        if (ctx instanceof ScriptParser.NullLiteralAltContext) {
            ScriptParser.NullLiteralAltContext nac = (ScriptParser.NullLiteralAltContext)ctx;
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX(null), nac);
        }
        throw this.createParsingFailedException("Invalid expression: " + ctx.getText(), ctx);
    }

    private Expression integerLiteral(ScriptParser.IntegerLiteralAltContext ctx) {
        String text = ctx.getText();
        Number num = null;
        try {
            num = Numbers.parseInteger((String)text);
        }
        catch (Exception e) {
            this.numberFormatError = new Tuple2((Object)ctx, (Object)e);
        }
        ConstantExpression result = GeneralUtils.constX((Object)num, (boolean)true);
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private Expression floatingPointLiteral(ScriptParser.FloatingPointLiteralAltContext ctx) {
        String text = ctx.getText();
        Number num = null;
        try {
            num = Numbers.parseDecimal((String)text);
        }
        catch (Exception e) {
            this.numberFormatError = new Tuple2((Object)ctx, (Object)e);
        }
        ConstantExpression result = GeneralUtils.constX((Object)num, (boolean)true);
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private ConstantExpression string(ParserRuleContext ctx) {
        String text = ctx.getText();
        ConstantExpression result = GeneralUtils.constX((Object)this.stringLiteral(text));
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private String stringLiteral(ScriptParser.StringLiteralContext ctx) {
        return this.stringLiteral(ctx.getText());
    }

    private String stringLiteral(String text) {
        boolean startsWithSlash = text.startsWith(SLASH_STR);
        if (text.startsWith(TSQ_STR) || text.startsWith(TDQ_STR)) {
            text = StringUtils.removeCR((String)text);
            text = StringUtils.trimQuotations((String)text, (int)3);
        } else if (text.startsWith(SQ_STR) || text.startsWith(DQ_STR) || startsWithSlash) {
            if (startsWithSlash) {
                text = StringUtils.removeCR((String)text);
            }
            text = StringUtils.trimQuotations((String)text, (int)1);
        }
        int slashyType = startsWithSlash ? 1 : 0;
        return StringUtils.replaceEscapes((String)text, (int)slashyType);
    }

    private Expression gstring(ScriptParser.GstringContext ctx) {
        ParserRuleContext eac;
        ParserRuleContext pac;
        ParserRuleContext tac;
        String text = ctx.getText();
        String beginQuotation = this.beginQuotation(text);
        String verbatimText = this.stringLiteral(text);
        GStringBuilder builder = new GStringBuilder();
        for (ScriptParser.GstringDqPartContext gstringDqPartContext : ctx.gstringDqPart()) {
            if (gstringDqPartContext instanceof ScriptParser.GstringDqTextAltContext) {
                tac = (ScriptParser.GstringDqTextAltContext)gstringDqPartContext;
                builder.appendString(PositionConfigureUtils.ast(this.gstringText(tac, beginQuotation), tac));
            }
            if (gstringDqPartContext instanceof ScriptParser.GstringDqPathAltContext) {
                pac = (ScriptParser.GstringDqPathAltContext)gstringDqPartContext;
                builder.appendValue(PositionConfigureUtils.ast(this.gstringPath(pac), pac));
            }
            if (!(gstringDqPartContext instanceof ScriptParser.GstringDqExprAltContext)) continue;
            eac = (ScriptParser.GstringDqExprAltContext)gstringDqPartContext;
            builder.appendValue(this.expression(eac.expression()));
        }
        for (ScriptParser.GstringTdqPartContext gstringTdqPartContext : ctx.gstringTdqPart()) {
            if (gstringTdqPartContext instanceof ScriptParser.GstringTdqTextAltContext) {
                tac = (ScriptParser.GstringTdqTextAltContext)gstringTdqPartContext;
                builder.appendString(PositionConfigureUtils.ast(this.gstringText(tac, beginQuotation), tac));
            }
            if (gstringTdqPartContext instanceof ScriptParser.GstringTdqPathAltContext) {
                pac = (ScriptParser.GstringTdqPathAltContext)gstringTdqPartContext;
                builder.appendValue(PositionConfigureUtils.ast(this.gstringPath(pac), pac));
            }
            if (!(gstringTdqPartContext instanceof ScriptParser.GstringTdqExprAltContext)) continue;
            eac = (ScriptParser.GstringTdqExprAltContext)gstringTdqPartContext;
            builder.appendValue(this.expression(eac.expression()));
        }
        GStringExpression result = builder.build(verbatimText);
        result.putNodeMetaData((Object)ASTNodeMarker.QUOTE_CHAR, (Object)beginQuotation);
        return result;
    }

    private String beginQuotation(String text) {
        if (text.startsWith(TDQ_STR)) {
            return TDQ_STR;
        }
        if (text.startsWith(DQ_STR)) {
            return DQ_STR;
        }
        throw new IllegalStateException();
    }

    private ConstantExpression gstringText(ParserRuleContext ctx, String beginQuotation) {
        String text = ctx.getText();
        String quotedText = new StringBuilder(text).insert(0, beginQuotation).append(beginQuotation).toString();
        ConstantExpression result = GeneralUtils.constX((Object)this.stringLiteral(quotedText));
        result.putNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT, (Object)text);
        return result;
    }

    private Expression gstringPath(ParserRuleContext ctx) {
        String[] names = ctx.getText().split("\\.");
        int currentLine = ctx.getStart().getLine();
        int currentChar = ctx.getStart().getCharPositionInLine() + 1;
        String varName = names[0].substring(1);
        VariableExpression result = GeneralUtils.varX((String)varName);
        result.setLineNumber(currentLine);
        result.setColumnNumber(++currentChar);
        result.setLastLineNumber(currentLine);
        result.setLastColumnNumber(currentChar += varName.length());
        for (int i = 1; i < names.length; ++i) {
            String propName = names[i];
            ConstantExpression property = GeneralUtils.constX((Object)propName);
            property.setLineNumber(currentLine);
            property.setColumnNumber(++currentChar);
            property.setLastLineNumber(currentLine);
            property.setLastColumnNumber(currentChar += propName.length());
            result = (Expression)PositionConfigureUtils.ast(GeneralUtils.propX((Expression)result, (Expression)property), (ASTNode)result, (ASTNode)property);
        }
        return result;
    }

    private Expression creator(ScriptParser.CreatorContext ctx) {
        ClassNode type = this.createdName(ctx.createdName());
        Expression arguments = this.argumentList(ctx.arguments().argumentList());
        if (ctx.arguments().COMMA() != null) {
            arguments.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return GeneralUtils.ctorX((ClassNode)type, (Expression)arguments);
    }

    private Expression parExpression(ScriptParser.ParExpressionContext ctx) {
        Expression expression = this.expression(ctx.expression());
        ((AtomicInteger)expression.getNodeMetaData((Object)ASTNodeMarker.INSIDE_PARENTHESES_LEVEL, k -> new AtomicInteger())).getAndAdd(1);
        return expression;
    }

    private Expression closure(ScriptParser.ClosureContext ctx) {
        Parameter[] params = this.formalParameterList(ctx.formalParameterList());
        BlockStatement code = this.blockStatements(ctx.blockStatements());
        return (Expression)PositionConfigureUtils.ast(GeneralUtils.closureX((Parameter[])params, (Statement)code), ctx);
    }

    private Expression closureWithLabels(ScriptParser.ClosureWithLabelsContext ctx) {
        Parameter[] params = this.formalParameterList(ctx.formalParameterList());
        BlockStatement code = this.blockStatementsWithLabels(ctx.blockStatementsWithLabels());
        return (Expression)PositionConfigureUtils.ast(GeneralUtils.closureX((Parameter[])params, (Statement)code), ctx);
    }

    private BlockStatement blockStatementsWithLabels(ScriptParser.BlockStatementsWithLabelsContext ctx) {
        List<Statement> statements = ctx.statementOrLabeled().stream().map(this::statementOrLabeled).toList();
        return PositionConfigureUtils.ast(GeneralUtils.block((VariableScope)new VariableScope(), statements), ctx);
    }

    private Statement statementOrLabeled(ScriptParser.StatementOrLabeledContext ctx) {
        if (ctx.identifier() != null) {
            String label = this.identifier(ctx.identifier());
            Statement result = this.statementOrLabeled(ctx.statementOrLabeled());
            result.addStatementLabel(label);
            return result;
        }
        return this.statement(ctx.statement());
    }

    private Expression list(ScriptParser.ListContext ctx) {
        if (ctx.COMMA() != null && ctx.expressionList() == null) {
            throw this.createParsingFailedException("Empty list literal should not contain any comma(,)", ctx.COMMA());
        }
        ListExpression result = GeneralUtils.listX(this.expressionList(ctx.expressionList()));
        if (ctx.COMMA() != null) {
            result.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return result;
    }

    private List<Expression> expressionList(ScriptParser.ExpressionListContext ctx) {
        if (ctx == null) {
            return Collections.emptyList();
        }
        return ctx.expression().stream().map(this::expression).toList();
    }

    private Expression map(ScriptParser.MapContext ctx) {
        if (ctx.mapEntryList() == null) {
            return new MapExpression();
        }
        List<MapEntryExpression> entries = ctx.mapEntryList().mapEntry().stream().map(this::mapEntry).toList();
        MapExpression result = GeneralUtils.mapX(entries);
        if (ctx.COMMA() != null) {
            result.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA, (Object)Boolean.TRUE);
        }
        return result;
    }

    private MapEntryExpression mapEntry(ScriptParser.MapEntryContext ctx) {
        Expression key = this.mapEntryLabel(ctx.mapEntryLabel());
        Expression value = this.expression(ctx.expression());
        return PositionConfigureUtils.ast(GeneralUtils.entryX((Expression)key, (Expression)value), ctx);
    }

    private Expression mapEntryLabel(ScriptParser.MapEntryLabelContext ctx) {
        if (ctx.keywords() != null) {
            return (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)this.keywords(ctx.keywords())), ctx);
        }
        if (ctx.primary() != null) {
            VariableExpression ve;
            Expression expression = this.primary(ctx.primary());
            return expression instanceof VariableExpression && !this.isInsideParentheses((NodeMetaDataHandler)(ve = (VariableExpression)expression)) ? (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)ve.getName()), (ASTNode)ve) : PositionConfigureUtils.ast(expression, ctx);
        }
        throw this.createParsingFailedException("Unsupported map entry label: " + ctx.getText(), ctx);
    }

    private Expression methodCall(Expression caller, Expression arguments) {
        if (this.isInsideParentheses((NodeMetaDataHandler)caller)) {
            return this.callMethodCall(caller, arguments);
        }
        if (caller instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)caller;
            return this.propMethodCall(pe, arguments);
        }
        if (this.isConstMethodName(caller)) {
            return this.thisMethodCall(caller, arguments);
        }
        return this.callMethodCall(caller, arguments);
    }

    private boolean isConstMethodName(Expression caller) {
        ConstantExpression ce;
        if (caller instanceof VariableExpression) {
            return true;
        }
        return caller instanceof ConstantExpression && (ce = (ConstantExpression)caller).getValue() instanceof String;
    }

    private Expression propMethodCall(PropertyExpression caller, Expression arguments) {
        MethodCallExpression result = GeneralUtils.callX((Expression)caller.getObjectExpression(), (Expression)caller.getProperty(), (Expression)arguments);
        result.setImplicitThis(false);
        result.setSafe(caller.isSafe());
        result.setSpreadSafe(caller.isSpreadSafe());
        if (caller.isSpreadSafe()) {
            result.setSafe(false);
        }
        return (Expression)PositionConfigureUtils.ast(result, (ASTNode)caller, (ASTNode)arguments);
    }

    private Expression thisMethodCall(Expression caller, Expression arguments) {
        Expression expression;
        VariableExpression object = VariableExpression.THIS_EXPRESSION;
        object.setColumnNumber(caller.getColumnNumber());
        object.setLineNumber(caller.getLineNumber());
        if (caller instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)caller;
            expression = (Expression)PositionConfigureUtils.ast(GeneralUtils.constX((Object)ve.getText()), (ASTNode)ve);
        } else {
            expression = caller;
        }
        Expression name = expression;
        return (Expression)PositionConfigureUtils.ast(GeneralUtils.callX((Expression)object, (Expression)name, (Expression)arguments), (ASTNode)caller, (ASTNode)arguments);
    }

    private Expression callMethodCall(Expression caller, Expression arguments) {
        MethodCallExpression call = GeneralUtils.callX((Expression)caller, (String)CALL_STR, (Expression)arguments);
        call.setImplicitThis(false);
        return (Expression)PositionConfigureUtils.ast(call, (ASTNode)caller, (ASTNode)arguments);
    }

    private Expression argumentList(ScriptParser.ArgumentListContext ctx) {
        if (ctx == null) {
            return new ArgumentListExpression();
        }
        ArrayList<Object> arguments = new ArrayList<Object>();
        ArrayList<MapEntryExpression> namedArgs = new ArrayList<MapEntryExpression>();
        for (ScriptParser.ArgumentListElementContext argumentListElementContext : ctx.argumentListElement()) {
            if (argumentListElementContext.expression() != null) {
                arguments.add(this.expression(argumentListElementContext.expression()));
                continue;
            }
            if (argumentListElementContext.namedArg() == null) continue;
            MapEntryExpression namedArg = this.namedArg(argumentListElementContext.namedArg());
            this.checkDuplicateNamedArg(namedArgs, namedArg);
            namedArgs.add(namedArg);
        }
        if (!namedArgs.isEmpty()) {
            arguments.add(0, new NamedArgumentListExpression(namedArgs));
        }
        return (Expression)PositionConfigureUtils.ast(GeneralUtils.args(arguments), ctx);
    }

    private MapEntryExpression namedArg(ScriptParser.NamedArgContext ctx) {
        Expression key = this.namedProperty(ctx.namedProperty());
        Expression value = this.expression(ctx.expression());
        return PositionConfigureUtils.ast(new MapEntryExpression(key, value), ctx);
    }

    private void checkDuplicateNamedArg(List<MapEntryExpression> namedArgs, MapEntryExpression namedArg) {
        String name = namedArg.getKeyExpression().getText();
        for (MapEntryExpression arg : namedArgs) {
            if (!arg.getKeyExpression().getText().equals(name)) continue;
            throw this.createParsingFailedException("Duplicated named argument '" + name + "' found", (ASTNode)namedArg);
        }
    }

    private Parameter[] formalParameterList(ScriptParser.FormalParameterListContext ctx) {
        if (ctx == null) {
            return Parameter.EMPTY_ARRAY;
        }
        List<Parameter> params = ctx.formalParameter().stream().map(this::formalParameter).toList();
        int n = params.size();
        for (int i = n - 1; i >= 0; --i) {
            Parameter param = params.get(i);
            for (Parameter other : params) {
                if (other == param || !other.getName().equals(param.getName())) continue;
                throw this.createParsingFailedException("Duplicated parameter '" + param.getName() + "' found", (ASTNode)param);
            }
        }
        return params.toArray(Parameter.EMPTY_ARRAY);
    }

    private Parameter formalParameter(ScriptParser.FormalParameterContext ctx) {
        ClassNode type = this.legacyType(ctx.legacyType());
        String name = this.identifier(ctx.identifier());
        Expression defaultValue = ctx.expression() != null ? this.expression(ctx.expression()) : null;
        Parameter result = PositionConfigureUtils.ast(GeneralUtils.param((ClassNode)type, (String)name, (Expression)defaultValue), ctx);
        this.checkInvalidVarName(name, (ASTNode)result);
        result.putNodeMetaData((Object)"_START_NAME", (Object)PositionConfigureUtils.tokenPosition(ctx.identifier()));
        return result;
    }

    private Token token(org.antlr.v4.runtime.Token token) {
        return this.token(token, 1);
    }

    private Token token(org.antlr.v4.runtime.Token token, int cardinality) {
        String tokenText = token.getText();
        int tokenType = token.getType();
        String text = cardinality == 1 ? tokenText : tokenText.repeat(cardinality);
        int type = tokenType == 49 || tokenType == 48 ? 1104 : Types.lookup((String)text, (int)1000);
        return new Token(type, text, token.getLine(), token.getCharPositionInLine() + 1);
    }

    private ClassNode createdName(ScriptParser.CreatedNameContext ctx) {
        if (ctx.qualifiedClassName() != null) {
            ClassNode classNode = this.qualifiedClassName(ctx.qualifiedClassName());
            if (ctx.typeArguments() != null) {
                classNode.setGenericsTypes(this.typeArguments(ctx.typeArguments()));
            }
            return classNode;
        }
        if (ctx.primitiveType() != null) {
            return this.primitiveType(ctx.primitiveType());
        }
        throw this.createParsingFailedException("Unrecognized created name: " + ctx.getText(), ctx);
    }

    private ClassNode primitiveType(ScriptParser.PrimitiveTypeContext ctx) {
        ClassNode classNode = ClassHelper.make((String)ctx.getText()).getPlainNodeReference(false);
        return PositionConfigureUtils.ast(classNode, ctx);
    }

    private ClassNode qualifiedClassName(ScriptParser.QualifiedClassNameContext ctx) {
        return this.qualifiedClassName(ctx, true);
    }

    private ClassNode qualifiedClassName(ScriptParser.QualifiedClassNameContext ctx, boolean allowProxy) {
        String text = ctx.getText();
        ClassNode classNode = ClassHelper.make((String)text);
        if (text.contains(".")) {
            classNode.putNodeMetaData((Object)ASTNodeMarker.FULLY_QUALIFIED, (Object)true);
        }
        if (classNode.isUsingGenerics() && allowProxy) {
            ClassNode proxy = ClassHelper.makeWithoutCaching((String)classNode.getName());
            proxy.setRedirect(classNode);
            return proxy;
        }
        return PositionConfigureUtils.ast(classNode, ctx);
    }

    private ClassNode type(ScriptParser.TypeContext ctx) {
        return this.type(ctx, true);
    }

    private ClassNode type(ScriptParser.TypeContext ctx, boolean allowProxy) {
        if (ctx == null) {
            return ClassHelper.dynamicType();
        }
        if (ctx.qualifiedClassName() != null) {
            ClassNode classNode = this.qualifiedClassName(ctx.qualifiedClassName(), allowProxy);
            if (ctx.typeArguments() != null) {
                classNode.setGenericsTypes(this.typeArguments(ctx.typeArguments()));
            }
            return classNode;
        }
        if (ctx.primitiveType() != null) {
            return this.primitiveType(ctx.primitiveType());
        }
        throw this.createParsingFailedException("Unrecognized type: " + ctx.getText(), ctx);
    }

    private GenericsType[] typeArguments(ScriptParser.TypeArgumentsContext ctx) {
        return (GenericsType[])ctx.type().stream().map(this::genericsType).toArray(GenericsType[]::new);
    }

    private GenericsType genericsType(ScriptParser.TypeContext ctx) {
        return PositionConfigureUtils.ast(new GenericsType(this.type(ctx)), ctx);
    }

    private ClassNode legacyType(ParserRuleContext ctx) {
        ClassNode result = ClassHelper.dynamicType();
        if (ctx != null) {
            result.putNodeMetaData((Object)ASTNodeMarker.LEGACY_TYPE, (Object)ctx.getText());
        }
        return result;
    }

    private void saveLeadingComments(ASTNode node, ParserRuleContext ctx) {
        ArrayList<String> comments = new ArrayList<String>();
        ParserRuleContext child = ctx;
        while (this.saveLeadingComments0(child, comments)) {
            child = child.getParent();
        }
        if (!comments.isEmpty()) {
            node.putNodeMetaData((Object)ASTNodeMarker.LEADING_COMMENTS, comments);
        }
    }

    private boolean saveLeadingComments0(ParserRuleContext ctx, List<String> comments) {
        ParseTree sibling;
        int i;
        ParserRuleContext parent = ctx.getParent();
        if (parent == null) {
            return false;
        }
        List siblings = parent.children;
        for (i = 0; i < siblings.size() && siblings.get(i) != ctx; ++i) {
        }
        if (i == 0) {
            return true;
        }
        boolean added = false;
        for (int j = i - 1; j >= 0 && ((sibling = (ParseTree)siblings.get(j)) instanceof ScriptParser.NlsContext || sibling instanceof ScriptParser.SepContext); --j) {
            List<? extends TerminalNode> newlines = sibling instanceof ScriptParser.NlsContext ? ((ScriptParser.NlsContext)sibling).NL() : ((ScriptParser.SepContext)sibling).NL();
            for (int k = newlines.size() - 1; k >= 0; --k) {
                String text = newlines.get(k).getText();
                comments.add(text);
                added = true;
            }
        }
        if (added) {
            String last = comments.get(comments.size() - 1);
            if ("\n".equals(last)) {
                comments.remove(comments.size() - 1);
            } else if (last.startsWith("#!")) {
                this.moduleNode.setShebang(last);
                comments.remove(comments.size() - 1);
            }
        }
        return false;
    }

    private void saveTrailingComment(ASTNode node, ParserRuleContext ctx) {
        ParserRuleContext child = ctx;
        while (this.saveTrailingComment0(child, node)) {
            child = child.getParent();
        }
    }

    private boolean saveTrailingComment0(ParserRuleContext ctx, ASTNode node) {
        int i;
        ParserRuleContext parent = ctx.getParent();
        if (parent == null) {
            return false;
        }
        List siblings = parent.children;
        for (i = 0; i < siblings.size() && siblings.get(i) != ctx; ++i) {
        }
        if (i == siblings.size() - 1) {
            return true;
        }
        ParseTree next = (ParseTree)siblings.get(i + 1);
        if (next instanceof ScriptParser.SepContext) {
            ScriptParser.SepContext sep = (ScriptParser.SepContext)next;
            String text = ((ParseTree)sep.children.get(0)).getText();
            if (!";".equals(text) && !"\n".equals(text)) {
                node.putNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMENT, (Object)text);
            }
        }
        return false;
    }

    private boolean isInsideParentheses(NodeMetaDataHandler nodeMetaDataHandler) {
        Number insideParenLevel = (Number)nodeMetaDataHandler.getNodeMetaData((Object)ASTNodeMarker.INSIDE_PARENTHESES_LEVEL);
        return insideParenLevel != null && insideParenLevel.intValue() > 0;
    }

    private CompilationFailedException createParsingFailedException(String msg, ParserRuleContext ctx) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, ctx.start.getLine(), ctx.start.getCharPositionInLine() + 1, ctx.stop.getLine(), ctx.stop.getCharPositionInLine() + 1 + ctx.stop.getText().length()));
    }

    private CompilationFailedException createParsingFailedException(String msg, Tuple2<Integer, Integer> start, Tuple2<Integer, Integer> end) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, ((Integer)start.getV1()).intValue(), ((Integer)start.getV2()).intValue(), ((Integer)end.getV1()).intValue(), ((Integer)end.getV2()).intValue()));
    }

    private CompilationFailedException createParsingFailedException(String msg, ASTNode node) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, node.getLineNumber(), node.getColumnNumber(), node.getLastLineNumber(), node.getLastColumnNumber()));
    }

    private CompilationFailedException createParsingFailedException(String msg, TerminalNode node) {
        return this.createParsingFailedException(msg, node.getSymbol());
    }

    private CompilationFailedException createParsingFailedException(String msg, org.antlr.v4.runtime.Token token) {
        return this.createParsingFailedException((Throwable)new SyntaxException(msg, token.getLine(), token.getCharPositionInLine() + 1, token.getLine(), token.getCharPositionInLine() + 1 + token.getText().length()));
    }

    private CompilationFailedException createParsingFailedException(Throwable t) {
        if (t instanceof SyntaxException) {
            SyntaxException se = (SyntaxException)t;
            this.collectSyntaxError(se);
        } else if (t instanceof GroovySyntaxError) {
            GroovySyntaxError gse = (GroovySyntaxError)t;
            this.collectSyntaxError(new SyntaxException(gse.getMessage(), (Throwable)gse, gse.getLine(), gse.getColumn()));
        } else if (t instanceof Exception) {
            Exception e = (Exception)t;
            this.collectException(e);
        }
        return new CompilationFailedException(CompilePhase.PARSING.getPhaseNumber(), (ProcessingUnit)this.sourceUnit, t);
    }

    private void collectSyntaxError(SyntaxException e) {
        this.sourceUnit.getErrorCollector().addFatalError((Message)new SyntaxErrorMessage(e, this.sourceUnit));
    }

    private void collectException(Exception e) {
        this.sourceUnit.getErrorCollector().addException(e, this.sourceUnit);
    }

    private void collectWarning(String message, String tokenText, ASTNode node) {
        Token token = new Token(0, tokenText, node.getLineNumber(), node.getColumnNumber());
        this.sourceUnit.getErrorCollector().addWarning(2, message, (CSTNode)token, this.sourceUnit);
    }

    private void removeErrorListeners() {
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
    }

    private void addErrorListeners() {
        this.lexer.addErrorListener(this.createANTLRErrorListener());
        this.parser.addErrorListener(this.createANTLRErrorListener());
    }

    private ANTLRErrorListener createANTLRErrorListener() {
        return new ANTLRErrorListener(){

            public void syntaxError(Recognizer recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
                ScriptAstBuilder.this.collectSyntaxError(new SyntaxException(msg, line, charPositionInLine + 1));
            }
        };
    }

    private static class GStringBuilder {
        private final List<ConstantExpression> strings = new ArrayList<ConstantExpression>();
        private final List<Expression> values = new ArrayList<Expression>();
        private boolean appendEmptyString = true;

        private GStringBuilder() {
        }

        public void appendString(ConstantExpression string) {
            this.strings.add(string);
            this.appendEmptyString = false;
        }

        public void appendValue(Expression value) {
            if (this.appendEmptyString) {
                this.appendString(GeneralUtils.constX((Object)""));
            }
            this.values.add(value);
            this.appendEmptyString = true;
        }

        public GStringExpression build(String verbatimText) {
            return new GStringExpression(verbatimText, this.strings, this.values);
        }
    }
}

