/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.parser;

import groovy.lang.groovydoc.Groovydoc;
import groovy.lang.groovydoc.GroovydocHolder;
import java.util.List;
import java.util.regex.Pattern;
import nextflow.script.parser.ScriptParser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.TerminalNode;
import org.apache.groovy.parser.antlr4.util.StringUtils;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

class GroovydocManager {
    private static final String GROOVYDOC_PREFIX = "/**";
    private static final Pattern SPACES_PATTERN = Pattern.compile("\\s+");
    private final boolean groovydocEnabled;

    public GroovydocManager(boolean groovydocEnabled) {
        this.groovydocEnabled = groovydocEnabled;
    }

    public void handle(ASTNode node, ParserRuleContext ctx) {
        if (!this.groovydocEnabled) {
            return;
        }
        if (!DefaultGroovyMethods.asBoolean((Object)node) || !DefaultGroovyMethods.asBoolean((Object)ctx)) {
            return;
        }
        if (!(node instanceof GroovydocHolder)) {
            return;
        }
        String docCommentNodeText = this.findDocCommentByNode(ctx);
        if (docCommentNodeText == null) {
            return;
        }
        node.putNodeMetaData((Object)"_DOC_COMMENT", (Object)new Groovydoc(docCommentNodeText, (GroovydocHolder)node));
    }

    private String findDocCommentByNode(ParserRuleContext ctx) {
        ParserRuleContext parent = ctx.getParent();
        if (!DefaultGroovyMethods.asBoolean((Object)parent)) {
            return null;
        }
        String docCommentNodeText = null;
        boolean sameTypeNodeBefore = false;
        block0: for (ParseTree child : parent.children) {
            List<? extends TerminalNode> newlines;
            if (child == ctx) {
                if (docCommentNodeText == null && !sameTypeNodeBefore) {
                    return this.findDocCommentByNode(parent);
                }
                return docCommentNodeText;
            }
            if (child.getClass() == ctx.getClass()) {
                docCommentNodeText = null;
                sameTypeNodeBefore = true;
                continue;
            }
            if (!(child instanceof ScriptParser.NlsContext) && !(child instanceof ScriptParser.SepContext)) continue;
            List<? extends TerminalNode> list = newlines = child instanceof ScriptParser.NlsContext ? ((ScriptParser.NlsContext)child).NL() : ((ScriptParser.SepContext)child).NL();
            if (newlines.isEmpty()) continue;
            for (int i = newlines.size() - 1; i >= 0; --i) {
                String text = newlines.get(i).getText();
                if (StringUtils.matches((String)text, (Pattern)SPACES_PATTERN)) continue;
                docCommentNodeText = text.startsWith(GROOVYDOC_PREFIX) ? text : null;
                continue block0;
            }
        }
        throw new GroovyBugError("Groovydoc context can not be found: " + ctx.getText());
    }
}

