/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.formatter;

import java.util.Comparator;
import java.util.List;
import nextflow.script.ast.ASTUtils;
import nextflow.script.ast.AssignmentExpression;
import nextflow.script.ast.FeatureFlagNode;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.IncludeModuleNode;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.OutputBlockNode;
import nextflow.script.ast.OutputNode;
import nextflow.script.ast.ParamNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.ScriptVisitorSupport;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.formatter.Formatter;
import nextflow.script.formatter.FormattingOptions;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;

public class ScriptFormattingVisitor
extends ScriptVisitorSupport {
    private SourceUnit sourceUnit;
    private FormattingOptions options;
    private Formatter fmt;
    private int maxIncludeWidth = 0;
    private int maxParamWidth = 0;

    public ScriptFormattingVisitor(SourceUnit sourceUnit, FormattingOptions options) {
        this.sourceUnit = sourceUnit;
        this.options = options;
        this.fmt = new Formatter(options);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        WorkflowNode entry;
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (!(moduleNode instanceof ScriptNode)) {
            return;
        }
        ScriptNode scriptNode = (ScriptNode)moduleNode;
        if (scriptNode.getShebang() != null) {
            this.fmt.append(scriptNode.getShebang());
        }
        if ((entry = scriptNode.getEntry()) != null && entry.isCodeSnippet()) {
            this.fmt.visit(entry.main);
            return;
        }
        List<ASTNode> declarations = scriptNode.getDeclarations();
        if (!this.options.sortDeclarations()) {
            declarations.sort(Comparator.comparing(node -> node.getLineNumber()));
        }
        if (this.options.harshilAlignment()) {
            this.maxIncludeWidth = scriptNode.getIncludes().stream().flatMap(in -> in.modules.stream()).map(this::getIncludeWidth).max(Integer::compare).orElse(0);
            this.maxParamWidth = scriptNode.getParams().stream().map(this::getParamWidth).max(Integer::compare).orElse(0);
        }
        for (ASTNode decl : declarations) {
            ClassNode cn;
            if (decl instanceof ClassNode && (cn = (ClassNode)decl).isEnum()) {
                this.visitEnum(cn);
                continue;
            }
            if (decl instanceof FeatureFlagNode) {
                FeatureFlagNode ffn = (FeatureFlagNode)decl;
                this.visitFeatureFlag(ffn);
                continue;
            }
            if (decl instanceof FunctionNode) {
                FunctionNode fn = (FunctionNode)decl;
                this.visitFunction(fn);
                continue;
            }
            if (decl instanceof IncludeNode) {
                IncludeNode in2 = (IncludeNode)decl;
                this.visitInclude(in2);
                continue;
            }
            if (decl instanceof OutputBlockNode) {
                OutputBlockNode obn = (OutputBlockNode)decl;
                this.visitOutputs(obn);
                continue;
            }
            if (decl instanceof ParamNode) {
                ParamNode pn = (ParamNode)decl;
                this.visitParam(pn);
                continue;
            }
            if (decl instanceof ProcessNode) {
                ProcessNode pn = (ProcessNode)decl;
                this.visitProcess(pn);
                continue;
            }
            if (!(decl instanceof WorkflowNode)) continue;
            WorkflowNode wn = (WorkflowNode)decl;
            this.visitWorkflow(wn);
        }
    }

    public String toString() {
        return this.fmt.toString();
    }

    @Override
    public void visitFeatureFlag(FeatureFlagNode node) {
        this.fmt.appendLeadingComments(node);
        this.fmt.append(node.name);
        this.fmt.append(" = ");
        this.fmt.visit(node.value);
        this.fmt.appendNewLine();
    }

    @Override
    public void visitInclude(IncludeNode node) {
        boolean wrap = node.getLineNumber() < node.getLastLineNumber();
        this.fmt.appendLeadingComments(node);
        this.fmt.append("include {");
        if (wrap) {
            this.fmt.incIndent();
        }
        for (int i = 0; i < node.modules.size(); ++i) {
            if (wrap) {
                this.fmt.appendNewLine();
                this.fmt.appendIndent();
            } else {
                this.fmt.append(' ');
            }
            IncludeModuleNode module = node.modules.get(i);
            this.fmt.append(module.name);
            if (module.alias != null) {
                this.fmt.append(" as ");
                this.fmt.append(module.alias);
            }
            if (!wrap && node.modules.size() == 1 && this.options.harshilAlignment()) {
                int padding = this.maxIncludeWidth - this.getIncludeWidth(module);
                this.fmt.append(" ".repeat(padding));
            }
            if (i + 1 >= node.modules.size()) continue;
            this.fmt.append(" ;");
        }
        if (wrap) {
            this.fmt.appendNewLine();
            this.fmt.decIndent();
        } else {
            this.fmt.append(' ');
        }
        this.fmt.append("} from ");
        this.fmt.visit((Expression)node.source);
        this.fmt.appendNewLine();
    }

    protected int getIncludeWidth(IncludeModuleNode module) {
        return module.alias != null ? module.name.length() + 4 + module.alias.length() : module.name.length();
    }

    @Override
    public void visitParam(ParamNode node) {
        this.fmt.appendLeadingComments(node);
        this.fmt.appendIndent();
        this.fmt.visit(node.target);
        if (this.maxParamWidth > 0) {
            int padding = this.maxParamWidth - this.getParamWidth(node);
            this.fmt.append(" ".repeat(padding));
        }
        this.fmt.append(" = ");
        this.fmt.visit(node.value);
        this.fmt.appendNewLine();
    }

    protected int getParamWidth(ParamNode node) {
        PropertyExpression target = (PropertyExpression)node.target;
        String name = target.getPropertyAsString();
        return name != null ? name.length() : 0;
    }

    @Override
    public void visitWorkflow(WorkflowNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.append("workflow");
        if (!node.isEntry()) {
            this.fmt.append(' ');
            this.fmt.append(node.getName());
        }
        this.fmt.append(" {\n");
        this.fmt.incIndent();
        if (node.takes instanceof BlockStatement) {
            this.fmt.appendIndent();
            this.fmt.append("take:\n");
            this.visitWorkflowTakes(ASTUtils.asBlockStatements(node.takes));
            this.fmt.appendNewLine();
        }
        if (node.main instanceof BlockStatement) {
            if (node.takes instanceof BlockStatement || node.emits instanceof BlockStatement || node.publishers instanceof BlockStatement) {
                this.fmt.appendIndent();
                this.fmt.append("main:\n");
            }
            this.fmt.visit(node.main);
        }
        if (node.emits instanceof BlockStatement) {
            this.fmt.appendNewLine();
            this.fmt.appendIndent();
            this.fmt.append("emit:\n");
            this.visitWorkflowEmits(ASTUtils.asBlockStatements(node.emits));
        }
        if (node.publishers instanceof BlockStatement) {
            this.fmt.appendNewLine();
            this.fmt.appendIndent();
            this.fmt.append("publish:\n");
            this.fmt.visit(node.publishers);
        }
        this.fmt.decIndent();
        this.fmt.append("}\n");
    }

    protected void visitWorkflowTakes(List<Statement> takes) {
        int alignmentWidth = this.options.harshilAlignment() ? this.getMaxParameterWidth(takes) : 0;
        for (Statement stmt : takes) {
            VariableExpression ve = ASTUtils.asVarX(stmt);
            this.fmt.appendIndent();
            this.fmt.visit((Expression)ve);
            if (this.fmt.hasTrailingComment((ASTNode)stmt)) {
                if (alignmentWidth > 0) {
                    int padding = alignmentWidth - ve.getName().length();
                    this.fmt.append(" ".repeat(padding));
                }
                this.fmt.appendTrailingComment((ASTNode)stmt);
            }
            this.fmt.appendNewLine();
        }
    }

    protected void visitWorkflowEmits(List<Statement> emits) {
        int alignmentWidth = this.options.harshilAlignment() ? this.getMaxParameterWidth(emits) : 0;
        for (Statement stmt : emits) {
            ExpressionStatement stmtX = (ExpressionStatement)stmt;
            Expression emit = stmtX.getExpression();
            if (emit instanceof AssignmentExpression) {
                AssignmentExpression assign = (AssignmentExpression)emit;
                VariableExpression ve = (VariableExpression)assign.getLeftExpression();
                this.fmt.appendIndent();
                this.fmt.visit((Expression)ve);
                if (alignmentWidth > 0) {
                    int padding = alignmentWidth - ve.getName().length();
                    this.fmt.append(" ".repeat(padding));
                }
                this.fmt.append(" = ");
                this.fmt.visit(assign.getRightExpression());
                this.fmt.appendTrailingComment((ASTNode)stmt);
                this.fmt.appendNewLine();
                continue;
            }
            if (emit instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)emit;
                this.fmt.appendIndent();
                this.fmt.visit((Expression)ve);
                if (this.fmt.hasTrailingComment((ASTNode)stmt)) {
                    if (alignmentWidth > 0) {
                        int padding = alignmentWidth - ve.getName().length();
                        this.fmt.append(" ".repeat(padding));
                    }
                    this.fmt.appendTrailingComment((ASTNode)stmt);
                }
                this.fmt.appendNewLine();
                continue;
            }
            this.fmt.visit(stmt);
        }
    }

    protected int getMaxParameterWidth(List<Statement> statements) {
        if (statements.size() == 1) {
            return 0;
        }
        int maxWidth = 0;
        for (Statement stmt : statements) {
            ExpressionStatement stmtX = (ExpressionStatement)stmt;
            Expression emit = stmtX.getExpression();
            int width = 0;
            if (emit instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)emit;
                width = ve.getName().length();
            } else if (emit instanceof AssignmentExpression) {
                AssignmentExpression assign = (AssignmentExpression)emit;
                VariableExpression target = (VariableExpression)assign.getLeftExpression();
                width = target.getName().length();
            }
            if (maxWidth >= width) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    @Override
    public void visitProcess(ProcessNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.append("process ");
        this.fmt.append(node.getName());
        this.fmt.append(" {\n");
        this.fmt.incIndent();
        if (node.directives instanceof BlockStatement) {
            this.visitDirectives(node.directives);
            this.fmt.appendNewLine();
        }
        if (node.inputs instanceof BlockStatement) {
            this.fmt.appendIndent();
            this.fmt.append("input:\n");
            this.visitDirectives(node.inputs);
            this.fmt.appendNewLine();
        }
        if (!this.options.maheshForm() && node.outputs instanceof BlockStatement) {
            this.visitProcessOutputs(node.outputs);
            this.fmt.appendNewLine();
        }
        if (!(node.when instanceof EmptyExpression)) {
            this.fmt.appendIndent();
            this.fmt.append("when:\n");
            this.fmt.appendIndent();
            this.fmt.visit(node.when);
            this.fmt.append("\n\n");
        }
        this.fmt.appendIndent();
        this.fmt.append(node.type);
        this.fmt.append(":\n");
        this.fmt.visit(node.exec);
        if (!(node.stub instanceof EmptyStatement)) {
            this.fmt.appendNewLine();
            this.fmt.appendIndent();
            this.fmt.append("stub:\n");
            this.fmt.visit(node.stub);
        }
        if (this.options.maheshForm() && node.outputs instanceof BlockStatement) {
            this.fmt.appendNewLine();
            this.visitProcessOutputs(node.outputs);
        }
        this.fmt.decIndent();
        this.fmt.append("}\n");
    }

    private void visitProcessOutputs(Statement outputs) {
        this.fmt.appendIndent();
        this.fmt.append("output:\n");
        this.visitDirectives(outputs);
    }

    @Override
    public void visitFunction(FunctionNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.append("def ");
        if (Formatter.isLegacyType(node.getReturnType())) {
            this.fmt.visitTypeAnnotation(node.getReturnType());
            this.fmt.append(' ');
        }
        this.fmt.append(node.getName());
        this.fmt.append('(');
        this.fmt.visitParameters(node.getParameters());
        this.fmt.append(") {\n");
        this.fmt.incIndent();
        this.fmt.visit(node.getCode());
        this.fmt.decIndent();
        this.fmt.append("}\n");
    }

    @Override
    public void visitEnum(ClassNode node) {
        this.fmt.appendLeadingComments((ASTNode)node);
        this.fmt.append("enum ");
        this.fmt.append(node.getName());
        this.fmt.append(" {\n");
        this.fmt.incIndent();
        for (FieldNode fn : node.getFields()) {
            this.fmt.appendIndent();
            this.fmt.append(fn.getName());
            this.fmt.append(',');
            this.fmt.appendNewLine();
        }
        this.fmt.decIndent();
        this.fmt.append("}\n");
    }

    @Override
    public void visitOutputs(OutputBlockNode node) {
        this.fmt.appendLeadingComments(node);
        this.fmt.append("output {\n");
        this.fmt.incIndent();
        super.visitOutputs(node);
        this.fmt.decIndent();
        this.fmt.append("}\n");
    }

    @Override
    public void visitOutput(OutputNode node) {
        this.fmt.appendLeadingComments(node);
        this.fmt.appendIndent();
        this.fmt.append(node.name);
        this.fmt.append(" {\n");
        this.fmt.incIndent();
        this.visitOutputBody((BlockStatement)node.body);
        this.fmt.decIndent();
        this.fmt.appendIndent();
        this.fmt.append("}\n");
    }

    protected void visitOutputBody(BlockStatement block) {
        ASTUtils.asBlockStatements((Statement)block).forEach(stmt -> {
            BlockStatement code;
            MethodCallExpression call = ASTUtils.asMethodCallX(stmt);
            if (call == null) {
                return;
            }
            String name = call.getMethodAsString();
            if ("index".equals(name) && (code = ASTUtils.asDslBlock(call, 1)) != null) {
                this.fmt.appendLeadingComments((ASTNode)stmt);
                this.fmt.appendIndent();
                this.fmt.append(name);
                this.fmt.append(" {\n");
                this.fmt.incIndent();
                this.visitDirectives((Statement)code);
                this.fmt.decIndent();
                this.fmt.appendIndent();
                this.fmt.append("}\n");
                return;
            }
            this.fmt.appendLeadingComments((ASTNode)stmt);
            this.fmt.visitDirective(call);
        });
    }

    protected void visitDirectives(Statement statement) {
        ASTUtils.asBlockStatements(statement).forEach(stmt -> {
            MethodCallExpression call = ASTUtils.asMethodCallX(stmt);
            if (call == null) {
                return;
            }
            this.fmt.appendLeadingComments((ASTNode)stmt);
            this.fmt.visitDirective(call);
        });
    }
}

