/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.formatter;

import nextflow.script.formatter.Formatter;
import nextflow.script.formatter.FormattingOptions;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyClassVisitor;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;

public class GroovyFormatter
extends ClassCodeVisitorSupport {
    private SourceUnit sourceUnit;
    private boolean verbose;
    private Formatter fmt;

    public GroovyFormatter(SourceUnit sourceUnit, boolean verbose) {
        this.sourceUnit = sourceUnit;
        this.verbose = verbose;
        this.fmt = new Formatter(new FormattingOptions(2, true));
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public String format() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode == null) {
            return null;
        }
        if (this.verbose) {
            this.visitImports(moduleNode);
        }
        for (ClassNode cn : moduleNode.getClasses()) {
            this.visitClass(cn);
        }
        return this.fmt.toString();
    }

    public void visitImports(ModuleNode node) {
        for (ImportNode in : node.getImports()) {
            this.visitImport(in);
        }
        for (ImportNode isn : node.getStarImports()) {
            this.visitImport(isn);
        }
        for (ImportNode isn : node.getStaticImports().values()) {
            this.visitImport(isn);
        }
        for (ImportNode issn : node.getStaticStarImports().values()) {
            this.visitImport(issn);
        }
    }

    private void visitImport(ImportNode node) {
        this.fmt.append(node.getText());
        this.fmt.appendNewLine();
    }

    public void visitClass(ClassNode node) {
        this.fmt.appendNewLine();
        this.visitAnnotations((AnnotatedNode)node);
        this.fmt.appendIndent();
        this.fmt.append(node.isEnum() ? "enum" : "class");
        this.fmt.append(' ');
        this.fmt.append(node.getNameWithoutPackage());
        if (node.getSuperClass() != null) {
            this.fmt.append(" extends ");
            this.fmt.append(node.getSuperClass().getNameWithoutPackage());
        }
        this.fmt.append(" {\n");
        this.fmt.incIndent();
        node.visitContents((GroovyClassVisitor)this);
        this.fmt.decIndent();
        this.fmt.appendIndent();
        this.fmt.append("}\n");
    }

    public void visitAnnotations(AnnotatedNode node) {
        for (AnnotationNode an : node.getAnnotations()) {
            if (an.isBuiltIn()) continue;
            this.fmt.appendIndent();
            this.fmt.append(an.getText());
            this.fmt.appendNewLine();
        }
    }

    public void visitConstructor(ConstructorNode node) {
        this.fmt.appendNewLine();
        this.visitAnnotations((AnnotatedNode)node);
        this.fmt.appendIndent();
        this.fmt.append(node.getDeclaringClass().getNameWithoutPackage());
        this.fmt.append('(');
        this.fmt.visitParameters(node.getParameters());
        this.fmt.append(") {\n");
        this.fmt.incIndent();
        this.fmt.visit(node.getCode());
        this.fmt.decIndent();
        this.fmt.appendIndent();
        this.fmt.append("}\n");
    }

    public void visitMethod(MethodNode node) {
        this.fmt.appendNewLine();
        this.visitAnnotations((AnnotatedNode)node);
        this.fmt.appendIndent();
        if (ClassHelper.isObjectType((ClassNode)node.getReturnType())) {
            this.fmt.append("def ");
        } else {
            this.fmt.visitTypeAnnotation(node.getReturnType());
            this.fmt.append(' ');
        }
        this.fmt.append(node.getName());
        this.fmt.append('(');
        this.fmt.visitParameters(node.getParameters());
        this.fmt.append(") {\n");
        this.fmt.incIndent();
        this.fmt.visit(node.getCode());
        this.fmt.decIndent();
        this.fmt.appendIndent();
        this.fmt.append("}\n");
    }

    public void visitField(FieldNode node) {
        this.fmt.appendNewLine();
        this.visitAnnotations((AnnotatedNode)node);
        this.fmt.appendIndent();
        if (ClassHelper.isObjectType((ClassNode)node.getType())) {
            this.fmt.append("def ");
        } else {
            this.fmt.visitTypeAnnotation(node.getType());
            this.fmt.append(' ');
        }
        this.fmt.append(node.getName());
        if (node.hasInitialExpression()) {
            this.fmt.append(" = ");
            this.visit(node.getInitialExpression());
        }
        this.fmt.appendNewLine();
    }
}

