/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.formatter;

import java.util.List;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.ast.ASTUtils;
import nextflow.script.formatter.FormattingOptions;
import nextflow.script.types.Types;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.IfStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.ThrowStatement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class Formatter
extends CodeVisitorSupport {
    private FormattingOptions options;
    private StringBuilder builder = new StringBuilder();
    private int indentCount = 0;
    private Expression currentRootExpr;
    private boolean inWrappedMethodChain;
    private boolean inVariableDeclaration;
    private boolean inWrappedPipeChain;
    private static final String SLASH_STR = "/";
    private static final String TDQ_STR = "\"\"\"";
    private static final String TSQ_STR = "'''";
    private static final String SQ_STR = "'";
    private static final String DQ_STR = "\"";

    public Formatter(FormattingOptions options) {
        this.options = options;
    }

    public void append(char c) {
        this.builder.append(c);
    }

    public void append(String str) {
        this.builder.append(str);
    }

    public void appendIndent() {
        String str = this.options.insertSpaces() ? " ".repeat(this.options.tabSize() * this.indentCount) : "\t".repeat(this.indentCount);
        this.builder.append(str);
    }

    public void appendNewLine() {
        this.builder.append('\n');
    }

    public void appendLeadingComments(ASTNode node) {
        List comments = (List)node.getNodeMetaData((Object)ASTNodeMarker.LEADING_COMMENTS);
        if (comments == null || comments.isEmpty()) {
            return;
        }
        for (String line : DefaultGroovyMethods.asReversed((List)comments)) {
            if ("\n".equals(line)) {
                this.append(line);
                continue;
            }
            this.appendIndent();
            this.append(line.stripLeading());
        }
    }

    public boolean hasTrailingComment(ASTNode node) {
        String comment = (String)node.getNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMENT);
        return comment != null;
    }

    public void appendTrailingComment(ASTNode node) {
        String comment = (String)node.getNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMENT);
        if (comment != null) {
            this.append(' ');
            this.append(comment);
        }
    }

    public void incIndent() {
        ++this.indentCount;
    }

    public void decIndent() {
        --this.indentCount;
    }

    public String toString() {
        return this.builder.toString();
    }

    public void visitIfElse(IfStatement node) {
        this.visitIfElse(node, true);
    }

    protected void visitIfElse(IfStatement node, boolean preIndent) {
        this.appendLeadingComments((ASTNode)node);
        if (preIndent) {
            this.appendIndent();
        }
        this.append("if (");
        this.visit((Expression)node.getBooleanExpression());
        this.append(") {\n");
        this.incIndent();
        this.visit(node.getIfBlock());
        this.decIndent();
        this.appendIndent();
        this.append("}\n");
        Statement statement = node.getElseBlock();
        if (statement instanceof IfStatement) {
            IfStatement is = (IfStatement)statement;
            this.appendIndent();
            this.append("else ");
            this.visitIfElse(is, false);
        } else if (!(node.getElseBlock() instanceof EmptyStatement)) {
            this.appendIndent();
            this.append("else {\n");
            this.incIndent();
            this.visit(node.getElseBlock());
            this.decIndent();
            this.appendIndent();
            this.append("}\n");
        }
    }

    public void visitExpressionStatement(ExpressionStatement node) {
        Expression cre = this.currentRootExpr;
        this.currentRootExpr = node.getExpression();
        this.appendLeadingComments((ASTNode)node);
        this.appendIndent();
        this.visitStatementLabels(node);
        this.visit(node.getExpression());
        this.appendNewLine();
        this.currentRootExpr = cre;
    }

    private void visitStatementLabels(ExpressionStatement node) {
        if (node.getStatementLabels() == null) {
            return;
        }
        for (String label : DefaultGroovyMethods.asReversed((List)node.getStatementLabels())) {
            this.append(label);
            this.append(": ");
        }
    }

    public void visitReturnStatement(ReturnStatement node) {
        Expression cre = this.currentRootExpr;
        this.currentRootExpr = node.getExpression();
        this.appendLeadingComments((ASTNode)node);
        this.appendIndent();
        this.append("return ");
        this.visit(node.getExpression());
        this.appendNewLine();
        this.currentRootExpr = cre;
    }

    public void visitAssertStatement(AssertStatement node) {
        ConstantExpression ce;
        this.appendLeadingComments((ASTNode)node);
        this.appendIndent();
        this.append("assert ");
        this.visit((Expression)node.getBooleanExpression());
        Expression expression = node.getMessageExpression();
        if (!(expression instanceof ConstantExpression) || !(ce = (ConstantExpression)expression).isNullExpression()) {
            this.append(" : ");
            this.visit(node.getMessageExpression());
        }
        this.appendNewLine();
    }

    public void visitTryCatchFinally(TryCatchStatement node) {
        this.appendLeadingComments((ASTNode)node);
        this.appendIndent();
        this.append("try {\n");
        this.incIndent();
        this.visit(node.getTryStatement());
        this.decIndent();
        this.appendIndent();
        this.append("}\n");
        for (CatchStatement catchStatement : node.getCatchStatements()) {
            this.visit((Statement)catchStatement);
        }
    }

    public void visitThrowStatement(ThrowStatement node) {
        this.appendLeadingComments((ASTNode)node);
        this.appendIndent();
        this.append("throw ");
        this.visit(node.getExpression());
        this.appendNewLine();
    }

    public void visitCatchStatement(CatchStatement node) {
        this.appendLeadingComments((ASTNode)node);
        this.appendIndent();
        this.append("catch (");
        Parameter variable = node.getVariable();
        ClassNode type = variable.getType();
        if (!ClassHelper.isObjectType((ClassNode)type)) {
            this.append(type.getNameWithoutPackage());
            this.append(' ');
        }
        this.append(variable.getName());
        this.append(") {\n");
        this.incIndent();
        this.visit(node.getCode());
        this.decIndent();
        this.appendIndent();
        this.append("}\n");
    }

    public void visitMethodCallExpression(MethodCallExpression node) {
        List parenArgs;
        boolean beginWrappedMethodChain = this.shouldWrapMethodChain(node);
        if (beginWrappedMethodChain) {
            this.inWrappedMethodChain = true;
        }
        if (!node.isImplicitThis()) {
            Expression receiver = node.getObjectExpression();
            this.visit(receiver);
            if (this.inWrappedMethodChain) {
                this.incIndent();
                if (!(receiver instanceof ClassExpression)) {
                    this.appendNewLine();
                    this.appendIndent();
                }
            }
            if (node.isSpreadSafe()) {
                this.append('*');
            } else if (node.isSafe()) {
                this.append('?');
            }
            this.append('.');
        }
        this.visit(node.getMethod());
        boolean iwmc = this.inWrappedMethodChain;
        this.inWrappedMethodChain = false;
        List args = ASTUtils.asMethodCallArguments((MethodCall)node);
        boolean lastClosureArg = args.size() > 0 && args.get(args.size() - 1) instanceof ClosureExpression;
        List list = parenArgs = lastClosureArg ? DefaultGroovyMethods.init(args) : args;
        if (parenArgs.size() > 0 || !lastClosureArg) {
            boolean wrap = this.shouldWrapMethodCall(node);
            this.append('(');
            if (wrap) {
                this.incIndent();
            }
            this.visitArguments(parenArgs, wrap);
            if (wrap) {
                this.appendNewLine();
                this.decIndent();
                this.appendIndent();
            }
            this.append(')');
        }
        if (lastClosureArg) {
            this.append(' ');
            this.visit((Expression)args.get(args.size() - 1));
        }
        this.inWrappedMethodChain = iwmc;
        if (!node.isImplicitThis() && this.inWrappedMethodChain) {
            this.decIndent();
        }
        if (beginWrappedMethodChain) {
            this.inWrappedMethodChain = false;
        }
    }

    public void visitConstructorCallExpression(ConstructorCallExpression node) {
        this.append("new ");
        this.visitTypeAnnotation(node.getType());
        this.append('(');
        this.visitArguments(ASTUtils.asMethodCallArguments((MethodCall)node), false);
        this.append(')');
    }

    public void visitDirective(MethodCallExpression call) {
        this.appendIndent();
        this.append(call.getMethodAsString());
        List<Expression> arguments = ASTUtils.asMethodCallArguments((MethodCall)call);
        if (!arguments.isEmpty()) {
            this.append(' ');
            this.visitArguments(arguments, false);
        }
        this.appendNewLine();
    }

    public void visitArguments(List<Expression> args, boolean wrap) {
        boolean hasNamedArgs = args.size() > 0 && args.get(0) instanceof NamedArgumentListExpression;
        List positionalArgs = hasNamedArgs ? DefaultGroovyMethods.tail(args) : args;
        this.visitPositionalArgs(positionalArgs, wrap);
        if (hasNamedArgs) {
            if (positionalArgs.size() > 0) {
                this.append(wrap ? "," : ", ");
            }
            MapExpression mapX = (MapExpression)args.get(0);
            this.visitNamedArgs(mapX.getMapEntryExpressions(), wrap);
        }
    }

    public void visitBinaryExpression(BinaryExpression node) {
        if (node instanceof DeclarationExpression) {
            this.append("def ");
            this.inVariableDeclaration = true;
            this.visit(node.getLeftExpression());
            this.inVariableDeclaration = false;
            Expression source = node.getRightExpression();
            if (!(source instanceof EmptyExpression)) {
                this.append(" = ");
                Expression cre = this.currentRootExpr;
                this.currentRootExpr = source;
                this.visit(source);
                this.currentRootExpr = cre;
            }
            return;
        }
        if (node.getOperation().isA(30)) {
            this.visit(node.getLeftExpression());
            this.append('[');
            this.visit(node.getRightExpression());
            this.append(']');
            return;
        }
        boolean beginWrappedPipeChain = this.shouldWrapPipeExpression(node);
        if (beginWrappedPipeChain) {
            this.inWrappedPipeChain = true;
        }
        this.visit(node.getLeftExpression());
        if (this.inWrappedPipeChain) {
            this.appendNewLine();
            this.incIndent();
            this.appendIndent();
        } else {
            this.append(' ');
        }
        this.append(node.getOperation().getText());
        this.append(' ');
        boolean iwpc = this.inWrappedPipeChain;
        this.inWrappedPipeChain = false;
        if (node.getOperation().isA(1100)) {
            Expression source = node.getRightExpression();
            Expression cre = this.currentRootExpr;
            this.currentRootExpr = source;
            this.visit(source);
            this.currentRootExpr = cre;
        } else {
            this.visit(node.getRightExpression());
        }
        this.inWrappedPipeChain = iwpc;
        if (this.inWrappedPipeChain) {
            this.decIndent();
        }
        if (beginWrappedPipeChain) {
            this.inWrappedPipeChain = false;
        }
    }

    public void visitTernaryExpression(TernaryExpression node) {
        if (this.shouldWrapExpression((Expression)node)) {
            this.visit((Expression)node.getBooleanExpression());
            this.incIndent();
            this.appendNewLine();
            this.appendIndent();
            this.append("? ");
            this.visit(node.getTrueExpression());
            this.appendNewLine();
            this.appendIndent();
            this.append(": ");
            this.visit(node.getFalseExpression());
            this.decIndent();
        } else {
            this.visit((Expression)node.getBooleanExpression());
            this.append(" ? ");
            this.visit(node.getTrueExpression());
            this.append(" : ");
            this.visit(node.getFalseExpression());
        }
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression node) {
        this.visit(node.getTrueExpression());
        this.append(" ?: ");
        this.visit(node.getFalseExpression());
    }

    public void visitNotExpression(NotExpression node) {
        this.append('!');
        this.visit(node.getExpression());
    }

    /*
     * Enabled aggressive block sorting
     */
    public void visitClosureExpression(ClosureExpression node) {
        Object e;
        BlockStatement code;
        this.append('{');
        if (node.getParameters() != null && node.getParameters().length > 0) {
            this.append(' ');
            this.visitParameters(node.getParameters());
            this.append(" ->");
        }
        if ((code = (BlockStatement)node.getCode()).getStatements().size() == 0) {
            this.append(" }");
            return;
        }
        if (code.getStatements().size() == 1 && (e = code.getStatements().get(0)) instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)e;
            if (!this.shouldWrapExpression((Expression)node)) {
                this.append(' ');
                this.visitStatementLabels(es);
                this.visit(es.getExpression());
                this.append(" }");
                return;
            }
        }
        this.appendNewLine();
        this.incIndent();
        this.visit((Statement)code);
        this.decIndent();
        this.appendIndent();
        this.append('}');
    }

    public void visitParameters(Parameter[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter param = parameters[i];
            if (Formatter.isLegacyType(param.getType())) {
                this.visitTypeAnnotation(param.getType());
                this.append(' ');
            }
            this.append(param.getName());
            if (param.hasInitialExpression()) {
                this.append(" = ");
                this.visit(param.getInitialExpression());
            }
            if (i + 1 >= parameters.length) continue;
            this.append(", ");
        }
    }

    public void visitTupleExpression(TupleExpression node) {
        boolean wrap = this.shouldWrapExpression((Expression)node);
        this.append('(');
        if (wrap) {
            this.incIndent();
        }
        this.visitPositionalArgs(node.getExpressions(), wrap);
        if (wrap) {
            this.appendNewLine();
            this.decIndent();
            this.appendIndent();
        }
        this.append(')');
    }

    public void visitListExpression(ListExpression node) {
        boolean wrap = Formatter.hasTrailingComma((Expression)node) || this.shouldWrapExpression((Expression)node);
        this.append('[');
        if (wrap) {
            this.incIndent();
        }
        this.visitPositionalArgs(node.getExpressions(), wrap);
        if (wrap) {
            this.appendNewLine();
            this.decIndent();
            this.appendIndent();
        }
        this.append(']');
    }

    protected void visitPositionalArgs(List<Expression> args, boolean wrap) {
        String comma = wrap ? "," : ", ";
        boolean trailingComma = wrap && args.size() > 1;
        for (int i = 0; i < args.size(); ++i) {
            if (wrap) {
                this.appendNewLine();
                this.appendIndent();
            }
            this.visit(args.get(i));
            if (!trailingComma && i + 1 >= args.size()) continue;
            this.append(comma);
        }
    }

    public void visitMapExpression(MapExpression node) {
        if (node.getMapEntryExpressions().isEmpty()) {
            this.append("[:]");
            return;
        }
        boolean wrap = Formatter.hasTrailingComma((Expression)node) || this.shouldWrapExpression((Expression)node);
        this.append('[');
        if (wrap) {
            this.incIndent();
        }
        this.visitNamedArgs(node.getMapEntryExpressions(), wrap);
        if (wrap) {
            this.appendNewLine();
            this.decIndent();
            this.appendIndent();
        }
        this.append(']');
    }

    protected void visitNamedArgs(List<MapEntryExpression> args, boolean wrap) {
        String comma = wrap ? "," : ", ";
        boolean trailingComma = wrap && args.size() > 1;
        for (int i = 0; i < args.size(); ++i) {
            if (wrap) {
                this.appendNewLine();
                this.appendIndent();
            }
            this.visit((Expression)args.get(i));
            if (!trailingComma && i + 1 >= args.size()) continue;
            this.append(comma);
        }
    }

    public void visitMapEntryExpression(MapEntryExpression node) {
        this.visit(node.getKeyExpression());
        this.append(": ");
        this.visit(node.getValueExpression());
    }

    public void visitRangeExpression(RangeExpression node) {
        this.visit(node.getFrom());
        if (node.isExclusiveLeft()) {
            this.append('<');
        }
        this.append("..");
        if (node.isExclusiveRight()) {
            this.append('<');
        }
        this.visit(node.getTo());
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression node) {
        this.append('-');
        this.visit(node.getExpression());
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression node) {
        this.append('+');
        this.visit(node.getExpression());
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression node) {
        this.append('~');
        this.visit(node.getExpression());
    }

    public void visitCastExpression(CastExpression node) {
        this.visit(node.getExpression());
        this.append(" as ");
        this.visitTypeAnnotation(node.getType());
    }

    public void visitConstantExpression(ConstantExpression node) {
        String text = (String)node.getNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT);
        if (text != null) {
            this.append(text);
        } else {
            this.append(node.getText());
        }
    }

    public void visitClassExpression(ClassExpression node) {
        this.visitTypeAnnotation(node.getType());
    }

    public void visitTypeAnnotation(ClassNode type) {
        if (Formatter.isLegacyType(type)) {
            this.append((String)type.getNodeMetaData((Object)ASTNodeMarker.LEGACY_TYPE));
            return;
        }
        this.append(Types.getName(type));
    }

    public void visitVariableExpression(VariableExpression node) {
        if (this.inVariableDeclaration && Formatter.isLegacyType(node.getType())) {
            this.visitTypeAnnotation(node.getType());
            this.append(' ');
        }
        this.append(node.getText());
    }

    public void visitPropertyExpression(PropertyExpression node) {
        this.visit(node.getObjectExpression());
        if (node.isSpreadSafe()) {
            this.append('*');
        } else if (node.isSafe()) {
            this.append('?');
        }
        this.append('.');
        this.visit(node.getProperty());
    }

    public void visitGStringExpression(GStringExpression node) {
        String quoteChar = (String)node.getNodeMetaData((Object)ASTNodeMarker.QUOTE_CHAR, k -> DQ_STR);
        this.append(quoteChar);
        List ss = node.getStrings();
        List vs = node.getValues();
        for (int i = 0; i < ss.size(); ++i) {
            ConstantExpression string = (ConstantExpression)ss.get(i);
            if (string.getNodeMetaData((Object)ASTNodeMarker.VERBATIM_TEXT) != null) {
                this.visit((Expression)string);
            }
            if (i >= vs.size()) continue;
            this.append("${");
            this.visit((Expression)vs.get(i));
            this.append('}');
        }
        this.append(quoteChar);
    }

    public void visit(Expression node) {
        Number number = (Number)node.getNodeMetaData((Object)ASTNodeMarker.INSIDE_PARENTHESES_LEVEL);
        if (number != null && number.intValue() > 0) {
            this.append('(');
        }
        super.visit(node);
        if (number != null && number.intValue() > 0) {
            this.append(')');
        }
    }

    private static boolean hasTrailingComma(Expression node) {
        return node.getNodeMetaData((Object)ASTNodeMarker.TRAILING_COMMA) != null;
    }

    public static boolean isLegacyType(ClassNode cn) {
        return cn.getNodeMetaData((Object)ASTNodeMarker.LEGACY_TYPE) != null;
    }

    private boolean shouldWrapExpression(Expression node) {
        return node.getLineNumber() < node.getLastLineNumber();
    }

    private boolean shouldWrapMethodCall(MethodCallExpression node) {
        if (Formatter.hasTrailingComma(node.getArguments())) {
            return true;
        }
        Expression start = node.getMethod();
        Expression end = node.getArguments();
        return start.getLineNumber() < end.getLastLineNumber();
    }

    private boolean shouldWrapMethodChain(MethodCallExpression node) {
        MethodCallExpression mce;
        if (this.currentRootExpr != node) {
            return false;
        }
        if (!this.shouldWrapExpression((Expression)node)) {
            return false;
        }
        MethodCallExpression root = node;
        int depth = 0;
        while (root instanceof MethodCallExpression && !(mce = root).isImplicitThis()) {
            root = mce.getObjectExpression();
            ++depth;
        }
        return this.shouldWrapExpression((Expression)root) ? false : depth >= 2;
    }

    private boolean shouldWrapPipeExpression(BinaryExpression node) {
        return this.currentRootExpr == node && node.getOperation().isA(340) && this.shouldWrapExpression((Expression)node);
    }
}

