/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.dsl;

import groovy.lang.Closure;
import java.util.Map;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.dsl.DslScope;
import nextflow.script.dsl.Operator;
import nextflow.script.types.Channel;

public interface WorkflowDsl
extends DslScope {
    @Constant(value="channel")
    @Description(value="    Alias for `Channel`.\n")
    public Channel getChannel();

    @Operator
    @Description(value="    The `branch` operator forwards each value from a source channel to one of multiple output channels, based on a selection criteria.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#branch)\n")
    public Object branch(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `buffer` operator collects values from a source channel into subsets and emits each subset separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#buffer)\n")
    public Channel buffer(Channel var1, Closure var2, Closure var3);

    @Operator
    @Description(value="    The `collate` operator collects values from a source channel into groups of *N* values.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#collate)\n")
    public Channel collate(Channel var1, int var2, int var3, boolean var4);

    @Operator
    @Description(value="    The `collect` operator collects all values from a source channel into a list and emits it as a single value.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#collect)\n")
    public Channel collect(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `collectFile` operator collects the values from a source channel and saves them to one or more files, emitting the collected file(s).\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#collectfile)\n")
    public Channel collectFile(Channel var1, Map<String, ?> var2, Closure var3);

    @Operator
    @Description(value="    The `combine` operator produces the combinations (i.e. cross product, \u201cCartesian\u201d product) of two source channels, or a channel and a list (as the right operand), emitting each combination separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#combine)\n")
    public Channel combine(Channel var1, Map<String, ?> var2, Object var3);

    @Operator
    @Description(value="    The `concat` operator emits the values from two or more source channels into a single output channel. Each source channel is emitted in the order in which it was specified.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#concat)\n")
    public Channel concat(Channel var1, Channel ... var2);

    @Operator
    @Description(value="    The `count` operator computes the total number of values from a source channel and emits it.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#count)\n")
    public Channel count(Channel var1);

    @Operator
    @Description(value="    The `cross` operator emits every pairwise combination of two channels for which the pair has a matching key.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#cross)\n")
    public Channel cross(Channel var1, Channel var2, Closure var3);

    @Operator
    @Description(value="    The `distinct` operator forwards a source channel with consecutively repeated values removed, such that each emitted value is different from the preceding one.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#distinct)\n")
    public Channel distinct(Channel var1);

    @Operator
    @Description(value="    When the pipeline is executed with the `-dump-channels` command-line option, the `dump` operator prints each value in a source channel, otherwise it does nothing.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#dump)\n")
    public Channel dump(Channel var1, Map<String, ?> var2);

    @Operator
    @Description(value="    The `filter` operator emits the values from a source channel that satisfy a condition, discarding all other values. The filter condition can be a literal value, a regular expression, a type qualifier, or a boolean predicate.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#filter)\n")
    public Channel filter(Channel var1, Closure<Boolean> var2);

    @Operator
    @Description(value="    The `first` operator emits the first value from a source channel, or the first value that satisfies a condition. The condition can be a regular expression, a type qualifier (i.e. Java class), or a boolean predicate.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#first)\n")
    public Channel first(Channel var1, Object var2);

    @Operator
    @Description(value="    The `flatMap` operator applies a mapping function to each value from a source channel.\n\n    When the mapping function returns a list, each element in the list is emitted separately. When the mapping function returns a map, each key-value pair in the map is emitted separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#flatmap)\n")
    public Channel flatMap(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `flatten` operator flattens each value from a source channel that is a list or other collection, such that each element in each collection is emitted separately. Deeply nested collections are also flattened.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#flatten)\n")
    public Channel flatten(Channel var1);

    @Operator
    @Description(value="    The `groupTuple` operator collects tuples from a source channel into groups based on a grouping key. A new tuple is emitted for each distinct key.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#grouptuple)\n")
    public Channel groupTuple(Channel var1, Map<String, ?> var2);

    @Operator
    @Description(value="    The `ifEmpty` operator emits a source channel, or a default value if the source channel is empty.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#ifempty)\n")
    public Channel ifEmpty(Channel var1, Object var2);

    @Operator
    @Description(value="    The `join` operator emits the inner product of two source channels using a matching key.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#join)\n")
    public Channel join(Channel var1, Channel var2);

    @Operator
    @Description(value="    The `last` operator emits the last value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#last)\n")
    public Channel last(Channel var1);

    @Operator
    @Description(value="    The `map` operator applies a mapping function to each value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#map)\n")
    public Channel map(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `max` operator emits the item with the greatest value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#max)\n")
    public Channel max(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `merge` operator joins the values from two or more channels into a new channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#merge)\n")
    public Channel merge(Channel var1, Channel ... var2);

    @Operator
    @Description(value="    The `min` operator emits the item with the lowest value from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#min)\n")
    public Channel min(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `mix` operator emits the values from two or more source channels into a single output channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#mix)\n")
    public Channel mix(Channel var1, Channel ... var2);

    @Operator
    @Description(value="    The `multiMap` operator applies a set of mapping functions to a source channel, producing a separate output channel for each mapping function.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#multimap)\n")
    public Object multiMap(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `randomSample` operator emits a randomly-selected subset of values from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#randomsample)\n")
    public Channel randomSample(Channel var1, int var2, Long var3);

    @Operator
    @Description(value="    The `reduce` operator applies an accumulator function sequentially to each value from a source channel, and emits the accumulated value. The accumulator function takes two parameters -- the accumulated value and the *i*-th emitted value -- and it should return the accumulated result, which is passed to the next invocation with the *i+1*-th value. This process is repeated for each value in the source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#reduce)\n")
    public Channel reduce(Channel var1, Object var2, Closure var3);

    @Operator
    @Description(value="    The `set` operator assigns a source channel to a variable, whose name is specified in a closure.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#set)\n")
    public void set(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `splitCsv` operator parses and splits [CSV-formatted](http://en.wikipedia.org/wiki/Comma-separated_values) text from a source channel into records, or groups of records with a given size.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splitcsv)\n")
    public Channel splitCsv(Channel var1, Map<String, ?> var2);

    @Operator
    @Description(value="    The `splitFasta` operator splits [FASTA formatted](http://en.wikipedia.org/wiki/FASTA_format) text from a source channel into individual sequences.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splitfasta)\n")
    public Channel splitFasta(Channel var1, Map<String, ?> var2);

    @Operator
    @Description(value="    The `splitFastq` operator splits [FASTQ formatted](http://en.wikipedia.org/wiki/FASTQ_format) text from a source channel into individual sequences.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splitfastq)\n")
    public Channel splitFastq(Channel var1, Map<String, ?> var2);

    @Operator
    @Description(value="    The `splitText` operator splits multi-line text content from a source channel into chunks of *N* lines.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#splittext)\n")
    public Channel splitText(Channel var1, Map<String, ?> var2, Closure var3);

    @Operator
    @Description(value="    The `subscribe` operator invokes a custom function for each value in a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#subscribe)\n")
    public void subscribe(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `sum` operator emits the sum of all values in a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#sum)\n")
    public Channel sum(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `take` operator takes the first *N* values from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#take)\n")
    public Channel take(Channel var1, int var2);

    @Operator
    @Description(value="    The `toList` operator collects all the values from a source channel into a list and emits the list as a single value.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#to;ist)\n")
    public Channel toList(Channel var1);

    @Operator
    @Description(value="    The `toSortedList` operator collects all the values from a source channel into a sorted list and emits the list as a single value.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#tosortedlist)\n")
    public Channel toSortedList(Channel var1);

    @Operator
    @Description(value="    The `transpose` operator transposes each tuple from a source channel by flattening any nested list in each tuple, emitting each nested value separately.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#transpose)\n")
    public Channel transpose(Channel var1, Map<String, ?> var2);

    @Operator
    @Description(value="    The `unique` operator emits the unique values from a source channel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#unique)\n")
    public Channel unique(Channel var1, Closure var2);

    @Operator
    @Description(value="    The `until` operator emits each value from a source channel until a stopping condition is satisfied.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#until)\n")
    public Channel until(Channel var1, Closure<Boolean> var2);

    @Operator
    @Description(value="    The `view` operator prints each value from a source channel to standard output.\n\n    [Read more](https://nextflow.io/docs/latest/reference/operator.html#view)\n")
    public Channel view(Channel var1, Closure var2);
}

