/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.dsl;

import groovy.lang.Closure;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.dsl.DslScope;
import nextflow.script.types.NextflowMetadata;
import nextflow.script.types.WorkflowMetadata;

public interface ScriptDsl
extends DslScope {
    @Deprecated
    @Constant(value="baseDir")
    @Description(value="    Alias of `workflow.projectDir`.\n")
    public Path getBaseDir();

    @Constant(value="launchDir")
    @Description(value="    Alias of `workflow.launchDir`.\n")
    public Path getLaunchDir();

    @Constant(value="log")
    @Description(value="    Logger which can be used to log messages to the console.\n")
    public Object getLog();

    @Constant(value="moduleDir")
    @Description(value="    The directory where a module script is located (equivalent to `projectDir` if used in the main script).\n")
    public Path getModuleDir();

    @Constant(value="nextflow")
    @Description(value="    Map of Nextflow runtime information.\n")
    public NextflowMetadata getNextflow();

    @Constant(value="projectDir")
    @Description(value="    Alias of `workflow.projectDir`.\n")
    public Path getProjectDir();

    @Constant(value="secrets")
    @Description(value="    Map of user-defined pipeline secrets.\n")
    public Map<String, ?> getSecrets();

    @Constant(value="workDir")
    @Description(value="    Alias of `workflow.workDir`.\n")
    public Path getWorkDir();

    @Constant(value="workflow")
    @Description(value="    Map of workflow runtime information.\n")
    public WorkflowMetadata getWorkflow();

    @Description(value="    Create a branch criteria to use with the `branch` operator.\n")
    public Object branchCriteria(Closure var1);

    @Description(value="    Get the value of an environment variable from the launch environment.\n")
    public String env(String var1);

    @Description(value="    Throw a script runtime error with an optional error message.\n")
    public void error(String var1);

    @Deprecated
    @Description(value="    Stop the pipeline execution and return an exit code and optional error message.\n")
    public void exit(int var1, String var2);

    @Description(value="    Get a file from a file name or glob pattern.\n\n    *NOTE: This function will return a collection if the glob pattern yields zero or multiple files. Use `files()` to get a collection of files.*\n")
    public Path file(Map<String, ?> var1, String var2);

    @Description(value="    Get a collection of files from a file name or glob pattern.\n")
    public Collection<Path> files(Map<String, ?> var1, String var2);

    @Description(value="    Create a grouping key to use with the [groupTuple](https://nextflow.io/docs/latest/operator.html#grouptuple) operator.\n")
    public Object groupKey(Object var1, int var2);

    @Description(value="    Create a multi-map criteria to use with the `multiMap` operator.\n")
    public Object multiMapCriteria(Closure var1);

    @Description(value="    Print a value to standard output.\n")
    public void print(Object var1);

    @Description(value="    Print a formatted string with the given values to standard output.\n")
    public void printf(String var1, Object ... var2);

    @Description(value="    Print a newline to standard output.\n")
    public void println();

    @Description(value="    Print a value to standard output with a newline.\n")
    public void println(Object var1);

    @Description(value="    Send an email.\n")
    public void sendMail(Map<String, ?> var1);

    @Description(value="    Sleep for the given number of milliseconds.\n")
    public void sleep(long var1);

    @Description(value="    Create a tuple from the given arguments.\n")
    public List<?> tuple(Object ... var1);
}

