/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.dsl;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.dsl.DslScope;
import nextflow.script.types.Duration;
import nextflow.script.types.MemoryUnit;
import nextflow.script.types.TaskConfig;

public interface ProcessDsl
extends DslScope {
    @Constant(value="task")
    @Description(value="    Map of task properties, including directive values.\n")
    public TaskConfig getTask();

    @Description(value="    Define a script template.\n")
    public Path template(String var1);

    public static interface OutputDsl
    extends DslScope {
        @Description(value="    Declare a value output. The argument can be any value, and it can reference any output variables defined in the process body (i.e. variables declared without the `def` keyword).\n")
        public void val(Object var1);

        @Deprecated
        @Description(value="    Declare a file output.\n")
        public void file(Object var1);

        @Description(value="    Declare a file output. It receives the output files from the task environment that match the given pattern.\n")
        public void path(Object var1);

        @Description(value="    Declare an environment variable output. It receives the value of the environment variable given by `identifier` from the task environment.\n")
        public void env(Object var1);

        @Description(value="    Declare a `stdout` output. It receives the standard output of the task script.\n")
        public void stdout();

        @Description(value="    Declare an `eval` output. It receives the standard output of the given command, which is executed in the task environment after the task script.\n")
        public void eval(Object var1);

        @Description(value="    Declare a tuple output. Each argument should be an output declaration such as `val`, `path`, `env`, `stdin`, or `eval`. Each tuple element is treated the same way as if it were a standalone output.\n")
        public void tuple(Object ... var1);
    }

    public static interface InputDsl
    extends DslScope {
        @Description(value="    Declare a variable input. The received value can be any type, and it will be made available to the process body (i.e. `script`, `shell`, `exec`) as a variable with the given name.\n")
        public void val(Object var1);

        @Deprecated
        @Description(value="    Declare a file input.\n")
        public void file(Object var1);

        @Description(value="    Declare a file input. The received value should be a file or collection of files.\n\n    The argument can be an identifier or string. If an identifier, the received value will be made available to the process body as a variable. If a string, the received value will be staged into the task directory under the given alias.\n")
        public void path(Object var1);

        @Description(value="    Declare an environment variable input. The received value should be a string, and it will be exported to the task environment as an environment variable given by `identifier`.\n")
        public void env(Object var1);

        @Description(value="    Declare a `stdin` input. The received value should be a string, and it will be provided as the standard input (i.e. `stdin`) to the task script. It should be declared only once for a process.\n")
        public void stdin();

        @Description(value="    Declare a tuple input. Each argument should be an input declaration such as `val`, `path`, `env`, or `stdin`.\n\n    The received value should be a tuple with the same number of elements as the `tuple` declaration, and each received element should be compatible with the corresponding `tuple` argument. Each tuple element is treated the same way as if it were a standalone input.\n")
        public void tuple(Object ... var1);

        @Description(value="    Declare an `each` input.\n")
        public void each(Object var1);
    }

    public static interface DirectiveDsl
    extends DslScope {
        @Description(value="    The `accelerator` directive allows you to request hardware accelerators (e.g. GPUs) for the task execution.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#accelerator)\n")
        public void accelerator(Map<String, ?> var1);

        @Description(value="    The `afterScript` directive allows you to execute a custom (Bash) snippet *after* the task script.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#afterscript)\n")
        public void afterScript(String var1);

        @Description(value="    The `arch` directive allows you to define the CPU architecture to build the software used by the task.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#arch)\n")
        public void arch(String var1);

        @Description(value="    The `array` directive allows you to submit tasks as *job arrays* for executors that support it.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#array)\n")
        public void array(Integer var1);

        @Description(value="    The `beforeScript` directive allows you to execute a custom (Bash) snippet *before* the task script.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#beforescript)\n")
        public void beforeScript(String var1);

        @Description(value="    The `cache` directive allows you to store the process results to a local cache. When the cache is enabled *and* the pipeline is launched with the `-resume` option, any task executions that are already cached will be re-used.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#cache)\n")
        public void cache(String var1);

        @Description(value="    The `clusterOptions` directive allows the usage of any native configuration option accepted by your cluster submit command. You can use it to request non-standard resources or use settings that are specific to your cluster and not supported out of the box by Nextflow.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#clusteroptions)\n")
        public void clusterOptions(String var1);

        @Description(value="    The `conda` directive allows for the definition of the process dependencies using the [Conda](https://conda.io) package manager.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#conda)\n")
        public void conda(String var1);

        @Description(value="    The `container` directive allows you to execute the process script in a container.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#container)\n")
        public void container(String var1);

        @Description(value="    The `containerOptions` directive allows you to specify any container execution option supported by the underlying container engine (ie. Docker, Singularity, etc). This can be useful to provide container settings only for a specific process.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#containeroptions)\n")
        public void containerOptions(String var1);

        @Description(value="    The `cpus` directive allows you to define the number of (logical) CPUs required by each task.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#cpus)\n")
        public void cpus(Integer var1);

        @Description(value="    The `debug` directive allows you to print the process standard output to Nextflow's standard output, i.e. the console. By default this directive is disabled.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#debug)\n")
        public void debug(boolean var1);

        @Description(value="    The `disk` directive allows you to define how much local disk storage the process is allowed to use.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#disk)\n")
        public void disk(MemoryUnit var1);

        @Description(value="    The `errorStrategy` directive allows you to define what to do when a task fails.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#errorstrategy)\n")
        public void errorStrategy(String var1);

        @Description(value="    The `executor` defines the underlying system where tasks are executed.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#executor)\n")
        public void executor(String var1);

        @Description(value="    The `ext` is a special directive used for custom settings by some executors.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#ext)\n")
        public void ext(Map<String, ?> var1);

        @Description(value="    The `fair` directive, when enabled, guarantees that process outputs will be emitted in the order in which they were received.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#fair)\n")
        public void fair(boolean var1);

        @Description(value="    The `label` directive allows you to annotate a process with a mnemonic identifier of your choice.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#label)\n")
        public void label(String var1);

        @Description(value="    The `machineType` directive can be used to specify a predefined Google Compute Platform [machine type](https://cloud.google.com/compute/docs/machine-types) when using the [Google Batch](https://nextflow.io/docs/latest/google.html#cloud-batch) executor.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#machinetype)\n")
        public void machineType(String var1);

        @Description(value="    The `maxErrors` directive allows you to specify the maximum number of times a process can fail when using the `retry` or `ignore` error strategy. By default this directive is disabled.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxerrors)\n")
        public void maxErrors(int var1);

        @Description(value="    The `maxForks` directive allows you to define the maximum number of tasks (per process) that can be executed in parallel.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxforks)\n")
        public void maxForks(Integer var1);

        @Description(value="    The `maxRetries` directive allows you to define the maximum number of times a task can be retried when using the `retry` error strategy. By default only one retry is allowed.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxretries)\n")
        public void maxRetries(int var1);

        @Description(value="    The `maxSubmitAwait` directives allows you to specify how long a task can remain in the submission queue. If a task remains in the queue beyond this time limit, it will fail.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#maxsubmitawait)\n")
        public void maxSubmitAwait(Duration var1);

        @Description(value="    The `memory` directive allows you to define how much memory is required by each task. Can be a string (e.g. `'8 GB'`) or a memory unit (e.g. `8.GB`).\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#memory)\n")
        public void memory(MemoryUnit var1);

        @Description(value="    The `module` directive allows you to provide software dependencies to a process using [Environment Modules](http://modules.sourceforge.net/).\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#module)\n")
        public void module(String var1);

        @Description(value="    The `penv` directive allows you to define the parallel environment to be used when submitting a parallel task to the [SGE](https://nextflow.io/docs/latest/executor.html#sge) resource manager.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#penv)\n")
        public void penv(String var1);

        @Description(value="    The `pod` directive allows you to define pod specific settings, such as environment variables, secrets, and config maps, when using the [Kubernetes](https://nextflow.io/docs/latest/kubernetes.html) executor.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#pod)\n")
        public void pod(List<?> var1);

        @Description(value="    The `publishDir` directive allows you to publish the process output files to a directory.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#publishdir)\n")
        public void publishDir(List<?> var1);

        @Description(value="    The `queue` directive allows you to specify the queue to which jobs are submitted when using a grid executor.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#queue)\n")
        public void queue(String var1);

        @Description(value="    The `resourceLabels` directive allows you to specify custom name-value pairs which are applied to the compute resources used for the process execution.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#resourcelabels)\n")
        public void resourceLabels(Map<String, ?> var1);

        @Description(value="    The `resourceLimits` directive allows you to specify environment-specific limits for task resource requests.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#resourcelimits)\n")
        public void resourceLimits(Map<String, ?> var1);

        @Description(value="    The `scratch` directive allows you to execute each task in a temporary directory that is local to the compute node.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#scratch)\n")
        public void scratch(String var1);

        @Description(value="    The `secret` directive allows you to securely provide secrets to a process.\n\n    [Read more](https://nextflow.io/docs/latest/secrets.html#process-directive)\n")
        public void secret(String var1);

        @Description(value="    The `shell` directive allows you to define a custom shell command for process scripts. By default, script blocks are executed with `/bin/bash -ue`.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#shell)\n")
        public void shell(String var1);

        @Description(value="    The `spack` directive allows you to provide software dependencies using the [Spack](https://spack.io) package manager.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#spack)\n")
        public void spack(String var1);

        @Description(value="    The `stageInMode` directive defines how input files are staged into the task work directory.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#stageinmode)\n")
        public void stageInMode(String var1);

        @Description(value="    The `stageOutMode` directive defines how output files are staged out from the scratch directory to the task work directory when using the `scratch` directive.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#stageoutmode)\n")
        public void stageOutMode(String var1);

        @Description(value="    The `storeDir` directive allows you to use an external directory as a *permanent* cache for process outputs.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#storedir)\n")
        public void storeDir(String var1);

        @Description(value="    The `tag` directive allows you to associate each process execution with a custom label, so that it will be easier to identify in the log file or in a report.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#tag)\n")
        public void tag(String var1);

        @Description(value="    The `time` directive allows you to define how long a task is allowed to run.\n\n    [Read more](https://nextflow.io/docs/latest/reference/process.html#time)\n")
        public void time(Duration var1);
    }
}

