/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.dsl;

import groovy.lang.Closure;
import java.util.List;
import java.util.Map;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Description;
import nextflow.script.dsl.DslScope;

public interface OutputDsl
extends DslScope {
    @Constant(value="args")
    @Description(value="    List of positional arguments specified on the command line.\n")
    public List<String> getArgs();

    @Constant(value="params")
    @Description(value="    Map of workflow parameters specified in the config file or as command line options.\n")
    public Map<String, Object> getParams();

    @Description(value="    *Currently only supported for S3.*\n\n    Specify the media type a.k.a. [MIME type](https://developer.mozilla.org/en-US/docs/Web/HTTP/Basics_of_HTTP/MIME_Types) of published files (default: `false`). Can be a string (e.g. `'text/html'`), or `true` to infer the content type from the file extension.\n")
    public void contentType(Object var1);

    @Description(value="    Enable or disable publishing (default: `true`).\n")
    public void enabled(boolean var1);

    @Description(value="    When `true`, the workflow will not fail if a file can't be published for some reason (default: `false`).\n")
    public void ignoreErrors(boolean var1);

    @Description(value="    Create an index file of the values that were published.\n")
    public void index(Closure var1);

    @Description(value="    Specify a label to be applied to every published file. Can be specified multiple times.\n")
    public void label(String var1);

    @Description(value="    The file publishing method (default: `'symlink'`).\n")
    public void mode(String var1);

    @Description(value="    When `true` any existing file in the specified folder will be overwritten (default: `'standard'`).\n")
    public void overwrite(Object var1);

    @Description(value="    Specify the publish path relative to the output directory (default: the target name).\n")
    public void path(String var1);

    @Description(value="    *Currently only supported for S3.*\n\n    Specify the storage class for published files.\n")
    public void storageClass(String var1);

    @Description(value="    *Currently only supported for S3.*\n\n    Specify arbitrary tags for published files.\n")
    public void tags(Map<String, String> var1);

    public static interface IndexDsl
    extends DslScope {
        @Description(value="    When `true`, the keys of the first record are used as the column names (default: `false`). Can also be a list of column names.\n")
        public void header(Object var1);

        @Description(value="    Closure which defines how to transform each published value into a CSV record. The closure should return a list or map. By default, no transformation is applied.\n")
        public void mapper(Closure var1);

        @Description(value="    The name of the index file relative to the target path (required).\n")
        public void path(String var1);

        @Description(value="    The character used to separate values (default: `','`).\n")
        public void sep(String var1);
    }
}

