/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.ast.ASTUtils;
import nextflow.script.ast.AssignmentExpression;
import nextflow.script.ast.FeatureFlagNode;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.IncludeModuleNode;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.OutputNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.ScriptVisitorSupport;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.control.VariableScopeChecker;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.EntryWorkflowDsl;
import nextflow.script.dsl.FeatureFlag;
import nextflow.script.dsl.FeatureFlagDsl;
import nextflow.script.dsl.OutputDsl;
import nextflow.script.dsl.ProcessDsl;
import nextflow.script.dsl.ScriptDsl;
import nextflow.script.dsl.WorkflowDsl;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

class VariableScopeVisitor
extends ScriptVisitorSupport {
    private SourceUnit sourceUnit;
    private VariableScopeChecker vsc;
    private MethodNode currentDefinition;
    private boolean inWorkflowEmit;
    private static final List<String> DECLARING_INPUT_TYPES = List.of("val", "file", "path");
    private static final List<String> EMIT_AND_TOPIC = List.of("emit", "topic");
    private static final List<String> KEYWORDS = List.of("case", "for", "switch", "while");
    private boolean inOperatorCall;
    private ClosureExpression currentClosure;
    private static final List<String> WARN_GLOBALS = List.of("baseDir", "launchDir", "projectDir", "workDir");

    public VariableScopeVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
        this.vsc = new VariableScopeChecker(sourceUnit, new ClassNode(ScriptDsl.class));
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void declare() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ScriptNode) {
            ScriptNode sn = (ScriptNode)moduleNode;
            for (IncludeNode includeNode : sn.getIncludes()) {
                this.declareInclude(includeNode);
            }
            for (WorkflowNode workflowNode : sn.getWorkflows()) {
                if (workflowNode.isEntry()) continue;
                this.declareMethod(workflowNode);
            }
            for (ProcessNode processNode : sn.getProcesses()) {
                this.declareMethod(processNode);
            }
            for (FunctionNode functionNode : sn.getFunctions()) {
                this.declareMethod(functionNode);
            }
        }
    }

    private void declareInclude(IncludeNode node) {
        for (IncludeModuleNode module : node.modules) {
            if (module.getTarget() == null) continue;
            String name = module.getNameOrAlias();
            MethodNode otherInclude = this.vsc.getInclude(name);
            if (otherInclude != null) {
                this.vsc.addError("`" + name + "` is already included", node, "First included here", (ASTNode)otherInclude);
            }
            this.vsc.include(name, module.getTarget());
        }
    }

    private void declareMethod(MethodNode mn) {
        List otherMethods;
        ClassNode cn = this.currentScope().getClassScope();
        String name = mn.getName();
        MethodNode otherInclude = this.vsc.getInclude(name);
        if (otherInclude != null) {
            this.vsc.addError("`" + name + "` is already included", (ASTNode)mn, "First included here", (ASTNode)otherInclude);
        }
        if ((otherMethods = cn.getDeclaredMethods(name)).size() > 0) {
            MethodNode other = (MethodNode)otherMethods.get(0);
            MethodNode first = mn.getLineNumber() < other.getLineNumber() ? mn : other;
            MethodNode second = mn.getLineNumber() < other.getLineNumber() ? other : mn;
            this.vsc.addError("`" + name + "` is already declared", (ASTNode)second, "First declared here", (ASTNode)first);
            return;
        }
        cn.addMethod(mn);
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ScriptNode) {
            ScriptNode sn = (ScriptNode)moduleNode;
            super.visit(sn);
            this.vsc.checkUnusedVariables();
        }
    }

    @Override
    public void visitFeatureFlag(FeatureFlagNode node) {
        ClassNode cn = ClassHelper.makeCached(FeatureFlagDsl.class);
        Optional<FieldNode> result = cn.getFields().stream().filter(fn -> ASTUtils.findAnnotation((AnnotatedNode)fn, FeatureFlag.class).map(an -> an.getMember("value").getText()).map(name -> name.equals(node.name)).orElse(false)).findFirst();
        if (result.isPresent()) {
            FieldNode ffn = result.get();
            if (ASTUtils.findAnnotation((AnnotatedNode)ffn, Deprecated.class).isPresent()) {
                this.vsc.addParanoidWarning("`" + node.name + "` is deprecated and will be removed in a future version", node.name, node);
            }
            node.target = ffn;
        } else {
            this.vsc.addError("Unrecognized feature flag '" + node.name + "'", node);
        }
    }

    @Override
    public void visitWorkflow(WorkflowNode node) {
        this.vsc.pushScope(node.isEntry() ? EntryWorkflowDsl.class : WorkflowDsl.class);
        this.currentDefinition = node;
        node.setVariableScope(this.currentScope());
        this.declareWorkflowInputs(node.takes);
        this.visit(node.main);
        Statement statement = node.main;
        if (statement instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)statement;
            this.copyVariableScope(block.getVariableScope());
        }
        this.visitWorkflowOutputs(node.emits, "emit");
        this.visitWorkflowOutputs(node.publishers, "output");
        this.currentDefinition = null;
        this.vsc.popScope();
    }

    private void declareWorkflowInputs(Statement takes) {
        for (Statement stmt : ASTUtils.asBlockStatements(takes)) {
            VariableExpression ve = ASTUtils.asVarX(stmt);
            if (ve == null) continue;
            this.vsc.declare(ve);
        }
    }

    private void copyVariableScope(VariableScope source) {
        Iterator it = source.getDeclaredVariablesIterator();
        while (it.hasNext()) {
            Variable variable = (Variable)it.next();
            this.currentScope().putDeclaredVariable(variable);
        }
    }

    private void visitWorkflowOutputs(Statement outputs, String typeLabel) {
        HashMap<String, VariableExpression> declaredOutputs = new HashMap<String, VariableExpression>();
        for (Statement stmt : ASTUtils.asBlockStatements(outputs)) {
            ExpressionStatement es = (ExpressionStatement)stmt;
            Expression output = es.getExpression();
            if (output instanceof AssignmentExpression) {
                AssignmentExpression assign = (AssignmentExpression)output;
                this.visit(assign.getRightExpression());
                VariableExpression target = (VariableExpression)assign.getLeftExpression();
                String name = target.getName();
                ASTNode other = (ASTNode)declaredOutputs.get(name);
                if (other != null) {
                    this.vsc.addError("Workflow " + typeLabel + " `" + name + "` is already declared", (ASTNode)target, "First declared here", other);
                    continue;
                }
                declaredOutputs.put(name, target);
                continue;
            }
            this.visit(output);
        }
    }

    @Override
    public void visitProcess(ProcessNode node) {
        this.vsc.pushScope(ProcessDsl.class);
        this.currentDefinition = node;
        node.setVariableScope(this.currentScope());
        this.declareProcessInputs(node.inputs);
        this.vsc.pushScope(ProcessDsl.InputDsl.class);
        this.visitDirectives(node.inputs, "process input qualifier", false);
        this.vsc.popScope();
        if (!(node.when instanceof EmptyExpression)) {
            this.vsc.addParanoidWarning("Process `when` section will not be supported in a future version", (ASTNode)node.when);
        }
        this.visit(node.when);
        this.visit(node.exec);
        this.visit(node.stub);
        this.vsc.pushScope(ProcessDsl.DirectiveDsl.class);
        this.visitDirectives(node.directives, "process directive", false);
        this.vsc.popScope();
        this.vsc.pushScope(ProcessDsl.OutputDsl.class);
        this.visitDirectives(node.outputs, "process output qualifier", false);
        this.vsc.popScope();
        this.currentDefinition = null;
        this.vsc.popScope();
    }

    private void declareProcessInputs(Statement inputs) {
        for (Statement stmt : ASTUtils.asBlockStatements(inputs)) {
            MethodCallExpression mce;
            MethodCallExpression call = ASTUtils.asMethodCallX(stmt);
            if (call == null) continue;
            if ("tuple".equals(call.getMethodAsString())) {
                for (Expression arg : ASTUtils.asMethodCallArguments((MethodCall)call)) {
                    if (!(arg instanceof MethodCallExpression)) continue;
                    mce = (MethodCallExpression)arg;
                    this.declareProcessInput(mce);
                }
                continue;
            }
            if ("each".equals(call.getMethodAsString())) {
                List<Expression> args = ASTUtils.asMethodCallArguments((MethodCall)call);
                if (args.size() != 1) continue;
                Expression firstArg = args.get(0);
                if (firstArg instanceof MethodCallExpression) {
                    mce = (MethodCallExpression)firstArg;
                    this.declareProcessInput(mce);
                    continue;
                }
                if (!(firstArg instanceof VariableExpression)) continue;
                VariableExpression ve = (VariableExpression)firstArg;
                this.vsc.declare(ve);
                continue;
            }
            this.declareProcessInput(call);
        }
    }

    private void declareProcessInput(MethodCallExpression call) {
        if (!DECLARING_INPUT_TYPES.contains(call.getMethodAsString())) {
            return;
        }
        List<Expression> args = ASTUtils.asMethodCallArguments((MethodCall)call);
        if (args.isEmpty()) {
            return;
        }
        Expression expression = args.get(args.size() - 1);
        if (expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            this.vsc.declare(ve);
        }
    }

    private void visitDirectives(Statement node, String typeLabel, boolean checkSyntaxErrors) {
        if (node instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)node;
            block.setVariableScope(this.currentScope());
        }
        for (Statement stmt : ASTUtils.asBlockStatements(node)) {
            MethodCallExpression call = this.checkDirective(stmt, typeLabel, checkSyntaxErrors);
            if (call == null) continue;
            super.visitMethodCallExpression(call);
        }
    }

    private MethodCallExpression checkDirective(Statement node, String typeLabel, boolean checkSyntaxErrors) {
        MethodCallExpression call = ASTUtils.asMethodCallX(node);
        if (call == null) {
            if (checkSyntaxErrors) {
                this.addSyntaxError("Invalid " + typeLabel, (ASTNode)node);
            }
            return null;
        }
        String name = call.getMethodAsString();
        MethodNode mn = this.vsc.findDslFunction(name, (ASTNode)call.getMethod());
        if (mn != null) {
            call.putNodeMetaData((Object)ASTNodeMarker.METHOD_TARGET, (Object)mn);
        } else {
            this.vsc.addError("Unrecognized " + typeLabel + " `" + name + "`", (ASTNode)node);
        }
        return call;
    }

    public void visitMapEntryExpression(MapEntryExpression node) {
        Expression key;
        ClassNode classScope = this.currentScope().getClassScope();
        if (classScope != null && classScope.getTypeClass() == ProcessDsl.OutputDsl.class && (key = node.getKeyExpression()) instanceof ConstantExpression && EMIT_AND_TOPIC.contains(key.getText())) {
            return;
        }
        super.visitMapEntryExpression(node);
    }

    @Override
    public void visitFunction(FunctionNode node) {
        this.vsc.pushScope();
        this.currentDefinition = node;
        node.setVariableScope(this.currentScope());
        for (Parameter parameter : node.getParameters()) {
            if (parameter.hasInitialExpression()) {
                this.visit(parameter.getInitialExpression());
            }
            this.vsc.declare((Variable)parameter, (ASTNode)node);
        }
        this.visit(node.getCode());
        this.currentDefinition = null;
        this.vsc.popScope();
    }

    @Override
    public void visitOutput(OutputNode node) {
        this.vsc.pushScope(OutputDsl.class);
        BlockStatement block = (BlockStatement)node.body;
        block.setVariableScope(this.currentScope());
        ASTUtils.asBlockStatements((Statement)block).forEach(stmt -> {
            BlockStatement code;
            MethodCallExpression call = this.checkDirective((Statement)stmt, "output directive", true);
            if (call == null) {
                return;
            }
            String name = call.getMethodAsString();
            if ("index".equals(name) && (code = ASTUtils.asDslBlock(call, 1)) != null) {
                this.vsc.pushScope(OutputDsl.IndexDsl.class);
                this.visitDirectives((Statement)code, "output index directive", true);
                this.vsc.popScope();
                return;
            }
            super.visitMethodCallExpression(call);
        });
        this.vsc.popScope();
    }

    public void visitBlockStatement(BlockStatement node) {
        boolean newScope;
        boolean bl = newScope = node.getVariableScope() != null;
        if (newScope) {
            this.vsc.pushScope();
        }
        node.setVariableScope(this.currentScope());
        super.visitBlockStatement(node);
        if (newScope) {
            this.vsc.popScope();
        }
    }

    public void visitCatchStatement(CatchStatement node) {
        this.vsc.pushScope();
        this.vsc.declare((Variable)node.getVariable(), (ASTNode)node);
        super.visitCatchStatement(node);
        this.vsc.popScope();
    }

    public void visitExpressionStatement(ExpressionStatement node) {
        Expression exp = node.getExpression();
        if (exp instanceof AssignmentExpression) {
            AssignmentExpression ae = (AssignmentExpression)exp;
            Expression source = ae.getRightExpression();
            Expression target = ae.getLeftExpression();
            this.visit(source);
            if (this.checkImplicitDeclaration(target)) {
                ae.putNodeMetaData((Object)ASTNodeMarker.IMPLICIT_DECLARATION, Boolean.TRUE);
            } else {
                this.visitMutatedVariable(target);
                this.visit(target);
            }
            return;
        }
        super.visitExpressionStatement(node);
    }

    private boolean checkImplicitDeclaration(Expression target) {
        if (target instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)target;
            boolean result = false;
            for (Expression el : te.getExpressions()) {
                result |= this.declareAssignedVariable((VariableExpression)el);
            }
            return result;
        }
        if (target instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)target;
            return this.declareAssignedVariable(ve);
        }
        return false;
    }

    private boolean declareAssignedVariable(VariableExpression ve) {
        Variable variable = this.vsc.findVariableDeclaration(ve.getName(), (ASTNode)ve);
        if (variable != null) {
            if (this.isDslVariable(variable)) {
                this.vsc.addError("Built-in variable cannot be re-assigned", (ASTNode)ve);
            }
            ve.setAccessedVariable(variable);
            return false;
        }
        if (this.currentDefinition instanceof ProcessNode || this.currentDefinition instanceof WorkflowNode) {
            if (this.currentClosure != null) {
                this.vsc.addError("Variables in a closure should be declared with `def`", (ASTNode)ve);
            }
            VariableScope scope = this.currentScope();
            this.currentScope(this.currentDefinition.getVariableScope());
            this.vsc.declare(ve);
            this.currentScope(scope);
            return true;
        }
        this.vsc.addError("`" + ve.getName() + "` was assigned but not declared", (ASTNode)ve);
        return true;
    }

    private boolean isDslVariable(Variable variable) {
        MethodNode mn = ASTUtils.asMethodVariable(variable);
        return mn != null && ASTUtils.findAnnotation((AnnotatedNode)mn, Constant.class).isPresent();
    }

    private void visitMutatedVariable(Expression node) {
        VariableExpression target = null;
        while (true) {
            BinaryExpression be;
            if (node instanceof PropertyExpression) {
                PropertyExpression pe = (PropertyExpression)node;
                node = pe.getObjectExpression();
                continue;
            }
            if (!(node instanceof BinaryExpression) || (be = (BinaryExpression)node).getOperation().getType() != 30) break;
            node = be.getLeftExpression();
        }
        if (node instanceof VariableExpression) {
            VariableExpression ve;
            target = ve = (VariableExpression)node;
        }
        if (target == null) {
            return;
        }
        Variable variable = this.vsc.findVariableDeclaration(target.getName(), (ASTNode)target);
        if (this.isDslVariable(variable)) {
            if ("params".equals(variable.getName())) {
                this.vsc.addWarning("Params should be declared at the top-level (i.e. outside the workflow)", target.getName(), (ASTNode)target);
            }
        } else if (variable != null) {
            this.checkExternalWriteInAsyncClosure(target, variable);
        }
    }

    private void checkExternalWriteInAsyncClosure(VariableExpression target, Variable variable) {
        if (!(this.currentDefinition instanceof WorkflowNode)) {
            return;
        }
        if (this.currentClosure == null) {
            return;
        }
        VariableScope scope = this.currentClosure.getVariableScope();
        String name = variable.getName();
        if (this.inOperatorCall && scope.isReferencedLocalVariable(name) && scope.getDeclaredVariable(name) == null) {
            this.vsc.addWarning("Mutating an external variable in an operator closure can lead to a race condition", target.getName(), (ASTNode)target);
        }
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression node) {
        VariableExpression target = this.checkSetAssignment(node);
        if (target != null) {
            this.visit(node.getObjectExpression());
            this.declareAssignedVariable(target);
            return;
        }
        this.checkMethodCall(node);
        boolean ioc = this.inOperatorCall;
        this.inOperatorCall = VariableScopeVisitor.isOperatorCall(node);
        super.visitMethodCallExpression(node);
        this.inOperatorCall = ioc;
    }

    private static boolean isOperatorCall(MethodCallExpression node) {
        MethodNode mn;
        Object object = node.getNodeMetaData((Object)ASTNodeMarker.METHOD_TARGET);
        return object instanceof MethodNode && VariableScopeChecker.isOperator(mn = (MethodNode)object);
    }

    private VariableExpression checkSetAssignment(MethodCallExpression node) {
        if (!(this.currentDefinition instanceof WorkflowNode)) {
            return null;
        }
        String name = node.getMethodAsString();
        if (!"set".equals(name) && !"tap".equals(name)) {
            return null;
        }
        BlockStatement code = ASTUtils.asDslBlock(node, 1);
        if (code == null || code.getStatements().size() != 1) {
            return null;
        }
        return ASTUtils.asVarX((Statement)code.getStatements().get(0));
    }

    private void checkMethodCall(MethodCallExpression node) {
        if (!node.isImplicitThis()) {
            return;
        }
        String name = node.getMethodAsString();
        MethodNode mn = this.vsc.findDslFunction(name, (ASTNode)node.getMethod());
        if (mn != null) {
            if (VariableScopeChecker.isDataflowMethod(mn)) {
                this.checkDataflowMethod(node, mn);
            }
            node.putNodeMetaData((Object)ASTNodeMarker.METHOD_TARGET, (Object)mn);
        } else if (!KEYWORDS.contains(name)) {
            this.vsc.addError("`" + name + "` is not defined", (ASTNode)node.getMethod());
        }
    }

    private void checkDataflowMethod(MethodCallExpression node, MethodNode mn) {
        if (!(this.currentDefinition instanceof WorkflowNode)) {
            String type = VariableScopeVisitor.dataflowMethodType(mn);
            this.vsc.addError(type + " can only be called from a workflow", (ASTNode)node);
            return;
        }
        if (this.currentClosure != null) {
            String type = VariableScopeVisitor.dataflowMethodType(mn);
            this.vsc.addError(type + " cannot be called from within a closure", (ASTNode)node);
            return;
        }
    }

    private static String dataflowMethodType(MethodNode mn) {
        if (mn instanceof ProcessNode) {
            return "Processes";
        }
        if (mn instanceof WorkflowNode) {
            return "Workflows";
        }
        return "Operators";
    }

    public void visitDeclarationExpression(DeclarationExpression node) {
        this.visit(node.getRightExpression());
        if (node.isMultipleAssignmentDeclaration()) {
            for (Expression el : node.getTupleExpression()) {
                this.vsc.declare((VariableExpression)el);
            }
        } else {
            this.vsc.declare(node.getVariableExpression());
        }
    }

    public void visitClosureExpression(ClosureExpression node) {
        ClosureExpression cl = this.currentClosure;
        this.currentClosure = node;
        this.vsc.pushScope();
        node.setVariableScope(this.currentScope());
        if (node.getParameters() != null) {
            for (Parameter parameter : node.getParameters()) {
                this.vsc.declare((Variable)parameter, (ASTNode)parameter);
                if (!parameter.hasInitialExpression()) continue;
                this.visit(parameter.getInitialExpression());
            }
        }
        super.visitClosureExpression(node);
        Iterator it = this.currentScope().getReferencedLocalVariablesIterator();
        while (it.hasNext()) {
            Variable variable = (Variable)it.next();
            variable.setClosureSharedVariable(true);
        }
        this.vsc.popScope();
        this.currentClosure = cl;
    }

    public void visitVariableExpression(VariableExpression node) {
        String name = node.getName();
        Variable variable = this.vsc.findVariableDeclaration(name, (ASTNode)node);
        if (variable == null) {
            if ("it".equals(name)) {
                this.vsc.addParanoidWarning("Implicit closure parameter `it` will not be supported in a future version", (ASTNode)node);
            } else if ("args".equals(name)) {
                this.vsc.addParanoidWarning("The use of `args` outside the entry workflow will not be supported in a future version", (ASTNode)node);
            } else if ("params".equals(name)) {
                this.vsc.addParanoidWarning("The use of `params` outside the entry workflow will not be supported in a future version", (ASTNode)node);
            } else {
                variable = new DynamicVariable(name, false);
            }
        }
        if (variable != null) {
            this.checkGlobalVariableInProcess(variable, (ASTNode)node);
            node.setAccessedVariable(variable);
        }
    }

    private void checkGlobalVariableInProcess(Variable variable, ASTNode context) {
        if (!(this.currentDefinition instanceof ProcessNode)) {
            return;
        }
        MethodNode mn = ASTUtils.asMethodVariable(variable);
        if (mn != null && mn.getDeclaringClass().getTypeClass() == ScriptDsl.class && WARN_GLOBALS.contains(variable.getName())) {
            this.vsc.addWarning("The use of `" + variable.getName() + "` in a process is discouraged -- input files should be provided as process inputs", variable.getName(), context);
        }
    }

    private VariableScope currentScope() {
        return this.vsc.getCurrentScope();
    }

    private void currentScope(VariableScope scope) {
        this.vsc.setCurrentScope(scope);
    }

    public void addSyntaxError(String message, ASTNode node) {
        SyntaxException cause = new SyntaxException(message, node);
        SyntaxErrorMessage errorMessage = new SyntaxErrorMessage(cause, this.sourceUnit);
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)errorMessage);
    }
}

