/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.ast.ASTUtils;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.control.ParanoidWarning;
import nextflow.script.control.PhaseAware;
import nextflow.script.control.RelatedInformationAware;
import nextflow.script.dsl.Constant;
import nextflow.script.dsl.Operator;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.control.messages.WarningMessage;
import org.codehaus.groovy.syntax.CSTNode;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;

public class VariableScopeChecker {
    private SourceUnit sourceUnit;
    private Map<String, MethodNode> includes = new HashMap<String, MethodNode>();
    private VariableScope currentScope;
    private Set<Variable> declaredVariables = Collections.newSetFromMap(new IdentityHashMap());

    public VariableScopeChecker(SourceUnit sourceUnit, ClassNode classScope) {
        this.sourceUnit = sourceUnit;
        this.currentScope = new VariableScope();
        this.currentScope.setClassScope(classScope);
    }

    public void setCurrentScope(VariableScope scope) {
        this.currentScope = scope;
    }

    public VariableScope getCurrentScope() {
        return this.currentScope;
    }

    public void include(String name, MethodNode variable) {
        this.includes.put(name, variable);
    }

    public MethodNode getInclude(String name) {
        return this.includes.get(name);
    }

    public void checkUnusedVariables() {
        for (Variable variable : this.declaredVariables) {
            if (!(variable instanceof ASTNode)) continue;
            ASTNode node = (ASTNode)variable;
            if (variable.getName().startsWith("_")) continue;
            String message = variable instanceof Parameter ? "Parameter was not used -- prefix with `_` to suppress warning" : "Variable was declared but not used";
            this.addWarning(message, variable.getName(), node);
        }
    }

    public void pushScope(Class classScope) {
        this.currentScope = new VariableScope(this.currentScope);
        if (classScope != null) {
            this.currentScope.setClassScope(ClassHelper.makeCached((Class)classScope));
        }
    }

    public void pushScope() {
        this.pushScope(null);
    }

    public void popScope() {
        this.currentScope = this.currentScope.getParent();
    }

    public void declare(VariableExpression variable) {
        this.declare((Variable)variable, (ASTNode)variable);
        variable.setAccessedVariable((Variable)variable);
    }

    public void declare(Variable variable, ASTNode context) {
        String name = variable.getName();
        for (VariableScope scope = this.currentScope; scope != null; scope = scope.getParent()) {
            Variable other = scope.getDeclaredVariable(name);
            if (other == null) continue;
            this.addError("`" + name + "` is already declared", context, "First declared here", (ASTNode)other);
            break;
        }
        this.currentScope.putDeclaredVariable(variable);
        this.declaredVariables.add(variable);
    }

    public Variable findVariableDeclaration(String name, ASTNode node) {
        VariableScope scope;
        Variable variable = null;
        boolean isClassVariable = false;
        for (scope = this.currentScope; scope != null && (variable = scope.getDeclaredVariable(name)) == null && (variable = scope.getReferencedLocalVariable(name)) == null; scope = scope.getParent()) {
            variable = scope.getReferencedClassVariable(name);
            if (variable != null) {
                isClassVariable = true;
                break;
            }
            variable = this.findDslVariable(scope.getClassScope(), name, node);
            if (variable == null) continue;
            isClassVariable = true;
            break;
        }
        if (variable == null) {
            return null;
        }
        VariableScope end = scope;
        scope = this.currentScope;
        while (true) {
            if (isClassVariable) {
                scope.putReferencedClassVariable(variable);
            } else {
                scope.putReferencedLocalVariable(variable);
            }
            if (scope == end) break;
            scope = scope.getParent();
        }
        this.declaredVariables.remove(variable);
        return variable;
    }

    private Variable findDslVariable(ClassNode cn, String name, ASTNode node) {
        while (cn != null) {
            for (MethodNode mn : cn.getMethods()) {
                if (VariableScopeChecker.isDataflowMethod(mn) && name.equals(mn.getName())) {
                    return VariableScopeChecker.wrapMethodAsVariable(mn, name);
                }
                Optional<AnnotationNode> an = ASTUtils.findAnnotation((AnnotatedNode)mn, Constant.class);
                if (!an.isPresent() || !name.equals(an.get().getMember("value").getText())) continue;
                if (ASTUtils.findAnnotation((AnnotatedNode)mn, Deprecated.class).isPresent()) {
                    this.addParanoidWarning("`" + name + "` is deprecated and will be removed in a future version", node);
                }
                return VariableScopeChecker.wrapMethodAsVariable(mn, name);
            }
            cn = cn.getInterfaces().length > 0 ? cn.getInterfaces()[0] : null;
        }
        if (this.includes.containsKey(name)) {
            return VariableScopeChecker.wrapMethodAsVariable(this.includes.get(name), name);
        }
        return null;
    }

    public static boolean isDataflowMethod(MethodNode mn) {
        return mn instanceof ProcessNode || mn instanceof WorkflowNode || VariableScopeChecker.isOperator(mn);
    }

    public static boolean isOperator(MethodNode mn) {
        return ASTUtils.findAnnotation((AnnotatedNode)mn, Operator.class).isPresent();
    }

    private static PropertyNode wrapMethodAsVariable(MethodNode mn, String name) {
        ClassNode cn = mn.getDeclaringClass();
        FieldNode fn = new FieldNode(name, mn.getModifiers() & 0xF, mn.getReturnType(), cn, null);
        fn.setHasNoRealSourcePosition(true);
        fn.setDeclaringClass(cn);
        fn.setSynthetic(true);
        PropertyNode pn = new PropertyNode(fn, fn.getModifiers(), null, null);
        pn.putNodeMetaData((Object)ASTNodeMarker.METHOD_VARIABLE_TARGET, (Object)mn);
        pn.setDeclaringClass(cn);
        return pn;
    }

    public MethodNode findDslFunction(String name, ASTNode node) {
        for (VariableScope scope = this.currentScope; scope != null; scope = scope.getParent()) {
            ClassNode cn = scope.getClassScope();
            while (cn != null) {
                for (MethodNode mn : cn.getMethods()) {
                    if (ASTUtils.findAnnotation((AnnotatedNode)mn, Constant.class).isPresent() || !name.equals(mn.getName())) continue;
                    if (ASTUtils.findAnnotation((AnnotatedNode)mn, Deprecated.class).isPresent()) {
                        this.addParanoidWarning("`" + name + "` is deprecated and will be removed in a future version", node);
                    }
                    return mn;
                }
                cn = cn.getInterfaces().length > 0 ? cn.getInterfaces()[0] : null;
            }
        }
        return this.includes.get(name);
    }

    public void addWarning(String message, String tokenText, ASTNode node) {
        Token token = new Token(0, tokenText, node.getLineNumber(), node.getColumnNumber());
        this.sourceUnit.getErrorCollector().addWarning(2, message, (CSTNode)token, this.sourceUnit);
    }

    public void addParanoidWarning(String message, String tokenText, ASTNode node, String otherMessage, ASTNode otherNode) {
        Token token = new Token(0, tokenText, node.getLineNumber(), node.getColumnNumber());
        ParanoidWarning warning = new ParanoidWarning(2, message, (CSTNode)token, this.sourceUnit);
        if (otherNode != null) {
            warning.setRelatedInformation(otherMessage, otherNode);
        }
        this.sourceUnit.getErrorCollector().addWarning((WarningMessage)warning);
    }

    public void addParanoidWarning(String message, ASTNode node, String otherMessage, ASTNode otherNode) {
        this.addParanoidWarning(message, "", node, otherMessage, otherNode);
    }

    public void addParanoidWarning(String message, String tokenText, ASTNode node) {
        this.addParanoidWarning(message, tokenText, node, null, null);
    }

    public void addParanoidWarning(String message, ASTNode node) {
        this.addParanoidWarning(message, "", node, null, null);
    }

    public void addError(String message, ASTNode node) {
        this.addError(new VariableScopeError(message, node));
    }

    public void addError(String message, ASTNode node, String otherMessage, ASTNode otherNode) {
        VariableScopeError cause = new VariableScopeError(message, node);
        if (otherNode != null) {
            cause.setRelatedInformation(otherMessage, otherNode);
        }
        this.addError(cause);
    }

    public void addError(SyntaxException cause) {
        SyntaxErrorMessage errorMessage = new SyntaxErrorMessage(cause, this.sourceUnit);
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)errorMessage);
    }

    private class VariableScopeError
    extends SyntaxException
    implements PhaseAware,
    RelatedInformationAware {
        private String otherMessage;
        private ASTNode otherNode;

        public VariableScopeError(String message, ASTNode node) {
            super(message, node);
        }

        public void setRelatedInformation(String otherMessage, ASTNode otherNode) {
            this.otherMessage = otherMessage;
            this.otherNode = otherNode;
        }

        @Override
        public int getPhase() {
            return 3;
        }

        @Override
        public String getOtherMessage() {
            return this.otherMessage;
        }

        @Override
        public ASTNode getOtherNode() {
            return this.otherNode;
        }
    }
}

