/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.ast.ASTUtils;
import nextflow.script.ast.AssignmentExpression;
import nextflow.script.ast.FeatureFlagNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.ScriptVisitorSupport;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.control.PhaseAware;
import nextflow.script.types.TypeChecker;
import nextflow.script.types.Types;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class TypeCheckingVisitor
extends ScriptVisitorSupport {
    private SourceUnit sourceUnit;
    private boolean experimental;

    public TypeCheckingVisitor(SourceUnit sourceUnit, boolean experimental) {
        this.sourceUnit = sourceUnit;
        this.experimental = experimental;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ScriptNode) {
            ScriptNode sn = (ScriptNode)moduleNode;
            this.visit(sn);
        }
    }

    @Override
    public void visitFeatureFlag(FeatureFlagNode node) {
        ClassNode actualType;
        if (!this.experimental) {
            return;
        }
        Variable fn = node.target;
        if (fn == null) {
            return;
        }
        ClassNode expectedType = fn.getType();
        if (!Types.isAssignableFrom(expectedType, actualType = node.value.getType())) {
            this.addError("Type mismatch for feature flag '" + node.name + "' -- expected a " + Types.getName(expectedType) + " but received a " + Types.getName(actualType), node);
        }
    }

    public void visitExpressionStatement(ExpressionStatement node) {
        AssignmentExpression ae;
        Expression exp = node.getExpression();
        if (exp instanceof AssignmentExpression && (ae = (AssignmentExpression)exp).getNodeMetaData((Object)ASTNodeMarker.IMPLICIT_DECLARATION) != null) {
            this.applyDeclaration(ae);
            return;
        }
        super.visitExpressionStatement(node);
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression node) {
        MethodNode defNode = (MethodNode)node.getNodeMetaData((Object)ASTNodeMarker.METHOD_TARGET);
        if (defNode instanceof ProcessNode || defNode instanceof WorkflowNode) {
            this.checkMethodCallArguments(node, defNode);
        }
        super.visitMethodCallExpression(node);
    }

    private void checkMethodCallArguments(MethodCallExpression node, MethodNode defNode) {
        int paramsCount;
        int argsCount = ASTUtils.asMethodCallArguments((MethodCall)node).size();
        if (argsCount != (paramsCount = defNode.getParameters().length)) {
            this.addError(String.format("Incorrect number of call arguments, expected %d but received %d", paramsCount, argsCount), (ASTNode)node);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression node) {
        this.applyDeclaration((BinaryExpression)node);
    }

    private void applyDeclaration(BinaryExpression node) {
        Expression target = node.getLeftExpression();
        Expression source = node.getRightExpression();
        if (source instanceof EmptyExpression) {
            return;
        }
        this.visit(target);
        this.visit(source);
        ClassNode sourceType = TypeChecker.getType((ASTNode)source);
        target.putNodeMetaData((Object)ASTNodeMarker.INFERRED_TYPE, (Object)sourceType);
    }

    public void visitPropertyExpression(PropertyExpression node) {
        super.visitPropertyExpression(node);
        if (TypeChecker.getType((ASTNode)node) == null) {
            MethodNode mn = TypeCheckingVisitor.asMethodNamedOutput(node);
            String property = node.getPropertyAsString();
            if (mn instanceof ProcessNode) {
                ProcessNode pn = (ProcessNode)mn;
                this.addError("Unrecognized output `" + property + "` for process `" + pn.getName() + "`", (ASTNode)node);
            } else if (mn instanceof WorkflowNode) {
                WorkflowNode wn = (WorkflowNode)mn;
                this.addError("Unrecognized output `" + property + "` for workflow `" + wn.getName() + "`", (ASTNode)node);
            }
        }
    }

    private static MethodNode asMethodNamedOutput(PropertyExpression node) {
        Expression expression = node.getObjectExpression();
        if (expression instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)expression;
            return ASTUtils.asMethodOutput(pe);
        }
        return null;
    }

    public void addError(String message, ASTNode node) {
        TypeError cause = new TypeError(message, node);
        SyntaxErrorMessage errorMessage = new SyntaxErrorMessage((SyntaxException)cause, this.sourceUnit);
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)errorMessage);
    }

    private class TypeError
    extends SyntaxException
    implements PhaseAware {
        public TypeError(String message, ASTNode node) {
            super(message, node);
        }

        @Override
        public int getPhase() {
            return 4;
        }
    }
}

