/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import nextflow.script.ast.ASTUtils;
import nextflow.script.ast.AssignmentExpression;
import nextflow.script.ast.FeatureFlagNode;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.OutputBlockNode;
import nextflow.script.ast.ParamNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.ScriptVisitorSupport;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.control.GStringToLazyVisitor;
import nextflow.script.control.TaskCmdXformVisitor;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.VariableScope;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.syntax.SyntaxException;

public class ScriptToGroovyVisitor
extends ScriptVisitorSupport {
    private static Set<String> RESERVED_NAMES = Set.of("main", "run", "runScript");
    private SourceUnit sourceUnit;
    private ScriptNode moduleNode;
    private static final List<String> EMIT_AND_TOPIC = List.of("emit", "topic");

    public ScriptToGroovyVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
        this.moduleNode = (ScriptNode)sourceUnit.getAST();
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        if (this.moduleNode == null) {
            return;
        }
        super.visit(this.moduleNode);
        if (this.moduleNode.isEmpty()) {
            this.moduleNode.addStatement((Statement)ReturnStatement.RETURN_NULL_OR_VOID);
        }
    }

    @Override
    public void visitFeatureFlag(FeatureFlagNode node) {
        Object[] names = node.name.split("\\.");
        VariableExpression target = GeneralUtils.varX((String)((String)DefaultGroovyMethods.head((Object[])names)));
        for (String name : (String[])DefaultGroovyMethods.tail((Object[])names)) {
            target = GeneralUtils.propX((Expression)target, (String)name);
        }
        Statement result = GeneralUtils.stmt((Expression)GeneralUtils.assignX((Expression)target, (Expression)node.value));
        this.moduleNode.addStatement(result);
    }

    @Override
    public void visitInclude(IncludeNode node) {
        List moduleArgs = node.modules.stream().map(module -> {
            ConstantExpression name = GeneralUtils.constX((Object)module.name);
            return module.alias != null ? ASTUtils.createX("nextflow.script.IncludeDef.Module", (TupleExpression)GeneralUtils.args((Expression[])new Expression[]{name, GeneralUtils.constX((Object)module.alias)})) : ASTUtils.createX("nextflow.script.IncludeDef.Module", (TupleExpression)GeneralUtils.args((Expression[])new Expression[]{name}));
        }).collect(Collectors.toList());
        MethodCallExpression include = GeneralUtils.callThisX((String)"include", (Expression)GeneralUtils.args((Expression[])new Expression[]{ASTUtils.createX("nextflow.script.IncludeDef", (TupleExpression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.listX(moduleArgs)}))}));
        MethodCallExpression from = GeneralUtils.callX((Expression)include, (String)"from", (Expression)GeneralUtils.args((Expression[])new Expression[]{node.source}));
        Statement result = GeneralUtils.stmt((Expression)GeneralUtils.callX((Expression)from, (String)"load0", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.varX((String)"params")})));
        this.moduleNode.addStatement(result);
    }

    @Override
    public void visitParam(ParamNode node) {
        Statement result = GeneralUtils.stmt((Expression)GeneralUtils.assignX((Expression)node.target, (Expression)node.value));
        this.moduleNode.addStatement(result);
    }

    @Override
    public void visitWorkflow(WorkflowNode node) {
        this.visitWorkflowTakes(node.takes);
        this.visit(node.main);
        this.visitWorkflowEmits(node.emits, node.main);
        this.visitWorkflowPublishers(node.publishers, node.main);
        Statement bodyDef = GeneralUtils.stmt((Expression)ASTUtils.createX("nextflow.script.BodyDef", (TupleExpression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.closureX((Statement)node.main), GeneralUtils.constX((Object)this.getSourceText(node)), GeneralUtils.constX((Object)"workflow")})));
        ClosureExpression closure = GeneralUtils.closureX((Statement)GeneralUtils.block((VariableScope)new VariableScope(), List.of(node.takes, node.emits, bodyDef)));
        ArgumentListExpression arguments = node.isEntry() ? GeneralUtils.args((Expression[])new Expression[]{closure}) : GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)node.getName()), closure});
        Statement result = GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"workflow", (Expression)arguments));
        this.moduleNode.addStatement(result);
    }

    private void visitWorkflowTakes(Statement takes) {
        for (Statement stmt : ASTUtils.asBlockStatements(takes)) {
            ExpressionStatement es = (ExpressionStatement)stmt;
            VariableExpression take = (VariableExpression)es.getExpression();
            es.setExpression((Expression)GeneralUtils.callThisX((String)"_take_", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)take.getName())})));
        }
    }

    private void visitWorkflowEmits(Statement emits, Statement main) {
        BlockStatement code = (BlockStatement)main;
        for (Statement stmt : ASTUtils.asBlockStatements(emits)) {
            VariableExpression target;
            ExpressionStatement es = (ExpressionStatement)stmt;
            Expression emit = es.getExpression();
            if (emit instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)emit;
                es.setExpression((Expression)GeneralUtils.callThisX((String)"_emit_", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)ve.getName())})));
                continue;
            }
            if (emit instanceof AssignmentExpression) {
                AssignmentExpression ae = (AssignmentExpression)emit;
                target = (VariableExpression)ae.getLeftExpression();
                es.setExpression((Expression)GeneralUtils.callThisX((String)"_emit_", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)target.getName())})));
                code.addStatement((Statement)es);
                continue;
            }
            target = GeneralUtils.varX((String)"$out");
            code.addStatement(GeneralUtils.assignS((Expression)target, (Expression)emit));
            es.setExpression((Expression)GeneralUtils.callThisX((String)"_emit_", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)target.getName())})));
            code.addStatement((Statement)es);
        }
    }

    private void visitWorkflowPublishers(Statement publishers, Statement main) {
        BlockStatement code = (BlockStatement)main;
        for (Statement stmt : ASTUtils.asBlockStatements(publishers)) {
            ExpressionStatement es = (ExpressionStatement)stmt;
            BinaryExpression publish = (BinaryExpression)es.getExpression();
            VariableExpression target = ASTUtils.asVarX(publish.getLeftExpression());
            es.setExpression((Expression)GeneralUtils.callThisX((String)"_publish_", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)target.getName()), publish.getRightExpression()})));
            code.addStatement((Statement)es);
        }
    }

    @Override
    public void visitProcess(ProcessNode node) {
        this.visitProcessDirectives(node.directives);
        this.visitProcessInputs(node.inputs);
        this.visitProcessOutputs(node.outputs);
        this.visit(node.exec);
        this.visit(node.stub);
        if ("script".equals(node.type)) {
            node.exec.visit((GroovyCodeVisitor)new TaskCmdXformVisitor(this.sourceUnit));
        }
        node.stub.visit((GroovyCodeVisitor)new TaskCmdXformVisitor(this.sourceUnit));
        Statement when = this.processWhen(node.when);
        Statement bodyDef = GeneralUtils.stmt((Expression)ASTUtils.createX("nextflow.script.BodyDef", (TupleExpression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.closureX((Statement)node.exec), GeneralUtils.constX((Object)this.getSourceText(node.exec)), GeneralUtils.constX((Object)node.type)})));
        Statement stub = this.processStub(node.stub);
        ClosureExpression closure = GeneralUtils.closureX((Statement)GeneralUtils.block((VariableScope)new VariableScope(), List.of(node.directives, node.inputs, node.outputs, when, stub, bodyDef)));
        Statement result = GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"process", (Expression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.constX((Object)node.getName()), closure})));
        this.moduleNode.addStatement(result);
    }

    private void visitProcessDirectives(Statement directives) {
        ASTUtils.asDirectives(directives).forEach(call -> this.fixLazyGString((Expression)call));
    }

    private void visitProcessInputs(Statement inputs) {
        ASTUtils.asDirectives(inputs).forEach(call -> {
            this.fixLazyGString((Expression)call);
            String name = call.getMethodAsString();
            this.varToConstX(call.getArguments(), "tuple".equals(name), "each".equals(name));
            call.setMethod((Expression)GeneralUtils.constX((Object)("_in_" + name)));
        });
    }

    private void visitProcessOutputs(Statement outputs) {
        ASTUtils.asDirectives(outputs).forEach(call -> {
            this.fixLazyGString((Expression)call);
            String name = call.getMethodAsString();
            this.varToConstX(call.getArguments(), "tuple".equals(name), "each".equals(name));
            call.setMethod((Expression)GeneralUtils.constX((Object)("_out_" + name)));
            this.visitProcessOutputEmitAndTopic((MethodCallExpression)call);
        });
    }

    private void visitProcessOutputEmitAndTopic(MethodCallExpression output) {
        List<MapEntryExpression> namedArgs = ASTUtils.asNamedArgs((MethodCall)output);
        for (int i = 0; i < namedArgs.size(); ++i) {
            MapEntryExpression entry = namedArgs.get(i);
            ConstantExpression key = ASTUtils.asConstX(entry.getKeyExpression());
            VariableExpression value = ASTUtils.asVarX(entry.getValueExpression());
            if (value == null || key == null || !EMIT_AND_TOPIC.contains(key.getText())) continue;
            namedArgs.set(i, GeneralUtils.entryX((Expression)key, (Expression)GeneralUtils.constX((Object)value.getText())));
        }
    }

    private void fixLazyGString(Expression node) {
        new GStringToLazyVisitor(this.sourceUnit).visit(node);
    }

    private Expression varToConstX(Expression node, boolean withinTuple, boolean withinEach) {
        if (node instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)node;
            List arguments = te.getExpressions();
            for (int i = 0; i < arguments.size(); ++i) {
                arguments.set(i, this.varToConstX((Expression)arguments.get(i), withinTuple, withinEach));
            }
            return te;
        }
        if (node instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)node;
            String name = ve.getName();
            if ("stdin".equals(name) && withinTuple) {
                return ASTUtils.createX("nextflow.script.TokenStdinCall", new Expression[0]);
            }
            if ("stdout".equals(name) && withinTuple) {
                return ASTUtils.createX("nextflow.script.TokenStdoutCall", new Expression[0]);
            }
            return ASTUtils.createX("nextflow.script.TokenVar", new Expression[]{GeneralUtils.constX((Object)name)});
        }
        if (node instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)node;
            String name = mce.getMethodAsString();
            Expression arguments = mce.getArguments();
            if ("env".equals(name) && withinTuple) {
                return ASTUtils.createX("nextflow.script.TokenEnvCall", (TupleExpression)this.varToStrX(arguments));
            }
            if ("eval".equals(name) && withinTuple) {
                return ASTUtils.createX("nextflow.script.TokenEvalCall", (TupleExpression)this.varToStrX(arguments));
            }
            if ("file".equals(name) && (withinTuple || withinEach)) {
                return ASTUtils.createX("nextflow.script.TokenFileCall", (TupleExpression)this.varToConstX(arguments, withinTuple, withinEach));
            }
            if ("path".equals(name) && (withinTuple || withinEach)) {
                return ASTUtils.createX("nextflow.script.TokenPathCall", (TupleExpression)this.varToConstX(arguments, withinTuple, withinEach));
            }
            if ("val".equals(name) && withinTuple) {
                return ASTUtils.createX("nextflow.script.TokenValCall", (TupleExpression)this.varToStrX(arguments));
            }
        }
        if (node instanceof PropertyExpression) {
            return this.wrapExpressionInClosure(node);
        }
        return node;
    }

    private Expression varToStrX(Expression node) {
        if (node instanceof TupleExpression) {
            TupleExpression te = (TupleExpression)node;
            List arguments = te.getExpressions();
            for (int i = 0; i < arguments.size(); ++i) {
                arguments.set(i, this.varToStrX((Expression)arguments.get(i)));
            }
            return te;
        }
        if (node instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)node;
            String name = ve.getName();
            return ASTUtils.createX("nextflow.script.TokenVar", new Expression[]{GeneralUtils.constX((Object)name)});
        }
        if (node instanceof PropertyExpression) {
            return this.wrapExpressionInClosure(node);
        }
        return node;
    }

    protected ClosureExpression wrapExpressionInClosure(Expression node) {
        return GeneralUtils.closureX((Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.stmt((Expression)node)}));
    }

    private Statement processWhen(Expression when) {
        if (when instanceof EmptyExpression) {
            return EmptyStatement.INSTANCE;
        }
        return GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"when", (Expression)ASTUtils.createX("nextflow.script.TaskClosure", (TupleExpression)GeneralUtils.args((Expression[])new Expression[]{this.wrapExpressionInClosure(when), GeneralUtils.constX((Object)this.getSourceText(when))}))));
    }

    private Statement processStub(Statement stub) {
        if (stub instanceof EmptyStatement) {
            return EmptyStatement.INSTANCE;
        }
        return GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"stub", (Expression)ASTUtils.createX("nextflow.script.TaskClosure", (TupleExpression)GeneralUtils.args((Expression[])new Expression[]{GeneralUtils.closureX((Statement)stub), GeneralUtils.constX((Object)this.getSourceText(stub))}))));
    }

    @Override
    public void visitFunction(FunctionNode node) {
        if (RESERVED_NAMES.contains(node.getName())) {
            this.syntaxError((ASTNode)node, "`${node.getName()}` is not allowed as a function name because it is reserved for internal use");
            return;
        }
        this.moduleNode.getScriptClassDummy().addMethod((MethodNode)node);
    }

    @Override
    public void visitOutputs(OutputBlockNode node) {
        List<Statement> statements = node.declarations.stream().map(output -> {
            new PublishDslVisitor().visit(output.body);
            ConstantExpression name = GeneralUtils.constX((Object)output.name);
            ClosureExpression body = GeneralUtils.closureX((Statement)output.body);
            return GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"declare", (Expression)GeneralUtils.args((Expression[])new Expression[]{name, body})));
        }).toList();
        ClosureExpression closure = GeneralUtils.closureX((Statement)GeneralUtils.block((VariableScope)new VariableScope(), statements));
        Statement result = GeneralUtils.stmt((Expression)GeneralUtils.callThisX((String)"output", (Expression)GeneralUtils.args((Expression[])new Expression[]{closure})));
        this.moduleNode.addStatement(result);
    }

    private String getSourceText(Statement node) {
        StringBuilder builder = new StringBuilder();
        int colx = node.getColumnNumber();
        int colz = node.getLastColumnNumber();
        int first = node.getLineNumber();
        int last = node.getLastLineNumber();
        for (int i = first; i <= last; ++i) {
            String line = this.sourceUnit.getSource().getLine(i, null);
            if (i == first) {
                int k;
                for (k = 0; k < line.length() && line.charAt(k) == ' '; ++k) {
                }
                builder.append(line.substring(0, k));
            }
            int begin = i == first ? colx - 1 : 0;
            int end = i == last ? colz - 1 : line.length();
            builder.append(line.substring(begin, end)).append('\n');
        }
        return builder.toString();
    }

    private String getSourceText(Expression node) {
        Statement stm = GeneralUtils.stmt((Expression)node);
        stm.setSourcePosition((ASTNode)node);
        return this.getSourceText(stm);
    }

    private String getSourceText(WorkflowNode node) {
        if (node.isEntry() && node.getLineNumber() == -1) {
            return this.getSourceText(node.main);
        }
        StringBuilder builder = new StringBuilder();
        int colx = node.getColumnNumber();
        int colz = node.getLastColumnNumber();
        int first = node.getLineNumber();
        int last = node.getLastLineNumber();
        for (int i = first; i <= last; ++i) {
            String line = this.sourceUnit.getSource().getLine(i, null);
            if (i == last && (line = line.substring(0, colz - 1).replaceFirst("}.*$", "")).trim().isEmpty() || i == first && (line = line.substring(colx - 1).replaceFirst("^.*\\{", "").trim()).isEmpty()) continue;
            builder.append(line).append('\n');
        }
        return builder.toString();
    }

    private void syntaxError(ASTNode node, String message) {
        this.sourceUnit.addError(new SyntaxException(message, node));
    }

    private class PublishDslVisitor
    extends CodeVisitorSupport {
        private boolean hasPublishStatements;
        private boolean hasNonPublishStatements;

        private PublishDslVisitor() {
        }

        public void visitMethodCallExpression(MethodCallExpression node) {
            if ("path".equals(node.getMethodAsString())) {
                this.visitPathDirective(node);
            }
        }

        private void visitPathDirective(MethodCallExpression node) {
            BlockStatement code = ASTUtils.asDslBlock(node, 1);
            if (code == null) {
                return;
            }
            for (Statement stmt : code.getStatements()) {
                if (this.visitPublishStatement(stmt)) {
                    this.hasPublishStatements = true;
                    continue;
                }
                this.hasNonPublishStatements = true;
            }
            if (this.hasPublishStatements && this.hasNonPublishStatements) {
                ScriptToGroovyVisitor.this.syntaxError((ASTNode)node, "Publish statements cannot be mixed with other statements in a dynamic publish path");
            }
        }

        private boolean visitPublishStatement(Statement node) {
            if (!(node instanceof ExpressionStatement)) {
                return false;
            }
            ExpressionStatement es = (ExpressionStatement)node;
            if (!(es.getExpression() instanceof BinaryExpression)) {
                return false;
            }
            BinaryExpression be = (BinaryExpression)es.getExpression();
            if (be.getOperation().getType() != 281) {
                return false;
            }
            Expression source = be.getLeftExpression();
            Expression target = be.getRightExpression();
            es.setExpression((Expression)GeneralUtils.callThisX((String)"publish", (Expression)GeneralUtils.args((Expression[])new Expression[]{source, target})));
            return true;
        }
    }
}

