/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import java.util.List;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.OutputNode;
import nextflow.script.ast.ParamNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.ScriptVisitorSupport;
import nextflow.script.ast.WorkflowNode;
import nextflow.script.control.ResolveVisitor;
import nextflow.script.control.VariableScopeVisitor;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class ScriptResolveVisitor
extends ScriptVisitorSupport {
    private SourceUnit sourceUnit;
    private ResolveVisitor resolver;

    public ScriptResolveVisitor(SourceUnit sourceUnit, CompilationUnit compilationUnit, List<ClassNode> defaultImports, List<ClassNode> libImports) {
        this.sourceUnit = sourceUnit;
        this.resolver = new ResolveVisitor(sourceUnit, compilationUnit, defaultImports, libImports);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ScriptNode) {
            ScriptNode sn = (ScriptNode)moduleNode;
            VariableScopeVisitor variableScopeVisitor = new VariableScopeVisitor(this.sourceUnit);
            variableScopeVisitor.declare();
            variableScopeVisitor.visit();
            for (ParamNode paramNode : sn.getParams()) {
                this.visitParam(paramNode);
            }
            for (WorkflowNode workflowNode : sn.getWorkflows()) {
                this.visitWorkflow(workflowNode);
            }
            for (ProcessNode processNode : sn.getProcesses()) {
                this.visitProcess(processNode);
            }
            for (FunctionNode functionNode : sn.getFunctions()) {
                this.visitFunction(functionNode);
            }
            if (sn.getOutputs() != null) {
                this.visitOutputs(sn.getOutputs());
            }
            new DynamicVariablesVisitor().visit(sn);
        }
    }

    @Override
    public void visitParam(ParamNode node) {
        node.value = this.resolver.transform(node.value);
    }

    @Override
    public void visitWorkflow(WorkflowNode node) {
        this.resolver.visit(node.main);
        this.resolver.visit(node.emits);
        this.resolver.visit(node.publishers);
    }

    @Override
    public void visitProcess(ProcessNode node) {
        this.resolver.visit(node.directives);
        this.resolver.visit(node.inputs);
        this.resolver.visit(node.outputs);
        this.resolver.visit(node.when);
        this.resolver.visit(node.exec);
        this.resolver.visit(node.stub);
    }

    @Override
    public void visitFunction(FunctionNode node) {
        for (Parameter param : node.getParameters()) {
            param.setInitialExpression(this.resolver.transform(param.getInitialExpression()));
            this.resolver.resolveOrFail(param.getType(), (ASTNode)param.getType());
        }
        this.resolver.resolveOrFail(node.getReturnType(), (ASTNode)node);
        this.resolver.visit(node.getCode());
    }

    @Override
    public void visitOutput(OutputNode node) {
        this.resolver.visit(node.body);
    }

    private class DynamicVariablesVisitor
    extends ScriptVisitorSupport {
        private DynamicVariablesVisitor() {
        }

        protected SourceUnit getSourceUnit() {
            return ScriptResolveVisitor.this.sourceUnit;
        }

        public void visitVariableExpression(VariableExpression node) {
            Variable variable = node.getAccessedVariable();
            if (variable instanceof DynamicVariable) {
                ScriptResolveVisitor.this.resolver.addError("`" + node.getName() + "` is not defined", (ASTNode)node);
            }
        }
    }
}

