/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import nextflow.script.control.Compiler;
import nextflow.script.control.ModuleResolver;
import nextflow.script.control.ResolveIncludeVisitor;
import nextflow.script.control.ScriptResolveVisitor;
import nextflow.script.control.TypeCheckingVisitor;
import nextflow.script.parser.ScriptParserPluginFactory;
import nextflow.script.types.Types;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ParserPluginFactory;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;

public class ScriptParser {
    private Compiler compiler;

    public ScriptParser() {
        CompilerConfiguration config = ScriptParser.getConfig();
        GroovyClassLoader classLoader = new GroovyClassLoader();
        this.compiler = new Compiler(config, classLoader);
    }

    public Compiler compiler() {
        return this.compiler;
    }

    public SourceUnit parse(File file) {
        SourceUnit source = this.compiler.createSourceUnit(file);
        this.parse0(source);
        return source;
    }

    public SourceUnit parse(String name, String contents) {
        SourceUnit source = this.compiler.createSourceUnit(name, contents);
        this.parse0(source);
        return source;
    }

    private void parse0(SourceUnit source) {
        URI uri = source.getSource().getURI();
        if (this.compiler.getSource(uri) != null) {
            return;
        }
        this.compiler.addSource(source);
        this.compiler.compile(source);
    }

    public void analyze() {
        ArrayList<SourceUnit> sources = new ArrayList<SourceUnit>(this.compiler.getSources().values());
        for (SourceUnit source : sources) {
            new ModuleResolver(this.compiler()).resolve(source, uri -> this.compiler.createSourceUnit(new File((URI)uri)));
        }
        for (SourceUnit source : this.compiler.getSources().values()) {
            ResolveIncludeVisitor includeResolver = new ResolveIncludeVisitor(source, this.compiler);
            includeResolver.visit();
            for (SyntaxErrorMessage error : includeResolver.getErrors()) {
                source.getErrorCollector().addErrorAndContinue((Message)error);
            }
            new ScriptResolveVisitor(source, this.compiler.compilationUnit(), Types.DEFAULT_SCRIPT_IMPORTS, Collections.emptyList()).visit();
            if (source.getErrorCollector().hasErrors()) continue;
            new TypeCheckingVisitor(source, false).visit();
        }
    }

    private static CompilerConfiguration getConfig() {
        CompilerConfiguration config = new CompilerConfiguration();
        config.setPluginFactory((ParserPluginFactory)new ScriptParserPluginFactory());
        config.setWarningLevel(2);
        return config;
    }
}

