/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import groovy.lang.Tuple;
import groovy.lang.Tuple2;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import nextflow.script.ast.ASTNodeMarker;
import nextflow.script.control.PhaseAware;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.tools.ClosureUtils;
import org.codehaus.groovy.control.ClassNodeResolver;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.Message;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.runtime.memoize.UnlimitedConcurrentCache;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Types;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class ResolveVisitor
extends ClassCodeExpressionTransformer {
    public static final String[] DEFAULT_PACKAGE_PREFIXES = new String[]{"java.lang.", "java.util.", "java.io.", "java.net.", "groovy.lang.", "groovy.util."};
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    private SourceUnit sourceUnit;
    private CompilationUnit compilationUnit;
    private ClassNodeResolver classNodeResolver = new ClassNodeResolver();
    private List<ClassNode> defaultImports;
    private List<ClassNode> libImports;
    private static final Map<String, Set<String>> DEFAULT_IMPORT_CLASS_AND_PACKAGES_CACHE = new UnlimitedConcurrentCache();
    private boolean inVariableDeclaration;

    public ResolveVisitor(SourceUnit sourceUnit, CompilationUnit compilationUnit, List<ClassNode> defaultImports, List<ClassNode> libImports) {
        this.sourceUnit = sourceUnit;
        this.compilationUnit = compilationUnit;
        this.defaultImports = defaultImports;
        this.libImports = libImports;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visitCatchStatement(CatchStatement cs) {
        this.resolveOrFail(cs.getExceptionType(), (ASTNode)cs);
        if (ClassHelper.isDynamicTyped((ClassNode)cs.getExceptionType())) {
            cs.getVariable().setType(ClassHelper.make(Exception.class));
        }
        super.visitCatchStatement(cs);
    }

    public void resolveOrFail(ClassNode type, ASTNode node) {
        if (!this.resolve(type)) {
            this.addError("`" + type.toString(false) + "` is not defined", node);
        }
    }

    public boolean resolve(ClassNode type) {
        GenericsType[] genericsTypes = type.getGenericsTypes();
        this.resolveGenericsTypes(genericsTypes);
        if (type.isPrimaryClassNode()) {
            return true;
        }
        if (type.isResolved()) {
            return true;
        }
        if (this.resolveFromModule(type)) {
            return true;
        }
        if (this.resolveFromLibImports(type)) {
            return true;
        }
        if (!type.hasPackageName() && this.resolveFromDefaultImports(type)) {
            return true;
        }
        return this.resolveFromClassResolver(type.getName()) != null;
    }

    private boolean resolveGenericsTypes(GenericsType[] types) {
        if (types == null) {
            return true;
        }
        boolean resolved = true;
        for (GenericsType type : types) {
            if (this.resolveGenericsType(type)) continue;
            resolved = false;
        }
        return resolved;
    }

    private boolean resolveGenericsType(GenericsType genericsType) {
        if (genericsType.isResolved()) {
            return true;
        }
        ClassNode type = genericsType.getType();
        this.resolveOrFail(type, (ASTNode)genericsType);
        if (this.resolveGenericsTypes(type.getGenericsTypes())) {
            genericsType.setResolved(genericsType.getType().isResolved());
        }
        return genericsType.isResolved();
    }

    protected boolean resolveFromModule(ClassNode type) {
        String name = type.getName();
        ModuleNode module = this.sourceUnit.getAST();
        for (ClassNode cn : module.getClasses()) {
            if (!name.equals(cn.getName())) continue;
            if (cn != type) {
                type.setRedirect(cn);
            }
            return true;
        }
        return false;
    }

    protected boolean resolveFromLibImports(ClassNode type) {
        String name = type.getName();
        for (ClassNode cn : this.libImports) {
            if (!name.equals(cn.getName())) continue;
            type.setRedirect(cn);
            return true;
        }
        return false;
    }

    protected boolean resolveFromDefaultImports(ClassNode type) {
        String typeName = type.getName();
        for (ClassNode cn : this.defaultImports) {
            if (!typeName.equals(cn.getNameWithoutPackage())) continue;
            type.setRedirect(cn);
            return true;
        }
        Set<String> packagePrefixSet = DEFAULT_IMPORT_CLASS_AND_PACKAGES_CACHE.get(typeName);
        if (packagePrefixSet != null && this.resolveFromDefaultImports(type, packagePrefixSet.toArray(EMPTY_STRING_ARRAY))) {
            return true;
        }
        if (this.resolveFromDefaultImports(type, DEFAULT_PACKAGE_PREFIXES)) {
            return true;
        }
        if ("BigInteger".equals(typeName)) {
            type.setRedirect(ClassHelper.BigInteger_TYPE);
            return true;
        }
        if ("BigDecimal".equals(typeName)) {
            type.setRedirect(ClassHelper.BigDecimal_TYPE);
            return true;
        }
        return false;
    }

    protected boolean resolveFromDefaultImports(ClassNode type, String[] packagePrefixes) {
        String typeName = type.getName();
        for (String packagePrefix : packagePrefixes) {
            ClassNode redirect = this.resolveFromClassResolver(packagePrefix + typeName);
            if (redirect == null) continue;
            type.setRedirect(redirect);
            if (packagePrefixes == DEFAULT_PACKAGE_PREFIXES) {
                Set packagePrefixSet = DEFAULT_IMPORT_CLASS_AND_PACKAGES_CACHE.computeIfAbsent(typeName, key -> new HashSet(2));
                packagePrefixSet.add(packagePrefix);
            }
            return true;
        }
        return false;
    }

    protected ClassNode resolveFromClassResolver(String name) {
        ClassNodeResolver.LookupResult lookupResult = this.classNodeResolver.resolveName(name, this.compilationUnit);
        if (lookupResult == null) {
            return null;
        }
        if (!lookupResult.isClassNode()) {
            throw new GroovyBugError("class resolver lookup result is not a class node");
        }
        return lookupResult.getClassNode();
    }

    public Expression transform(Expression exp) {
        Expression result;
        if (exp == null) {
            return null;
        }
        if (exp instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)exp;
            result = this.transformVariableExpression(ve);
        } else if (exp instanceof PropertyExpression) {
            PropertyExpression pe = (PropertyExpression)exp;
            result = this.transformPropertyExpression(pe);
        } else if (exp instanceof DeclarationExpression) {
            DeclarationExpression de = (DeclarationExpression)exp;
            result = this.transformDeclarationExpression(de);
        } else if (exp instanceof BinaryExpression) {
            BinaryExpression be = (BinaryExpression)exp;
            result = this.transformBinaryExpression(be);
        } else if (exp instanceof MethodCallExpression) {
            MethodCallExpression mce = (MethodCallExpression)exp;
            result = this.transformMethodCallExpression(mce);
        } else if (exp instanceof ClosureExpression) {
            ClosureExpression ce = (ClosureExpression)exp;
            result = this.transformClosureExpression(ce);
        } else if (exp instanceof ConstructorCallExpression) {
            ConstructorCallExpression cce = (ConstructorCallExpression)exp;
            result = this.transformConstructorCallExpression(cce);
        } else {
            this.resolveOrFail(exp.getType(), (ASTNode)exp);
            result = exp.transformExpression((ExpressionTransformer)this);
        }
        if (result != null && result != exp) {
            result.setSourcePosition((ASTNode)exp);
        }
        return result;
    }

    protected Expression transformVariableExpression(VariableExpression ve) {
        Variable v = ve.getAccessedVariable();
        if (v instanceof DynamicVariable) {
            String name = ve.getName();
            ClassNode type = ClassHelper.make((String)name);
            boolean isClass = type.isResolved();
            if (!isClass) {
                isClass = this.resolve(type);
            }
            if (isClass) {
                return new ClassExpression(type);
            }
        }
        if (this.inVariableDeclaration) {
            this.resolveOrFail(ve.getType(), (ASTNode)ve);
            ClassNode origin = ve.getOriginType();
            if (origin != ve.getType()) {
                this.resolveOrFail(origin, (ASTNode)ve);
            }
        }
        return ve;
    }

    protected Expression transformPropertyExpression(PropertyExpression pe) {
        Expression objectExpression = this.transform(pe.getObjectExpression());
        Expression property = this.transform(pe.getProperty());
        PropertyExpression result = new PropertyExpression(objectExpression, property, pe.isSafe());
        result.setSpreadSafe(pe.isSpreadSafe());
        String className = ResolveVisitor.lookupClassName(result);
        if (className != null) {
            ClassNode type = ClassHelper.make((String)className);
            type.putNodeMetaData((Object)ASTNodeMarker.FULLY_QUALIFIED, (Object)true);
            if (this.resolve(type)) {
                return new ClassExpression(type);
            }
        }
        return result;
    }

    private static String lookupClassName(PropertyExpression node) {
        boolean doInitialClassTest = true;
        StringBuilder name = new StringBuilder(32);
        PropertyExpression expr = node;
        while (expr != null && name != null) {
            Tuple2<StringBuilder, Boolean> classNameInfo;
            if (expr instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)expr;
                String varName = ve.getName();
                classNameInfo = ResolveVisitor.makeClassName(doInitialClassTest, name, varName);
                name = (StringBuilder)classNameInfo.getV1();
                doInitialClassTest = (Boolean)classNameInfo.getV2();
                break;
            }
            if (expr instanceof PropertyExpression) {
                PropertyExpression pe = expr;
                String property = pe.getPropertyAsString();
                classNameInfo = ResolveVisitor.makeClassName(doInitialClassTest, name, property);
                name = (StringBuilder)classNameInfo.getV1();
                doInitialClassTest = (Boolean)classNameInfo.getV2();
                expr = pe.getObjectExpression();
                continue;
            }
            return null;
        }
        if (name == null || name.length() == 0) {
            return null;
        }
        return name.toString();
    }

    private static Tuple2<StringBuilder, Boolean> makeClassName(boolean doInitialClassTest, StringBuilder name, String varName) {
        if (doInitialClassTest) {
            return ResolveVisitor.isValidClassName(varName) ? Tuple.tuple((Object)new StringBuilder(varName), (Object)Boolean.FALSE) : Tuple.tuple(null, (Object)Boolean.TRUE);
        }
        name.insert(0, varName + ".");
        return Tuple.tuple((Object)name, (Object)Boolean.FALSE);
    }

    private static boolean isValidClassName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        return !Character.isLowerCase(name.charAt(0));
    }

    protected Expression transformDeclarationExpression(DeclarationExpression de) {
        this.inVariableDeclaration = true;
        Expression left = this.transform(de.getLeftExpression());
        this.inVariableDeclaration = false;
        if (left instanceof ClassExpression) {
            this.addError("`" + left.getType().getName() + "` is already defined as a type", (ASTNode)de.getLeftExpression());
            return de;
        }
        Expression right = this.transform(de.getRightExpression());
        if (right == de.getRightExpression()) {
            return de;
        }
        DeclarationExpression result = new DeclarationExpression(left, de.getOperation(), right);
        result.setDeclaringClass(de.getDeclaringClass());
        return result;
    }

    protected Expression transformBinaryExpression(BinaryExpression be) {
        Expression left = this.transform(be.getLeftExpression());
        if (Types.isAssignment((int)be.getOperation().getType()) && left instanceof ClassExpression) {
            this.addError("`" + left.getType().getName() + "` is already defined as a type", (ASTNode)be.getLeftExpression());
            return be;
        }
        be.setLeftExpression(left);
        be.setRightExpression(this.transform(be.getRightExpression()));
        return be;
    }

    protected Expression transformMethodCallExpression(MethodCallExpression mce) {
        Expression args = this.transform(mce.getArguments());
        Expression method = this.transform(mce.getMethod());
        Expression object = mce.getObjectExpression();
        if (!mce.isImplicitThis()) {
            object = this.transform(object);
        }
        MethodCallExpression result = new MethodCallExpression(object, method, args);
        result.setMethodTarget(mce.getMethodTarget());
        result.setImplicitThis(mce.isImplicitThis());
        result.setSpreadSafe(mce.isSpreadSafe());
        result.setSafe(mce.isSafe());
        result.copyNodeMetaData((ASTNode)mce);
        return result;
    }

    protected Expression transformClosureExpression(ClosureExpression ce) {
        for (Parameter param : ClosureUtils.getParametersSafe((ClosureExpression)ce)) {
            this.resolveOrFail(param.getType(), (ASTNode)ce);
            if (!param.hasInitialExpression()) continue;
            param.setInitialExpression(this.transform(param.getInitialExpression()));
        }
        this.visit(ce.getCode());
        return ce;
    }

    protected Expression transformConstructorCallExpression(ConstructorCallExpression cce) {
        ClassNode cceType = cce.getType();
        this.resolveOrFail(cceType, (ASTNode)cce);
        if (cceType.isAbstract()) {
            this.addError("`" + cceType.getName() + "` is an abstract type and cannot be constructed directly", (ASTNode)cce);
        }
        return cce.transformExpression((ExpressionTransformer)this);
    }

    public void addError(String message, ASTNode node) {
        UnresolvedNameError cause = new UnresolvedNameError(message, node);
        SyntaxErrorMessage errorMessage = new SyntaxErrorMessage((SyntaxException)cause, this.sourceUnit);
        this.sourceUnit.getErrorCollector().addErrorAndContinue((Message)errorMessage);
    }

    static {
        DEFAULT_IMPORT_CLASS_AND_PACKAGES_CACHE.putAll(VMPluginFactory.getPlugin().getDefaultImportClasses(DEFAULT_PACKAGE_PREFIXES));
    }

    private class UnresolvedNameError
    extends SyntaxException
    implements PhaseAware {
        public UnresolvedNameError(String message, ASTNode node) {
            super(message, node);
        }

        @Override
        public int getPhase() {
            return 3;
        }
    }
}

