/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.IncludeModuleNode;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.ScriptVisitorSupport;
import nextflow.script.control.Compiler;
import nextflow.script.control.PhaseAware;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.messages.SyntaxErrorMessage;
import org.codehaus.groovy.syntax.SyntaxException;

public class ResolveIncludeVisitor
extends ScriptVisitorSupport {
    private SourceUnit sourceUnit;
    private URI uri;
    private Compiler compiler;
    private Set<URI> changedUris;
    private List<SyntaxErrorMessage> errors = new ArrayList<SyntaxErrorMessage>();
    private boolean changed;

    public ResolveIncludeVisitor(SourceUnit sourceUnit, Compiler compiler, Set<URI> changedUris) {
        this.sourceUnit = sourceUnit;
        this.uri = sourceUnit.getSource().getURI();
        this.compiler = compiler;
        this.changedUris = changedUris;
    }

    public ResolveIncludeVisitor(SourceUnit sourceUnit, Compiler compiler) {
        this(sourceUnit, compiler, null);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visit() {
        ModuleNode moduleNode = this.sourceUnit.getAST();
        if (moduleNode instanceof ScriptNode) {
            ScriptNode sn = (ScriptNode)moduleNode;
            super.visit(sn);
        }
    }

    @Override
    public void visitInclude(IncludeNode node) {
        String source = node.source.getText();
        if (source.startsWith("plugin/")) {
            ResolveIncludeVisitor.setPlaceholderTargets(node);
            return;
        }
        URI includeUri = ResolveIncludeVisitor.getIncludeUri(this.uri, source);
        if (!this.isIncludeStale(node, includeUri)) {
            return;
        }
        this.changed = true;
        for (IncludeModuleNode module : node.modules) {
            module.setTarget(null);
        }
        SourceUnit includeUnit = this.compiler.getSource(includeUri);
        if (includeUnit == null) {
            this.addError("Invalid include source: '" + includeUri.getPath() + "'", node);
            return;
        }
        if (includeUnit.getAST() == null) {
            this.addError("Module could not be parsed: '" + includeUri.getPath() + "'", node);
            return;
        }
        List<MethodNode> definitions = this.getDefinitions(includeUri);
        for (IncludeModuleNode module : node.modules) {
            String includedName = module.name;
            Optional<MethodNode> includedNode = definitions.stream().filter(defNode -> includedName.equals(defNode.getName())).findFirst();
            if (!includedNode.isPresent()) {
                this.addError("Included name '" + includedName + "' is not defined in module '" + includeUri.getPath() + "'", node);
                continue;
            }
            module.setTarget(includedNode.get());
        }
    }

    private static void setPlaceholderTargets(IncludeNode node) {
        for (IncludeModuleNode module : node.modules) {
            if (module.getTarget() != null) continue;
            FunctionNode target = new FunctionNode(module.getNameOrAlias());
            module.setTarget(target);
        }
    }

    private static URI getIncludeUri(URI uri, String source) {
        Path includePath = Path.of(uri).getParent().resolve(source);
        if (Files.isDirectory(includePath, new LinkOption[0])) {
            includePath = includePath.resolve("main.nf");
        } else if (!source.endsWith(".nf")) {
            includePath = Path.of(includePath.toString() + ".nf", new String[0]);
        }
        return includePath.normalize().toUri();
    }

    private boolean isIncludeStale(IncludeNode node, URI includeUri) {
        if (this.changedUris == null || this.changedUris.contains(this.uri) || this.changedUris.contains(includeUri)) {
            return true;
        }
        for (IncludeModuleNode module : node.modules) {
            if (module.getTarget() != null) continue;
            return true;
        }
        return false;
    }

    private List<MethodNode> getDefinitions(URI uri) {
        ScriptNode scriptNode = (ScriptNode)this.compiler.getSource(uri).getAST();
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        result.addAll(scriptNode.getWorkflows());
        result.addAll(scriptNode.getProcesses());
        result.addAll(scriptNode.getFunctions());
        return result;
    }

    public void addError(String message, ASTNode node) {
        ResolveIncludeError cause = new ResolveIncludeError(message, node);
        SyntaxErrorMessage errorMessage = new SyntaxErrorMessage((SyntaxException)cause, this.sourceUnit);
        this.errors.add(errorMessage);
    }

    public List<SyntaxErrorMessage> getErrors() {
        return this.errors;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private class ResolveIncludeError
    extends SyntaxException
    implements PhaseAware {
        public ResolveIncludeError(String message, ASTNode node) {
            super(message, node);
        }

        @Override
        public int getPhase() {
            return 2;
        }
    }
}

