/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.control.Compiler;
import org.codehaus.groovy.control.SourceUnit;

public class ModuleResolver {
    private Compiler compiler;

    public ModuleResolver(Compiler compiler) {
        this.compiler = compiler;
    }

    public Set<SourceUnit> resolve(SourceUnit entry, Function<URI, SourceUnit> sourceResolver) {
        HashSet<SourceUnit> modules = new HashSet<SourceUnit>();
        LinkedList<SourceUnit> queuedSources = new LinkedList<SourceUnit>();
        this.compiler.addSource(entry);
        queuedSources.add(entry);
        while (!queuedSources.isEmpty()) {
            SourceUnit source = (SourceUnit)queuedSources.remove();
            if (source.getAST() == null) continue;
            ScriptNode sn = (ScriptNode)source.getAST();
            for (IncludeNode in : sn.getIncludes()) {
                SourceUnit includeSource = this.resolveInclude(in, source, sourceResolver);
                if (includeSource == null) continue;
                modules.add(includeSource);
                queuedSources.add(includeSource);
            }
        }
        return modules;
    }

    private SourceUnit resolveInclude(IncludeNode node, SourceUnit sourceUnit, Function<URI, SourceUnit> sourceResolver) {
        String source = node.source.getText();
        if (source.startsWith("plugin/")) {
            return null;
        }
        URI uri = sourceUnit.getSource().getURI();
        URI includeUri = ModuleResolver.getIncludeUri(uri, source);
        if (this.compiler.getSource(includeUri) != null) {
            return null;
        }
        if (!Files.exists(Path.of(includeUri), new LinkOption[0])) {
            return null;
        }
        SourceUnit includeSource = sourceResolver.apply(includeUri);
        this.compiler.addSource(includeSource);
        this.compiler.compile(includeSource);
        if (includeSource.getAST() == null) {
            return null;
        }
        return includeSource;
    }

    private static URI getIncludeUri(URI uri, String source) {
        Path includePath = Path.of(uri).getParent().resolve(source);
        if (Files.isDirectory(includePath, new LinkOption[0])) {
            includePath = includePath.resolve("main.nf");
        } else if (!source.endsWith(".nf")) {
            includePath = Path.of(includePath.toString() + ".nf", new String[0]);
        }
        return includePath.normalize().toUri();
    }
}

