/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.control.SourceUnit;

public class GStringToLazyVisitor
extends ClassCodeVisitorSupport {
    private SourceUnit sourceUnit;
    private boolean inClosure;

    public GStringToLazyVisitor(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visitClosureExpression(ClosureExpression node) {
        this.inClosure = true;
        try {
            super.visitClosureExpression(node);
        }
        finally {
            this.inClosure = false;
        }
    }

    public void visitGStringExpression(GStringExpression node) {
        if (!this.inClosure) {
            this.transformToLazy(node);
        }
    }

    private void transformToLazy(GStringExpression node) {
        int i;
        List values = node.getValues();
        Expression[] lazyValues = new Expression[values.size()];
        for (i = 0; i < values.size(); ++i) {
            Expression value = (Expression)values.get(i);
            if (value instanceof ClosureExpression) {
                return;
            }
            lazyValues[i] = this.wrapExpressionInClosure(value);
        }
        for (i = 0; i < values.size(); ++i) {
            values.set(i, lazyValues[i]);
        }
    }

    protected ClosureExpression wrapExpressionInClosure(Expression node) {
        return GeneralUtils.closureX(null, (Statement)GeneralUtils.block((Statement[])new Statement[]{GeneralUtils.stmt((Expression)node)}));
    }
}

