/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.control;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import nextflow.script.control.LazyErrorCollector;
import org.antlr.v4.runtime.RecognitionException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.ErrorCollector;
import org.codehaus.groovy.control.SourceUnit;

public class Compiler {
    private CompilationUnit compilationUnit;
    private Map<URI, SourceUnit> sourcesByUri = new HashMap<URI, SourceUnit>();

    public Compiler(CompilerConfiguration configuration, GroovyClassLoader classLoader) {
        this(new CompilationUnit(configuration, null, classLoader));
    }

    public Compiler(CompilationUnit compilationUnit) {
        this.compilationUnit = compilationUnit;
    }

    public CompilationUnit compilationUnit() {
        return this.compilationUnit;
    }

    protected CompilerConfiguration configuration() {
        return this.compilationUnit().getConfiguration();
    }

    protected GroovyClassLoader classLoader() {
        return this.compilationUnit().getClassLoader();
    }

    public SourceUnit createSourceUnit(File file) {
        return new SourceUnit(file, this.configuration(), this.classLoader(), this.createErrorCollector());
    }

    public SourceUnit createSourceUnit(String name, String contents) {
        return new SourceUnit(name, contents, this.configuration(), this.classLoader(), this.createErrorCollector());
    }

    protected ErrorCollector createErrorCollector() {
        return new LazyErrorCollector(this.configuration());
    }

    public void addSource(SourceUnit source) {
        this.sourcesByUri.put(source.getSource().getURI(), source);
    }

    public Map<URI, SourceUnit> getSources() {
        return this.sourcesByUri;
    }

    public SourceUnit getSource(URI uri) {
        return this.sourcesByUri.get(uri);
    }

    public void compile(SourceUnit source) {
        try {
            source.parse();
            source.buildAST();
        }
        catch (RecognitionException recognitionException) {
        }
        catch (CompilationFailedException compilationFailedException) {
            // empty catch block
        }
    }
}

