/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.ast;

import nextflow.script.ast.ASTUtils;
import nextflow.script.ast.AssignmentExpression;
import nextflow.script.types.NamedTuple;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class WorkflowNode
extends MethodNode {
    public final Statement takes;
    public final Statement main;
    public final Statement emits;
    public final Statement publishers;

    public WorkflowNode(String name, Statement takes, Statement main, Statement emits, Statement publishers) {
        super(name, 0, WorkflowNode.dummyReturnType(emits), WorkflowNode.dummyParams(takes), ClassNode.EMPTY_ARRAY, (Statement)EmptyStatement.INSTANCE);
        this.takes = takes;
        this.main = main;
        this.emits = emits;
        this.publishers = publishers;
    }

    public boolean isEntry() {
        return this.getName() == null;
    }

    public boolean isCodeSnippet() {
        return this.getLineNumber() == -1;
    }

    private static Parameter[] dummyParams(Statement takes) {
        return (Parameter[])ASTUtils.asBlockStatements(takes).stream().map(stmt -> new Parameter(ClassHelper.dynamicType(), "")).toArray(Parameter[]::new);
    }

    private static ClassNode dummyReturnType(Statement emits) {
        ClassNode cn = new ClassNode(NamedTuple.class);
        ASTUtils.asBlockStatements(emits).stream().map(stmt -> ((ExpressionStatement)stmt).getExpression()).map(emit -> WorkflowNode.emitName(emit)).filter(name -> name != null).forEach(name -> {
            ClassNode type = ClassHelper.dynamicType();
            FieldNode fn = new FieldNode(name, 1, type, cn, null);
            fn.setDeclaringClass(cn);
            cn.addField(fn);
        });
        return cn;
    }

    private static String emitName(Expression emit) {
        if (emit instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)emit;
            return ve.getName();
        }
        if (emit instanceof AssignmentExpression) {
            AssignmentExpression ae = (AssignmentExpression)emit;
            VariableExpression left = (VariableExpression)ae.getLeftExpression();
            return left.getName();
        }
        return null;
    }
}

