/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.ast;

import nextflow.script.ast.FeatureFlagNode;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.OutputBlockNode;
import nextflow.script.ast.OutputNode;
import nextflow.script.ast.ParamNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.ScriptNode;
import nextflow.script.ast.ScriptVisitor;
import nextflow.script.ast.WorkflowNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;

public abstract class ScriptVisitorSupport
extends ClassCodeVisitorSupport
implements ScriptVisitor {
    @Override
    public void visit(ScriptNode script) {
        for (FeatureFlagNode featureFlag : script.getFeatureFlags()) {
            this.visitFeatureFlag(featureFlag);
        }
        for (IncludeNode includeNode : script.getIncludes()) {
            this.visitInclude(includeNode);
        }
        for (ParamNode paramNode : script.getParams()) {
            this.visitParam(paramNode);
        }
        for (WorkflowNode workflowNode : script.getWorkflows()) {
            this.visitWorkflow(workflowNode);
        }
        for (ProcessNode processNode : script.getProcesses()) {
            this.visitProcess(processNode);
        }
        for (FunctionNode functionNode : script.getFunctions()) {
            this.visitFunction(functionNode);
        }
        for (ClassNode classNode : script.getClasses()) {
            if (!classNode.isEnum()) continue;
            this.visitEnum(classNode);
        }
        if (script.getOutputs() != null) {
            this.visitOutputs(script.getOutputs());
        }
    }

    @Override
    public void visitFeatureFlag(FeatureFlagNode node) {
    }

    @Override
    public void visitInclude(IncludeNode node) {
        this.visit((Expression)node.source);
    }

    @Override
    public void visitParam(ParamNode node) {
        this.visit(node.value);
    }

    @Override
    public void visitWorkflow(WorkflowNode node) {
        this.visit(node.takes);
        this.visit(node.main);
        this.visit(node.emits);
        this.visit(node.publishers);
    }

    @Override
    public void visitProcess(ProcessNode node) {
        this.visit(node.directives);
        this.visit(node.inputs);
        this.visit(node.outputs);
        this.visit(node.when);
        this.visit(node.exec);
        this.visit(node.stub);
    }

    @Override
    public void visitFunction(FunctionNode node) {
        this.visit(node.getCode());
    }

    @Override
    public void visitEnum(ClassNode node) {
        for (FieldNode fn : node.getFields()) {
            this.visitField(fn);
        }
    }

    @Override
    public void visitOutputs(OutputBlockNode node) {
        for (OutputNode output : node.declarations) {
            this.visitOutput(output);
        }
    }

    @Override
    public void visitOutput(OutputNode node) {
        this.visit(node.body);
    }

    public void visitMethodCallExpression(MethodCallExpression node) {
        if (!node.isImplicitThis()) {
            node.getObjectExpression().visit((GroovyCodeVisitor)this);
        }
        node.getMethod().visit((GroovyCodeVisitor)this);
        node.getArguments().visit((GroovyCodeVisitor)this);
    }
}

