/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.ast;

import java.util.ArrayList;
import java.util.List;
import nextflow.script.ast.FeatureFlagNode;
import nextflow.script.ast.FunctionNode;
import nextflow.script.ast.IncludeNode;
import nextflow.script.ast.OutputBlockNode;
import nextflow.script.ast.ParamNode;
import nextflow.script.ast.ProcessNode;
import nextflow.script.ast.WorkflowNode;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.control.SourceUnit;

public class ScriptNode
extends ModuleNode {
    private String shebang;
    private List<FeatureFlagNode> featureFlags = new ArrayList<FeatureFlagNode>();
    private List<IncludeNode> includes = new ArrayList<IncludeNode>();
    private List<ParamNode> params = new ArrayList<ParamNode>();
    private WorkflowNode entry;
    private OutputBlockNode outputs;
    private List<WorkflowNode> workflows = new ArrayList<WorkflowNode>();
    private List<ProcessNode> processes = new ArrayList<ProcessNode>();
    private List<FunctionNode> functions = new ArrayList<FunctionNode>();

    public ScriptNode(SourceUnit sourceUnit) {
        super(sourceUnit);
    }

    public String getShebang() {
        return this.shebang;
    }

    public List<ASTNode> getDeclarations() {
        ArrayList<ASTNode> declarations = new ArrayList<ASTNode>();
        declarations.addAll(this.featureFlags);
        declarations.addAll(this.includes);
        declarations.addAll(this.params);
        if (this.entry != null) {
            declarations.add((ASTNode)this.entry);
        }
        if (this.outputs != null) {
            declarations.add(this.outputs);
        }
        for (WorkflowNode wn : this.workflows) {
            if (wn.isEntry()) continue;
            declarations.add((ASTNode)wn);
        }
        declarations.addAll(this.processes);
        declarations.addAll(this.functions);
        for (ClassNode cn : this.getClasses()) {
            if (!cn.isEnum()) continue;
            declarations.add((ASTNode)cn);
        }
        return declarations;
    }

    public List<FeatureFlagNode> getFeatureFlags() {
        return this.featureFlags;
    }

    public List<IncludeNode> getIncludes() {
        return this.includes;
    }

    public List<ParamNode> getParams() {
        return this.params;
    }

    public WorkflowNode getEntry() {
        return this.entry;
    }

    public OutputBlockNode getOutputs() {
        return this.outputs;
    }

    public List<WorkflowNode> getWorkflows() {
        return this.workflows;
    }

    public List<ProcessNode> getProcesses() {
        return this.processes;
    }

    public List<FunctionNode> getFunctions() {
        return this.functions;
    }

    public void setShebang(String shebang) {
        this.shebang = shebang;
    }

    public void addFeatureFlag(FeatureFlagNode featureFlag) {
        this.featureFlags.add(featureFlag);
    }

    public void addInclude(IncludeNode includeNode) {
        this.includes.add(includeNode);
    }

    public void addParam(ParamNode paramNode) {
        this.params.add(paramNode);
    }

    public void setEntry(WorkflowNode entry) {
        this.entry = entry;
    }

    public void setOutputs(OutputBlockNode outputs) {
        this.outputs = outputs;
    }

    public void addWorkflow(WorkflowNode workflowNode) {
        this.workflows.add(workflowNode);
    }

    public void addProcess(ProcessNode processNode) {
        this.processes.add(processNode);
    }

    public void addFunction(FunctionNode functionNode) {
        this.functions.add(functionNode);
    }
}

