/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.ast;

import java.util.Optional;
import nextflow.script.ast.ASTUtils;
import nextflow.script.types.Channel;
import nextflow.script.types.NamedTuple;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.Statement;

public class ProcessNode
extends MethodNode {
    public final Statement directives;
    public final Statement inputs;
    public final Statement outputs;
    public final Expression when;
    public final String type;
    public final Statement exec;
    public final Statement stub;

    public ProcessNode(String name, Statement directives, Statement inputs, Statement outputs, Expression when, String type, Statement exec, Statement stub) {
        super(name, 0, ProcessNode.dummyReturnType(outputs), ProcessNode.dummyParams(inputs), ClassNode.EMPTY_ARRAY, (Statement)EmptyStatement.INSTANCE);
        this.directives = directives;
        this.inputs = inputs;
        this.outputs = outputs;
        this.when = when;
        this.type = type;
        this.exec = exec;
        this.stub = stub;
    }

    private static Parameter[] dummyParams(Statement inputs) {
        return (Parameter[])ASTUtils.asBlockStatements(inputs).stream().map(stmt -> new Parameter(ClassHelper.dynamicType(), "")).toArray(Parameter[]::new);
    }

    private static ClassNode dummyReturnType(Statement outputs) {
        ClassNode cn = new ClassNode(NamedTuple.class);
        ASTUtils.asDirectives(outputs).map(call -> ProcessNode.emitName(call)).filter(name -> name != null).forEach(name -> {
            ClassNode type = ClassHelper.makeCached(Channel.class);
            FieldNode fn = new FieldNode(name, 1, type, cn, null);
            fn.setDeclaringClass(cn);
            cn.addField(fn);
        });
        return cn;
    }

    private static String emitName(MethodCallExpression output) {
        return Optional.of(output).flatMap(call -> Optional.ofNullable(ASTUtils.asNamedArgs((MethodCall)call))).flatMap(namedArgs -> namedArgs.stream().filter(entry -> "emit".equals(entry.getKeyExpression().getText())).findFirst()).flatMap(entry -> {
            String string;
            Expression patt0$temp = entry.getValueExpression();
            if (patt0$temp instanceof VariableExpression) {
                VariableExpression ve = (VariableExpression)patt0$temp;
                string = ve.getName();
            } else {
                string = null;
            }
            return Optional.ofNullable(string);
        }).orElse(null);
    }
}

