/*
 * Decompiled with CFR 0.152.
 */
package nextflow.script.ast;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import nextflow.script.ast.ASTNodeMarker;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MethodCall;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.NamedArgumentListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.tools.GeneralUtils;

public class ASTUtils {
    public static Expression createX(Class type, TupleExpression args) {
        return GeneralUtils.ctorX((ClassNode)new ClassNode(type), (Expression)args);
    }

    public static Expression createX(Class type, Expression ... expressions) {
        return GeneralUtils.ctorX((ClassNode)new ClassNode(type), (Expression)GeneralUtils.args((Expression[])expressions));
    }

    public static Expression createX(String name, TupleExpression args) {
        return GeneralUtils.ctorX((ClassNode)ClassHelper.makeWithoutCaching((String)name), (Expression)args);
    }

    public static Expression createX(String name, Expression ... expressions) {
        return GeneralUtils.ctorX((ClassNode)ClassHelper.makeWithoutCaching((String)name), (Expression)GeneralUtils.args((Expression[])expressions));
    }

    public static List<Statement> asBlockStatements(Statement statement) {
        List list;
        if (statement instanceof BlockStatement) {
            BlockStatement block = (BlockStatement)statement;
            list = block.getStatements();
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static ConstantExpression asConstX(Expression expression) {
        ConstantExpression ce;
        return expression instanceof ConstantExpression ? (ce = (ConstantExpression)expression) : null;
    }

    public static Stream<MethodCallExpression> asDirectives(Statement statement) {
        return ASTUtils.asBlockStatements(statement).stream().map(stmt -> ASTUtils.asMethodCallX(stmt)).filter(mce -> mce != null);
    }

    public static BlockStatement asDslBlock(MethodCallExpression call, int argsCount) {
        List<Expression> args = ASTUtils.asMethodCallArguments((MethodCall)call);
        if (args.size() != argsCount) {
            return null;
        }
        Expression lastArg = args.get(args.size() - 1);
        if (!(lastArg instanceof ClosureExpression)) {
            return null;
        }
        ClosureExpression closure = (ClosureExpression)lastArg;
        return (BlockStatement)closure.getCode();
    }

    public static MethodCallExpression asMethodCallX(Statement stmt) {
        if (!(stmt instanceof ExpressionStatement)) {
            return null;
        }
        ExpressionStatement stmtX = (ExpressionStatement)stmt;
        if (!(stmtX.getExpression() instanceof MethodCallExpression)) {
            return null;
        }
        return (MethodCallExpression)stmtX.getExpression();
    }

    public static List<Expression> asMethodCallArguments(MethodCall call) {
        return ((TupleExpression)call.getArguments()).getExpressions();
    }

    public static List<MapEntryExpression> asNamedArgs(MethodCall call) {
        List list;
        Expression expression;
        List<Expression> args = ASTUtils.asMethodCallArguments(call);
        if (args.size() > 0 && (expression = args.get(0)) instanceof NamedArgumentListExpression) {
            NamedArgumentListExpression nale = (NamedArgumentListExpression)expression;
            list = nale.getMapEntryExpressions();
        } else {
            list = Collections.emptyList();
        }
        return list;
    }

    public static VariableExpression asVarX(Statement statement) {
        VariableExpression variableExpression;
        if (statement instanceof ExpressionStatement) {
            ExpressionStatement es = (ExpressionStatement)statement;
            variableExpression = ASTUtils.asVarX(es.getExpression());
        } else {
            variableExpression = null;
        }
        return variableExpression;
    }

    public static VariableExpression asVarX(Expression expression) {
        VariableExpression ve;
        return expression instanceof VariableExpression ? (ve = (VariableExpression)expression) : null;
    }

    public static MethodNode asMethodVariable(Variable variable) {
        PropertyNode pn;
        Object object;
        if (variable instanceof PropertyNode && (object = (pn = (PropertyNode)variable).getNodeMetaData((Object)ASTNodeMarker.METHOD_VARIABLE_TARGET)) instanceof MethodNode) {
            MethodNode mn = (MethodNode)object;
            return mn;
        }
        return null;
    }

    public static MethodNode asMethodOutput(PropertyExpression node) {
        Expression expression = node.getObjectExpression();
        if (expression instanceof VariableExpression) {
            VariableExpression ve = (VariableExpression)expression;
            if ("out".equals(node.getPropertyAsString())) {
                return ASTUtils.asMethodVariable(ve.getAccessedVariable());
            }
        }
        return null;
    }

    public static Optional<AnnotationNode> findAnnotation(AnnotatedNode node, Class type) {
        return node.getAnnotations().stream().filter(an -> an.getClassNode().getName().equals(type.getName())).findFirst();
    }
}

