/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import java.util.List;
import java.util.Map;
import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;

public class K8sConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    When `true`, host paths are automatically mounted into the task pods (default: `false`). Only intended for development purposes when using a single node.\n")
    public boolean autoMountHostPaths;
    @ConfigOption
    @Description(value="    Whether to use Kubernetes `Pod` or `Job` resource type to carry out Nextflow tasks (default: `Pod`).\n")
    public String computeResourceType;
    @ConfigOption
    @Description(value="    The Kubernetes [configuration context](https://kubernetes.io/docs/tasks/access-application-cluster/configure-access-multiple-clusters/) to use.\n")
    public String context;
    @ConfigOption
    @Description(value="    When `true`, both the pod CPU `request` and `limit` are set to the `cpus` directive, otherwise only the `request` is set (default: `false`).\n")
    public boolean cpuLimits;
    @ConfigOption
    @Description(value="    When `true`, includes the hostname of each task in the execution trace (default: `false`).\n")
    public boolean fetchNodeName;
    @ConfigOption
    @Description(value="    The FUSE device plugin to be used when enabling Fusion in unprivileged mode (default: `['nextflow.io/fuse': 1]`).\n")
    public Map fuseDevicePlugin;
    @ConfigOption
    @Description(value="    The Kubernetes HTTP client request connection timeout e.g. `'60s'`.\n")
    public Duration httpConnectTimeout;
    @ConfigOption
    @Description(value="    The Kubernetes HTTP client request connection read timeout e.g. `'60s'`.\n")
    public Duration httpReadTimeout;
    @ConfigOption
    @Description(value="    The path where the workflow is launched and the user data is stored (default: `<volume-claim-mount-path>/<user-name>`). Must be a path in a shared K8s persistent volume.\n")
    public String launchDir;
    @ConfigOption
    @Description(value="    The maximum number of retries for failed requests by the Kubernetes HTTP client (default: 4).\n")
    public int maxErrorRetry;
    @ConfigOption
    @Description(value="    The Kubernetes namespace to use (default: `default`).\n")
    public String namespace;
    @ConfigOption
    @Description(value="    Allows the definition of one or more pod configuration options such as environment variables, config maps, secrets, etc. Allows the same settings as the [pod](https://nextflow.io/docs/latest/process.html#pod) process directive.\n")
    public List pod;
    @ConfigOption
    @Description(value="    The path where Nextflow projects are downloaded (default: `<volume-claim-mount-path>/projects`). Must be a path in a shared K8s persistent volume.\n")
    public String projectDir;
    @ConfigOption
    @Description(value="    The strategy for pulling container images. Can be `IfNotPresent`, `Always`, `Never`.\n\n    [Read more](https://kubernetes.io/docs/concepts/containers/images/#image-pull-policy)\n")
    public String pullPolicy;
    @ConfigOption
    @Description(value="    The user ID to be used to run the containers. Shortcut for the `securityContext` option.\n")
    public String runAsUser;
    @ConfigOption
    @Description(value="    The [security context](https://kubernetes.io/docs/tasks/configure-pod-container/security-context/) to use for all pods.\n")
    public Map securityContext;
    @ConfigOption
    @Description(value="    The Kubernetes [service account name](https://kubernetes.io/docs/tasks/configure-pod-container/configure-service-account/) to use.\n")
    public String serviceAccount;
    @ConfigOption
    @Description(value="    The name of the persistent volume claim where the shared work directory is stored.\n")
    public String storageClaimName;
    @ConfigOption
    @Description(value="    The mount path for the persistent volume claim (default: `/workspace`).\n")
    public String storageMountPath;
    @ConfigOption
    @Description(value="    The path in the persistent volume to be mounted (default: `/`).\n")
    public String storageSubPath;
    @ConfigOption
    @Description(value="    The path of the shared work directory (default: `<user-dir>/work`). Must be a path in a shared K8s persistent volume.\n")
    public String workDir;
}

