/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import java.util.List;
import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.script.dsl.Description;
import nextflow.script.types.MemoryUnit;

public class GoogleBatchConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    The set of allowed locations for VMs to be provisioned (default: no restriction).\n\n    [Read more](https://cloud.google.com/batch/docs/reference/rest/v1/projects.locations.jobs#locationpolicy)\n")
    public List<String> allowedLocations;
    @ConfigOption
    @Description(value="    The size of the virtual machine boot disk, e.g `50.GB` (default: none).\n")
    public MemoryUnit bootDiskSize;
    @ConfigOption
    @Description(value="    The minimum CPU Platform, e.g. `'Intel Skylake'` (default: none).\n\n    [Read more](https://cloud.google.com/compute/docs/instances/specify-min-cpu-platform#specifications)\n")
    public String cpuPlatform;
    @ConfigOption
    @Description(value="    List of custom mount options for `gcsfuse` (default: `['-o rw', '-implicit-dirs']`).\n")
    public List<String> gcsfuseOptions;
    @ConfigOption
    @Description(value="    Max number of execution attempts of a job interrupted by a Compute Engine spot reclaim event (default: `5`).\n")
    public int maxSpotAttempts;
    @ConfigOption
    @Description(value="    The URL of an existing network resource to which the VM will be attached.\n")
    public String network;
    @ConfigOption
    @Description(value="    The network tags to be applied to the instances created by Google Batch jobs (e.g., `['allow-ssh', 'allow-http']`).\n\n    [Read more](https://cloud.google.com/vpc/docs/add-remove-network-tags)\n")
    public List<String> networkTags;
    @ConfigOption
    @Description(value="    The Google service account email to use for the pipeline execution. If not specified, the default Compute Engine service account for the project will be used.\n\n    [Read more](https://www.nextflow.io/docs/latest/google.html#credentials)\n")
    public String serviceAccountEmail;
    @ConfigOption
    @Description(value="    When `true`, enables the usage of *spot* virtual machines (default: `false`).\n")
    public boolean spot;
    @ConfigOption
    @Description(value="    The URL of an existing subnetwork resource in the network to which the VM will be attached.\n")
    public String subnetwork;
    @ConfigOption
    @Description(value="    When `true`, the VM will *not* be provided with a public IP address, and only contain an internal IP.\n")
    public boolean usePrivateAddress;
}

