/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.config.scopes.ExecutorRetryConfig;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;
import nextflow.script.types.MemoryUnit;

public class ExecutorConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    *Used only by the SLURM, LSF, PBS and PBS Pro executors.*\n\n    Specify the project or organisation account that should be charged for running the pipeline jobs.\n")
    public String account;
    @ConfigOption
    @Description(value="    *Used only by the local executor.*\n\n    The maximum number of CPUs made available by the underlying system.\n")
    public int cpus;
    @ConfigOption
    @Description(value="    Determines how often to log the executor status (default: `5 min`).\n")
    public Duration dumpInterval;
    @ConfigOption
    @Description(value="    *Used only by grid executors.*\n\n    Determines how long to wait for the `.exitcode` file to be created after the task has completed, before returning an error status (default: `270 sec`).\n")
    public Duration exitReadTimeout;
    @ConfigOption
    @Description(value="    *Used only by grid executors and Google Batch.*\n\n    Determines the name of jobs submitted to the underlying cluster executor:\n    ```nextflow\n    executor.jobName = { \"$task.name - $task.hash\" }\n    ```\n")
    public String jobName;
    @ConfigOption
    @Description(value="    Determines the number of jobs that can be killed in a single command execution (default: `100`).\n")
    public int killBatchSize = 100;
    @ConfigOption
    @Description(value="    *Used only by the local executor.*\n\n    The maximum amount of memory made available by the underlying system.\n")
    public MemoryUnit memory;
    @ConfigOption
    @Description(value="    The name of the executor to be used (default: `local`).\n")
    public String name;
    @ConfigOption
    @Description(value="    *Used only by the [SLURM](https://nextflow.io/docs/latest/executor.html#slurm) executor.*\n\n    When `true`, memory allocations for SLURM jobs are specified as `--mem-per-cpu <task.memory / task.cpus>` instead of `--mem <task.memory>`.\n")
    public boolean perCpuMemAllocation;
    @ConfigOption
    @Description(value="    *Used only by the [LSF](https://nextflow.io/docs/latest/executor.html#lsf) executor.*\n\n    Enables the *per-job* memory limit mode for LSF jobs.\n")
    public boolean perJobMemLimit;
    @ConfigOption
    @Description(value="    *Used only by the [LSF](https://nextflow.io/docs/latest/executor.html#lsf) executor.*\n\n    Enables the *per-task* memory reserve mode for LSF jobs.\n")
    public boolean perTaskReserve;
    @ConfigOption
    @Description(value="    Determines how often to check for process termination. Default varies for each executor.\n")
    public Duration pollInterval;
    @ConfigOption
    @Description(value="    Determines how job status is retrieved. When `false` only the queue associated with the job execution is queried. When `true` the job status is queried globally i.e. irrespective of the submission queue (default: `false`).\n")
    public boolean queueGlobalStatus;
    @ConfigOption
    @Description(value="    The number of tasks the executor will handle in a parallel manner. A queue size of zero corresponds to no limit. Default varies for each executor.\n")
    public Integer queueSize;
    @ConfigOption
    @Description(value="    *Used only by grid executors.*\n\n    Determines how often to fetch the queue status from the scheduler (default: `1 min`).\n")
    public Duration queueStatInterval;
    @Description(value="    The `executor.retry` scope controls the behavior of retrying failed job submissions.\n\n    [Read more](https://nextflow.io/docs/latest/reference/config.html#executor)\n")
    public ExecutorRetryConfig retry;
    @ConfigOption
    @Description(value="    Determines the max rate of job submission per time unit, for example `'10sec'` (10 jobs per second) or `'50/2min'` (50 jobs every 2 minutes) (default: unlimited).\n")
    public String submitRateLimit;
}

