/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import java.nio.file.Path;
import java.util.List;
import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;

public class CondaConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    Enable Conda execution (default: `false`).\n")
    public boolean enabled;
    @ConfigOption
    @Description(value="    The path where Conda environments are stored.\n")
    public Path cacheDir;
    @ConfigOption
    @Description(value="    The Conda channels that can be used to resolve Conda packages.\n")
    public List<String> channels;
    @ConfigOption
    @Description(value="    Extra command line options to append to the `conda create` command.\n")
    public String createOptions;
    @ConfigOption
    @Description(value="    The amount of time to wait for the Conda environment to be created before failing (default: `20 min`).\n")
    public Duration createTimeout;
    @ConfigOption
    @Description(value="    When `true`, use `mamba` instead of `conda` to create the Conda environments.\n\n    [Read more](https://github.com/mamba-org/mamba)\n")
    public boolean useMamba;
    @ConfigOption
    @Description(value="    When `true`, use `micromamba` instead of `conda` to create the Conda environments.\n\n    [Read more](https://mamba.readthedocs.io/en/latest/user_guide/micromamba.html)\n")
    public boolean useMicromamba;
}

