/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import java.util.Map;
import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.config.schema.PlaceholderName;
import nextflow.config.scopes.AzureBatchPoolConfig;
import nextflow.script.dsl.Description;

public class AzureBatchConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    The batch service account name.\n")
    public String accountName;
    @ConfigOption
    @Description(value="    The batch service account key.\n")
    public String accountKey;
    @ConfigOption
    @Description(value="    Enable the automatic creation of batch pools specified in the Nextflow configuration file (default: `false`).\n")
    public boolean allowPoolCreation;
    @ConfigOption
    @Description(value="    Enable the automatic creation of batch pools depending on the pipeline resources demand (default: `true`).\n")
    public String autoPoolMode;
    @ConfigOption
    @Description(value="    The mode in which the `azcopy` tool is installed by Nextflow (default: `'node'`). The following options are available:\n\n    - `'node'`: the `azcopy` tool is installed once during the pool creation\n    - `'task'`: the `azcopy` tool is installed for each task execution\n    - `'off'`: the `azcopy` tool is not installed\n")
    public String copyToolInstallMode;
    @ConfigOption
    @Description(value="    Delete all jobs when the workflow completes (default: `false`).\n")
    public boolean deleteJobsOnCompletion;
    @ConfigOption
    @Description(value="    Delete all compute node pools when the workflow completes (default: `false`).\n")
    public boolean deletePoolsOnCompletion;
    @ConfigOption
    @Description(value="    Delete each task when it completes (default: `true`).\n")
    public boolean deleteTasksOnCompletion;
    @ConfigOption
    @Description(value="    The batch service endpoint e.g. `https://nfbatch1.westeurope.batch.azure.com`.\n")
    public String endpoint;
    @ConfigOption
    @Description(value="    The name of the batch service region, e.g. `westeurope` or `eastus2`. Not needed when the endpoint is specified.\n")
    public String location;
    @PlaceholderName(value="<name>")
    public Map<String, AzureBatchPoolConfig> pools;
    @ConfigOption
    @Description(value="    When the workflow completes, set all jobs to terminate on task completion (default: `true`).\n")
    public boolean terminateJobsOnCompletion;
}

