/*
 * Decompiled with CFR 0.152.
 */
package nextflow.config.scopes;

import nextflow.config.schema.ConfigOption;
import nextflow.config.schema.ConfigScope;
import nextflow.script.dsl.Description;
import nextflow.script.types.Duration;
import nextflow.script.types.MemoryUnit;

public class AwsClientConfig
implements ConfigScope {
    @ConfigOption
    @Description(value="    Allow the access of public S3 buckets without providing AWS credentials. Any service that does not accept unsigned requests will return a service access error.\n")
    public boolean anonymous;
    @ConfigOption
    @Description(value="    Specify predefined bucket permissions, also known as *canned ACL*. Can be one of `Private`, `PublicRead`, `PublicReadWrite`, `AuthenticatedRead`, `LogDeliveryWrite`, `BucketOwnerRead`, `BucketOwnerFullControl`, or `AwsExecRead`.\n\n    [Read more](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl)\n")
    public String s3Acl;
    @ConfigOption
    @Description(value="    The amount of time to wait (in milliseconds) when initially establishing a connection before timing out.\n")
    public int connectionTimeout;
    @ConfigOption
    @Description(value="    The AWS S3 API entry point e.g. `https://s3-us-west-1.amazonaws.com`. The endpoint must include the protocol prefix e.g. `https://`.\n")
    public String endpoint;
    @ConfigOption
    @Description(value="    The maximum number of allowed open HTTP connections.\n")
    public int maxConnections;
    @ConfigOption
    @Description(value="    The maximum number of retry attempts for failed retryable requests.\n")
    public int maxErrorRetry;
    @ConfigOption
    @Description(value="    The protocol (i.e. HTTP or HTTPS) to use when connecting to AWS.\n")
    public String protocol;
    @ConfigOption
    @Description(value="    The proxy host to connect through.\n")
    public String proxyHost;
    @ConfigOption
    @Description(value="    The port on the proxy host to connect through.\n")
    public int proxyPort;
    @ConfigOption
    @Description(value="    The user name to use when connecting through a proxy.\n")
    public String proxyUsername;
    @ConfigOption
    @Description(value="    The password to use when connecting through a proxy.\n")
    public String proxyPassword;
    @ConfigOption
    @Description(value="    Enable the requester pays feature for S3 buckets.\n")
    public boolean requesterPays;
    @ConfigOption
    @Description(value="    Enable the use of path-based access model that is used to specify the address of an object in S3-compatible storage systems.\n")
    public boolean s3PathStyleAccess;
    @ConfigOption
    @Description(value="    The name of the signature algorithm to use for signing requests made by the client.\n")
    public String signerOverride;
    @ConfigOption
    @Description(value="    The size hint (in bytes) for the low level TCP send buffer.\n")
    public int socketSendBufferSizeHint;
    @ConfigOption
    @Description(value="    The size hint (in bytes) for the low level TCP receive buffer.\n")
    public int socketRecvBufferSizeHint;
    @ConfigOption
    @Description(value="    The amount of time to wait (in milliseconds) for data to be transferred over an established, open connection before the connection is timed out.\n")
    public int socketTimeout;
    @ConfigOption
    @Description(value="    The S3 server side encryption to be used when saving objects on S3, either `AES256` or `aws:kms` values are allowed.\n")
    public String storageEncryption;
    @ConfigOption
    @Description(value="    The AWS KMS key Id to be used to encrypt files stored in the target S3 bucket.\n")
    public String storageKmsKeyId;
    @ConfigOption
    @Description(value="    The HTTP user agent header passed with all HTTP requests.\n")
    public String userAgent;
    @ConfigOption
    @Description(value="    The size of a single part in a multipart upload (default: `100 MB`).\n")
    public MemoryUnit uploadChunkSize;
    @ConfigOption
    @Description(value="    The maximum number of upload attempts after which a multipart upload returns an error (default: `5`).\n")
    public int uploadMaxAttempts;
    @ConfigOption
    @Description(value="    The maximum number of threads used for multipart upload.\n")
    public int uploadMaxThreads;
    @ConfigOption
    @Description(value="    The time to wait after a failed upload attempt to retry the part upload (default: `500ms`).\n")
    public Duration uploadRetrySleep;
    @ConfigOption
    @Description(value="    The S3 storage class applied to stored objects, one of \\[`STANDARD`, `STANDARD_IA`, `ONEZONE_IA`, `INTELLIGENT_TIERING`\\] (default: `STANDARD`).\n")
    public String uploadStorageClass;
}

